/*
 * Decompiled with CFR 0.152.
 */
package net.uiqui.oauth.mock.http;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.uiqui.oauth.mock.http.Request;
import net.uiqui.oauth.mock.http.RequestHandler;
import net.uiqui.oauth.mock.http.impl.RequestImpl;
import net.uiqui.oauth.mock.http.impl.ResponseImpl;
import net.uiqui.oauth.mock.tools.Holder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0007J\u001a\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013J\u0006\u0010\u0016\u001a\u00020\u0011R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/uiqui/oauth/mock/http/ServerInstance;", "", "()V", "bootingLatch", "Lnet/uiqui/oauth/mock/tools/Holder;", "Ljava/util/concurrent/CountDownLatch;", "running", "", "socket", "Ljava/net/ServerSocket;", "starting", "stopping", "stoppingLatch", "getPort", "", "isRunning", "start", "", "handlers", "", "", "Lnet/uiqui/oauth/mock/http/RequestHandler;", "stop", "mock-oauth-server"})
final class ServerInstance {
    @NotNull
    private final Holder<CountDownLatch> bootingLatch = new Holder<CountDownLatch>(new CountDownLatch(1));
    @NotNull
    private final Holder<CountDownLatch> stoppingLatch = new Holder<CountDownLatch>(new CountDownLatch(1));
    @NotNull
    private final Holder<Boolean> starting = new Holder<Boolean>(false);
    @NotNull
    private final Holder<Boolean> running = new Holder<Boolean>(false);
    @NotNull
    private final Holder<Boolean> stopping = new Holder<Boolean>(false);
    @Nullable
    private ServerSocket socket;

    public final void start(@NotNull Map<String, ? extends RequestHandler> handlers) {
        Intrinsics.checkNotNullParameter(handlers, (String)"handlers");
        if (this.running.getValue().booleanValue()) {
            return;
        }
        if (this.stopping.getValue().booleanValue()) {
            this.stoppingLatch.getValue().await();
        }
        if (!this.starting.getValue().booleanValue()) {
            this.starting.setValue(true);
            Thread thread = new Thread(() -> ServerInstance.start$lambda-2(this, handlers));
            boolean bl = false;
            boolean bl2 = false;
            Thread $this$start_u24lambda_u2d3 = thread;
            boolean bl3 = false;
            $this$start_u24lambda_u2d3.setDaemon(true);
            $this$start_u24lambda_u2d3.start();
        }
        this.bootingLatch.getValue().await();
    }

    public final void stop() {
        if (!this.running.getValue().booleanValue()) {
            return;
        }
        if (this.starting.getValue().booleanValue()) {
            this.bootingLatch.getValue().await();
        }
        if (!this.stopping.getValue().booleanValue()) {
            this.stopping.setValue(true);
            ServerSocket serverSocket = this.socket;
            Intrinsics.checkNotNull((Object)serverSocket);
            serverSocket.close();
        }
        this.stoppingLatch.getValue().await();
        this.bootingLatch.setValue(new CountDownLatch(1));
    }

    public final boolean isRunning() {
        return this.running.getValue();
    }

    public final int getPort() {
        if (!this.running.getValue().booleanValue()) {
            throw new IllegalStateException("host port is only available after starting");
        }
        ServerSocket serverSocket = this.socket;
        Intrinsics.checkNotNull((Object)serverSocket);
        return serverSocket.getLocalPort();
    }

    private static final void start$handleRequest(Map<String, ? extends RequestHandler> $handlers, Socket clientSocket) {
        InputStream inputStream = clientSocket.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"clientSocket.getInputStream()");
        Request request = RequestImpl.Companion.parse(inputStream);
        ResponseImpl response = new ResponseImpl(request.getVersion());
        RequestHandler handler = $handlers.get(request.getPath());
        if (handler != null) {
            handler.handle(request, response);
        } else {
            response.setResponseCode(404, "Not Found");
        }
        OutputStream outputStream = clientSocket.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"clientSocket.getOutputStream()");
        response.sendResponse(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void start$lambda-2(ServerInstance this$0, Map $handlers) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$handlers, (String)"$handlers");
        Closeable closeable = new ServerSocket(0, 10);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ServerSocket serverSocket = (ServerSocket)closeable;
            boolean bl3 = false;
            this$0.socket = serverSocket;
            this$0.running.setValue(true);
            this$0.starting.setValue(false);
            this$0.stopping.setValue(false);
            this$0.stoppingLatch.setValue(new CountDownLatch(1));
            this$0.bootingLatch.getValue().countDown();
            while (!this$0.stopping.getValue().booleanValue()) {
                try {
                    Closeable closeable2 = serverSocket.accept();
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Throwable throwable2 = null;
                    try {
                        Socket it = (Socket)closeable2;
                        boolean bl6 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        ServerInstance.start$handleRequest($handlers, it);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                }
                catch (SocketException e) {
                    ServerSocket serverSocket2 = this$0.socket;
                    Intrinsics.checkNotNull((Object)serverSocket2);
                    if (serverSocket2.isClosed()) continue;
                    throw e;
                }
            }
            this$0.running.setValue(false);
            this$0.stoppingLatch.getValue().countDown();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

