/*
 * Decompiled with CFR 0.152.
 */
package net.uiqui.oauth.mock.jwks;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.gen.RSAKeyGenerator;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.net.URI;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.uiqui.oauth.mock.jwks.JWKS;
import net.uiqui.oauth.mock.jwks.PublicKey;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\r2\u0006\u0010\u0011\u001a\u00020\tJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001c\u0010\u0018\u001a\u00020\u00172\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lnet/uiqui/oauth/mock/jwks/JWTGenerator;", "", "()V", "jwtVerifier", "Lcom/nimbusds/jose/crypto/RSASSAVerifier;", "rsaKey", "Lcom/nimbusds/jose/jwk/RSAKey;", "kotlin.jvm.PlatformType", "generate", "", "jwkUri", "Ljava/net/URI;", "claims", "", "getJWKS", "Lnet/uiqui/oauth/mock/jwks/JWKS;", "parseJwt", "jwt", "signJWT", "Lcom/nimbusds/jwt/SignedJWT;", "jwsHeader", "Lcom/nimbusds/jose/JWSHeader;", "jwtPayload", "Lcom/nimbusds/jwt/JWTClaimsSet;", "toJWTClaimsSet", "mock-oauth-server"})
public final class JWTGenerator {
    private final RSAKey rsaKey = (RSAKey)new RSAKeyGenerator(2048).keyUse(KeyUse.SIGNATURE).keyID(UUID.randomUUID().toString()).generate();
    @NotNull
    private final RSASSAVerifier jwtVerifier = new RSASSAVerifier(this.rsaKey.toRSAPublicKey());

    @NotNull
    public final JWKS getJWKS() {
        Map publicKey = this.rsaKey.toPublicJWK().toJSONObject();
        return new JWKS(CollectionsKt.listOf((Object)new PublicKey(String.valueOf(publicKey.get("kty")), String.valueOf(publicKey.get("e")), String.valueOf(publicKey.get("use")), String.valueOf(publicKey.get("kid")), String.valueOf(publicKey.get("n")))));
    }

    @NotNull
    public final String generate(@NotNull URI jwkUri, @NotNull Map<String, ? extends Object> claims) {
        Intrinsics.checkNotNullParameter((Object)jwkUri, (String)"jwkUri");
        Intrinsics.checkNotNullParameter(claims, (String)"claims");
        JWSHeader jwsHeader = new JWSHeader.Builder(JWSAlgorithm.RS256).keyID(this.rsaKey.getKeyID()).type(JOSEObjectType.JWT).jwkURL(jwkUri).build();
        JWTClaimsSet jwtPayload = this.toJWTClaimsSet(claims);
        Intrinsics.checkNotNullExpressionValue((Object)jwsHeader, (String)"jwsHeader");
        SignedJWT signedJWT = this.signJWT(jwsHeader, jwtPayload);
        String string = signedJWT.serialize();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"signedJWT.serialize()");
        return string;
    }

    @NotNull
    public final Map<String, Object> parseJwt(@NotNull String jwt) {
        Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
        SignedJWT signedJWT = SignedJWT.parse((String)jwt);
        if (!signedJWT.verify((JWSVerifier)this.jwtVerifier)) {
            throw new JOSEException("Invalid signature");
        }
        Map map = signedJWT.getJWTClaimsSet().getClaims();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"signedJWT.jwtClaimsSet.claims");
        return map;
    }

    private final JWTClaimsSet toJWTClaimsSet(Map<String, ? extends Object> claims) {
        Date now = new Date();
        JWTClaimsSet.Builder claimBuilder = new JWTClaimsSet.Builder().notBeforeTime(now).expirationTime(new Date(now.getTime() + (long)1800000));
        Map<String, ? extends Object> $this$forEach$iv = claims;
        boolean $i$f$forEach = false;
        Map<String, ? extends Object> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, ? extends Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends Object> element$iv;
            Map.Entry<String, ? extends Object> $dstr$claimName$value = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<String, ? extends Object> entry = $dstr$claimName$value;
            boolean bl3 = false;
            String claimName = entry.getKey();
            Map.Entry<String, ? extends Object> entry2 = $dstr$claimName$value;
            boolean bl4 = false;
            Object value = entry2.getValue();
            claimBuilder.claim(claimName, value);
        }
        JWTClaimsSet jWTClaimsSet = claimBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"claimBuilder.build()");
        return jWTClaimsSet;
    }

    private final SignedJWT signJWT(JWSHeader jwsHeader, JWTClaimsSet jwtPayload) {
        SignedJWT signedJWT = new SignedJWT(jwsHeader, jwtPayload);
        RSASSASigner signer = new RSASSASigner(this.rsaKey);
        signedJWT.sign((JWSSigner)signer);
        return signedJWT;
    }
}

