/*
 * Decompiled with CFR 0.152.
 */
package net.uiqui.oauth.mock.http.impl;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.uiqui.oauth.mock.http.Request;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\n\u001a\u0004\u0018\u00010\u0004H\u0016J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\fH\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u0004H\u0016J\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\fH\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnet/uiqui/oauth/mock/http/impl/RequestImpl;", "Lnet/uiqui/oauth/mock/http/Request;", "()V", "body", "", "headers", "", "method", "uri", "version", "getBody", "getHeaders", "", "getMethod", "getPath", "getQueryParameters", "getUri", "getVersion", "Companion", "mock-oauth-server"})
public final class RequestImpl
implements Request {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String version;
    @Nullable
    private String method;
    @Nullable
    private String uri;
    @NotNull
    private final Map<String, String> headers;
    @Nullable
    private String body;

    public RequestImpl() {
        boolean bl = false;
        this.headers = new LinkedHashMap();
    }

    @Override
    @NotNull
    public String getVersion() {
        String string = this.version;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Override
    @NotNull
    public String getUri() {
        String string = this.uri;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Override
    @NotNull
    public String getMethod() {
        String string = this.method;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Override
    @NotNull
    public String getPath() {
        return StringsKt.substringBefore$default((String)this.getUri(), (String)"?", null, (int)2, null);
    }

    @Override
    @NotNull
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, String> getQueryParameters() {
        String queryParameters = StringsKt.substringAfter((String)this.getUri(), (String)"?", (String)"");
        String[] stringArray = (String[])queryParameters;
        boolean bl = false;
        if (stringArray.length() > 0) {
            void $this$associateTo$iv$iv;
            stringArray = new String[]{"&"};
            Iterable $this$associate$iv = StringsKt.split$default((CharSequence)queryParameters, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                String parameter = (String)element$iv$iv;
                boolean bl2 = false;
                String parameterName = StringsKt.substringBefore$default((String)parameter, (String)"=", null, (int)2, null);
                String parameterValue = StringsKt.substringAfter$default((String)parameter, (String)"=", null, (int)2, null);
                Pair pair = TuplesKt.to((Object)parameterName, (Object)parameterValue);
                boolean bl3 = false;
                map.put(pair.getFirst(), pair.getSecond());
            }
            return destination$iv$iv;
        }
        return MapsKt.emptyMap();
    }

    @Override
    @Nullable
    public String getBody() {
        return this.body;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lnet/uiqui/oauth/mock/http/impl/RequestImpl$Companion;", "", "()V", "decodeRequestBody", "", "reader", "Ljava/io/BufferedReader;", "request", "Lnet/uiqui/oauth/mock/http/impl/RequestImpl;", "decodeRequestHeader", "decodeRequestLine", "parse", "Lnet/uiqui/oauth/mock/http/Request;", "inputStream", "Ljava/io/InputStream;", "mock-oauth-server"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Request parse(@NotNull InputStream inputStream) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            RequestImpl requestImpl = new RequestImpl();
            boolean bl = false;
            boolean bl2 = false;
            RequestImpl request = requestImpl;
            boolean bl3 = false;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, Charsets.UTF_8));
            boolean bl4 = false;
            boolean bl5 = false;
            BufferedReader reader = bufferedReader;
            boolean bl6 = false;
            Companion.decodeRequestLine(reader, request);
            Companion.decodeRequestHeader(reader, request);
            Companion.decodeRequestBody(reader, request);
            return requestImpl;
        }

        private final void decodeRequestLine(BufferedReader reader, RequestImpl request) {
            String[] stringArray = reader.readLine();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"reader.readLine()");
            CharSequence charSequence = (CharSequence)stringArray;
            stringArray = new String[]{" "};
            List parts = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            request.method = (String)parts.get(0);
            request.uri = (String)parts.get(1);
            request.version = (String)parts.get(2);
        }

        private final void decodeRequestHeader(BufferedReader reader, RequestImpl request) {
            while (true) {
                String line = reader.readLine();
                CharSequence charSequence = line;
                boolean bl = false;
                boolean bl2 = false;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) break;
                Intrinsics.checkNotNullExpressionValue((Object)line, (String)"line");
                String headerName = StringsKt.substringBefore$default((String)line, (String)":", null, (int)2, null);
                Object object = StringsKt.substringAfter$default((String)line, (String)":", null, (int)2, null);
                boolean bl3 = false;
                String string = object;
                if (string == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String headerValue = ((Object)StringsKt.trim((CharSequence)string)).toString();
                object = request.headers;
                bl3 = false;
                object.put(headerName, headerValue);
            }
        }

        private final void decodeRequestBody(BufferedReader reader, RequestImpl request) {
            String string = request.headers.getOrDefault("Content-Length", "0");
            boolean bl = false;
            int contentLen = Integer.parseInt(string);
            if (contentLen > 0) {
                char[] message = new char[contentLen];
                reader.read(message);
                bl = false;
                request.body = new String(message);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

