/*
 * Decompiled with CFR 0.152.
 */
package net.uiqui.oauth.mock.http;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.uiqui.oauth.mock.http.Request;
import net.uiqui.oauth.mock.http.RequestHandler;
import net.uiqui.oauth.mock.http.impl.RequestImpl;
import net.uiqui.oauth.mock.http.impl.ResponseImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0006J\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u000eJ\u0006\u0010\u001a\u001a\u00020\u000eR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lnet/uiqui/oauth/mock/http/HttpServer;", "", "()V", "handlers", "", "", "Lnet/uiqui/oauth/mock/http/RequestHandler;", "localPort", "Ljava/util/concurrent/atomic/AtomicInteger;", "running", "Ljava/util/concurrent/atomic/AtomicBoolean;", "thread", "Ljava/lang/Thread;", "addHandler", "", "path", "handler", "getHost", "getPaths", "", "handleRequest", "clientSocket", "Ljava/net/Socket;", "isRunning", "", "start", "stop", "mock-oauth-server"})
public final class HttpServer {
    @NotNull
    private final Map<String, RequestHandler> handlers;
    @NotNull
    private final AtomicBoolean running;
    @NotNull
    private final AtomicInteger localPort;
    @Nullable
    private Thread thread;

    public HttpServer() {
        boolean bl = false;
        this.handlers = new LinkedHashMap();
        this.running = new AtomicBoolean(false);
        this.localPort = new AtomicInteger(0);
    }

    /*
     * WARNING - void declaration
     */
    public final void start() {
        void $this$start_u24lambda_u2d3;
        CountDownLatch bootingLatch = new CountDownLatch(1);
        Thread thread = new Thread(() -> HttpServer.start$lambda-2(this, bootingLatch));
        boolean bl = false;
        boolean bl2 = false;
        Thread thread2 = thread;
        HttpServer httpServer = this;
        boolean bl3 = false;
        $this$start_u24lambda_u2d3.setDaemon(true);
        $this$start_u24lambda_u2d3.start();
        Unit unit = Unit.INSTANCE;
        httpServer.thread = thread;
        bootingLatch.await();
    }

    private final void handleRequest(Socket clientSocket) {
        InputStream inputStream = clientSocket.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"clientSocket.getInputStream()");
        Request request = RequestImpl.Companion.parse(inputStream);
        ResponseImpl response = new ResponseImpl(request.getVersion());
        RequestHandler handler = this.handlers.get(request.getPath());
        if (handler != null) {
            handler.handle(request, response);
        } else {
            response.setResponseCode(404, "Not Found");
        }
        OutputStream outputStream = clientSocket.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"clientSocket.getOutputStream()");
        response.sendResponse(outputStream);
    }

    public final void stop() {
        this.running.set(false);
        Thread thread = this.thread;
        Intrinsics.checkNotNull((Object)thread);
        thread.interrupt();
    }

    public final void addHandler(@NotNull String path, @NotNull RequestHandler handler) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Map<String, RequestHandler> map = this.handlers;
        boolean bl = false;
        map.put(path, handler);
    }

    @NotNull
    public final Set<String> getPaths() {
        return this.handlers.keySet();
    }

    public final boolean isRunning() {
        return this.running.get();
    }

    @Nullable
    public final String getHost() {
        return this.isRunning() ? "http://localhost:" + this.localPort.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void start$lambda-2(HttpServer this$0, CountDownLatch $bootingLatch) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$bootingLatch, (String)"$bootingLatch");
        Closeable closeable = new ServerSocket(0, 10);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ServerSocket serverSocket = (ServerSocket)closeable;
            boolean bl3 = false;
            this$0.localPort.set(serverSocket.getLocalPort());
            this$0.running.set(true);
            $bootingLatch.countDown();
            while (this$0.running.get()) {
                Closeable closeable2 = serverSocket.accept();
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    Socket it = (Socket)closeable2;
                    boolean bl6 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    this$0.handleRequest(it);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

