/*
 * Decompiled with CFR 0.152.
 */
package net.uiqui.oauth.mock;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.uiqui.oauth.mock.boundary.HttpServer;
import net.uiqui.oauth.mock.boundary.KeysServlet;
import net.uiqui.oauth.mock.control.JWTGenerator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000f\u001a\u00020\u00032\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lnet/uiqui/oauth/mock/OAuthServerMock;", "", "hostname", "", "port", "", "(Ljava/lang/String;I)V", "getHostname", "()Ljava/lang/String;", "httpServer", "Lnet/uiqui/oauth/mock/boundary/HttpServer;", "jwtGenerator", "Lnet/uiqui/oauth/mock/control/JWTGenerator;", "getPort", "()I", "generateJWT", "claims", "", "getJwksUri", "Ljava/net/URI;", "shutdown", "", "start", "mock-oauth-server"})
public final class OAuthServerMock {
    @NotNull
    private final String hostname;
    private final int port;
    @NotNull
    private final JWTGenerator jwtGenerator;
    @NotNull
    private final HttpServer httpServer;

    public OAuthServerMock(@NotNull String hostname, int port) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        this.hostname = hostname;
        this.port = port;
        this.jwtGenerator = new JWTGenerator();
        this.httpServer = new HttpServer(new InetSocketAddress(this.hostname, this.port));
    }

    public /* synthetic */ OAuthServerMock(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "localhost";
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(string, n);
    }

    @NotNull
    public final String getHostname() {
        return this.hostname;
    }

    public final int getPort() {
        return this.port;
    }

    @NotNull
    public final String generateJWT(@NotNull Map<String, ? extends Object> claims) {
        Intrinsics.checkNotNullParameter(claims, (String)"claims");
        return this.jwtGenerator.generate(this.getJwksUri(), claims);
    }

    @NotNull
    public final URI getJwksUri() {
        if (!this.httpServer.isRunning()) {
            throw new IllegalStateException("JWKS Uri is only available after starting");
        }
        return new URI(this.httpServer.getHost() + "/.well-known/jwks.json");
    }

    public final void start() {
        if (!this.httpServer.getPaths().contains("/.well-known/jwks.json")) {
            this.httpServer.addServlet("/.well-known/jwks.json", new KeysServlet(this.jwtGenerator.getJWKS()));
        }
        this.httpServer.start();
    }

    public final void shutdown() {
        if (this.httpServer.isRunning()) {
            this.httpServer.stop();
        }
    }

    public OAuthServerMock() {
        this(null, 0, 3, null);
    }
}

