/*
 * Decompiled with CFR 0.152.
 */
package net.twasi.obsremotejava;

import java.net.ConnectException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.twasi.obsremotejava.OBSCommunicator;
import net.twasi.obsremotejava.callbacks.Callback;
import net.twasi.obsremotejava.callbacks.CloseCallback;
import net.twasi.obsremotejava.callbacks.ErrorCallback;
import net.twasi.obsremotejava.callbacks.StringCallback;
import net.twasi.obsremotejava.callbacks.VoidCallback;
import net.twasi.obsremotejava.events.responses.ScenesChangedResponse;
import net.twasi.obsremotejava.events.responses.SourceFilterVisibilityChangedResponse;
import net.twasi.obsremotejava.events.responses.SwitchScenesResponse;
import net.twasi.obsremotejava.events.responses.SwitchTransitionResponse;
import net.twasi.obsremotejava.events.responses.TransitionBeginResponse;
import net.twasi.obsremotejava.events.responses.TransitionEndResponse;
import net.twasi.obsremotejava.events.responses.TransitionListChangedResponse;
import net.twasi.obsremotejava.objects.throwables.OBSResponseError;
import net.twasi.obsremotejava.requests.GetCurrentProfile.GetCurrentProfileResponse;
import net.twasi.obsremotejava.requests.GetCurrentScene.GetCurrentSceneResponse;
import net.twasi.obsremotejava.requests.GetPreviewScene.GetPreviewSceneResponse;
import net.twasi.obsremotejava.requests.GetSceneList.GetSceneListResponse;
import net.twasi.obsremotejava.requests.GetSourceFilterInfo.GetSourceFilterInfoResponse;
import net.twasi.obsremotejava.requests.GetSourceFilters.GetSourceFiltersResponse;
import net.twasi.obsremotejava.requests.GetSourceSettings.GetSourceSettingsResponse;
import net.twasi.obsremotejava.requests.GetStreamingStatus.GetStreamingStatusResponse;
import net.twasi.obsremotejava.requests.GetStudioModeEnabled.GetStudioModeEnabledResponse;
import net.twasi.obsremotejava.requests.GetTransitionDuration.GetTransitionDurationResponse;
import net.twasi.obsremotejava.requests.GetTransitionList.GetTransitionListResponse;
import net.twasi.obsremotejava.requests.GetVersion.GetVersionResponse;
import net.twasi.obsremotejava.requests.GetVolume.GetVolumeResponse;
import net.twasi.obsremotejava.requests.ListProfiles.ListProfilesResponse;
import net.twasi.obsremotejava.requests.SaveReplayBuffer.SaveReplayBufferResponse;
import net.twasi.obsremotejava.requests.SetCurrentProfile.SetCurrentProfileResponse;
import net.twasi.obsremotejava.requests.SetCurrentScene.SetCurrentSceneResponse;
import net.twasi.obsremotejava.requests.SetCurrentTransition.SetCurrentTransitionResponse;
import net.twasi.obsremotejava.requests.SetMute.SetMuteResponse;
import net.twasi.obsremotejava.requests.SetPreviewScene.SetPreviewSceneResponse;
import net.twasi.obsremotejava.requests.SetSceneItemProperties.SetSceneItemPropertiesResponse;
import net.twasi.obsremotejava.requests.SetSourceFilterVisibility.SetSourceFilterVisibilityResponse;
import net.twasi.obsremotejava.requests.SetSourceSettings.SetSourceSettingsResponse;
import net.twasi.obsremotejava.requests.SetStudioModeEnabled.SetStudioModeEnabledResponse;
import net.twasi.obsremotejava.requests.SetTransitionDuration.SetTransitionDurationResponse;
import net.twasi.obsremotejava.requests.SetVolume.SetVolumeResponse;
import net.twasi.obsremotejava.requests.StartRecording.StartRecordingResponse;
import net.twasi.obsremotejava.requests.StartReplayBuffer.StartReplayBufferResponse;
import net.twasi.obsremotejava.requests.StartStreaming.StartStreamingResponse;
import net.twasi.obsremotejava.requests.StopRecording.StopRecordingResponse;
import net.twasi.obsremotejava.requests.StopReplayBuffer.StopReplayBufferResponse;
import net.twasi.obsremotejava.requests.StopStreaming.StopStreamingResponse;
import net.twasi.obsremotejava.requests.TransitionToProgram.TransitionToProgramResponse;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OBSRemoteController {
    Logger log = LoggerFactory.getLogger(this.getClass());
    private String address;
    private final boolean debug;
    private final OBSCommunicator communicator;
    private final String password;
    private final WebSocketClient client;
    private StringCallback onConnectionFailed;
    private ErrorCallback onError;
    private boolean failed;

    public OBSRemoteController(String address, boolean debug, String password, boolean autoConnect) {
        this.address = address;
        this.debug = debug;
        this.password = password;
        this.client = new WebSocketClient();
        this.communicator = new OBSCommunicator(debug, password);
        if (autoConnect) {
            this.connect();
        }
    }

    public OBSRemoteController(String address, boolean debug, String password) {
        this(address, debug, password, true);
    }

    public OBSRemoteController(String address, boolean debug) {
        this(address, debug, null);
    }

    public void connect() {
        block7: {
            try {
                this.client.start();
            }
            catch (Exception e) {
                this.runOnError("Failed to start WebSocketClient", e);
                return;
            }
            try {
                URI uri = new URI(this.address);
                ClientUpgradeRequest request = new ClientUpgradeRequest();
                Future connection = this.client.connect((Object)this.communicator, uri, request);
                this.log.info(String.format("Connecting to: %s%s.%n", uri, this.password != null ? " with password" : " (no password)"));
                try {
                    connection.get();
                    this.failed = false;
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof ConnectException) {
                        this.failed = true;
                        this.runOnConnectionFailed("Failed to connect to OBS! Is it running and is the websocket plugin installed?", e);
                        break block7;
                    }
                    throw e;
                }
            }
            catch (Throwable t) {
                this.runOnConnectionFailed("Failed to setup connection with OBS", t);
            }
        }
    }

    public void disconnect() {
        try {
            if (this.debug) {
                this.log.debug("Closing connection.");
            }
            this.communicator.awaitClose(1, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.runOnError("Error during closing websocket connection", e);
        }
        if (!this.client.isStopped() && !this.client.isStopping()) {
            try {
                if (this.debug) {
                    this.log.debug("Stopping client.");
                }
                this.client.stop();
            }
            catch (Exception e) {
                this.runOnError("Error during stopping websocket client", e);
            }
        }
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void getScenes(Callback<GetSceneListResponse> callback) {
        this.communicator.getScenes(callback);
    }

    public void registerOnError(ErrorCallback onError) {
        this.onError = onError;
        this.communicator.registerOnError(onError);
    }

    public void registerConnectCallback(Callback<GetVersionResponse> onConnect) {
        this.communicator.registerOnConnect(onConnect);
    }

    public void registerDisconnectCallback(VoidCallback onDisconnect) {
        this.communicator.registerOnDisconnect(onDisconnect);
    }

    public void registerConnectionFailedCallback(StringCallback onConnectionFailed) {
        this.onConnectionFailed = onConnectionFailed;
        this.communicator.registerOnConnectionFailed(onConnectionFailed);
    }

    public void registerCloseCallback(CloseCallback closeCallback) {
        this.communicator.registerOnClose(closeCallback);
    }

    public void registerRecordingStartedCallback(VoidCallback onRecordingStarted) {
        this.communicator.registerOnRecordingStarted(onRecordingStarted);
    }

    public void registerRecordingStoppedCallback(VoidCallback onRecordingStopped) {
        this.communicator.registerOnRecordingStopped(onRecordingStopped);
    }

    public void registerReplayStartedCallback(VoidCallback onReplayStarted) {
        this.communicator.registerOnReplayStarted(onReplayStarted);
    }

    public void registerReplayStartingCallback(VoidCallback onReplayStarting) {
        this.communicator.registerOnReplayStarting(onReplayStarting);
    }

    public void registerReplayStoppedCallback(VoidCallback onReplayStopped) {
        this.communicator.registerOnReplayStopped(onReplayStopped);
    }

    public void registerReplayStoppingCallback(VoidCallback onReplayStopping) {
        this.communicator.registerOnReplayStopping(onReplayStopping);
    }

    public void registerStreamStartedCallback(VoidCallback onRecordingStarted) {
        this.communicator.registerOnStreamStarted(onRecordingStarted);
    }

    public void registerStreamStoppedCallback(VoidCallback onRecordingStopped) {
        this.communicator.registerOnStreamStopped(onRecordingStopped);
    }

    public void registerSwitchScenesCallback(Callback<SwitchScenesResponse> onSwitchScenes) {
        this.communicator.registerOnSwitchScenes(onSwitchScenes);
    }

    public void registerScenesChangedCallback(Callback<ScenesChangedResponse> onScenesChanged) {
        this.communicator.registerOnScenesChanged(onScenesChanged);
    }

    public void registerSwitchTransitionCallback(Callback<SwitchTransitionResponse> onSwitchTransition) {
        this.communicator.registerOnSwitchTransition(onSwitchTransition);
    }

    public void registerTransitionListChangedCallback(Callback<TransitionListChangedResponse> onTransitionListChanged) {
        this.communicator.registerOnTransitionListChanged(onTransitionListChanged);
    }

    public void registerTransitionBeginCallback(Callback<TransitionBeginResponse> onTransitionBegin) {
        this.communicator.registerOnTransitionBegin(onTransitionBegin);
    }

    public void registerTransitionEndCallback(Callback<TransitionEndResponse> onTransitionEnd) {
        this.communicator.registerOnTransitionEnd(onTransitionEnd);
    }

    public void registerSourceFilterVisibilityChangedCallback(Callback<SourceFilterVisibilityChangedResponse> onSourceVisibilityChanged) {
        this.communicator.registerOnSourceFilterVisibilityChanged(onSourceVisibilityChanged);
    }

    public void await() throws InterruptedException {
        this.communicator.await();
    }

    public void setCurrentScene(String scene, Callback<SetCurrentSceneResponse> callback) {
        this.communicator.setCurrentScene(scene, callback);
    }

    public void setCurrentTransition(String transition, Callback<SetCurrentTransitionResponse> callback) {
        this.communicator.setCurrentTransition(transition, callback);
    }

    public void changeSceneWithTransition(String scene, String transition, Callback<SetCurrentSceneResponse> callback) {
        this.communicator.setCurrentTransition(transition, response -> {
            if (!response.getStatus().equals("ok")) {
                this.log.error("Failed to change transition. Pls fix.");
                this.runOnError("Error response for changeSceneWithTransition", new OBSResponseError(response.getError()));
            }
            this.communicator.setCurrentScene(scene, callback);
        });
    }

    public void setSourceVisibility(String scene, String source, boolean visibility, Callback<SetSceneItemPropertiesResponse> callback) {
        this.communicator.setSourceVisiblity(scene, source, visibility, callback);
    }

    public void getSceneItemProperties(String scene, String source, Callback<SetSceneItemPropertiesResponse> callback) {
        this.communicator.getSceneItemProperties(scene, source, callback);
    }

    public void getSourceProperties(String scene, String source, Callback<SetSceneItemPropertiesResponse> callback) {
        this.getSceneItemProperties(scene, source, callback);
    }

    public void getSourceFilters(String sourceName, Callback<GetSourceFiltersResponse> callback) {
        this.communicator.getSourceFilters(sourceName, callback);
    }

    public void getSourceFilterInfo(String sourceName, String filterName, Callback<GetSourceFilterInfoResponse> callback) {
        this.communicator.getSourceFilterInfo(sourceName, filterName, callback);
    }

    public void setSourceFilterVisibility(String sourceName, String filterName, boolean filterEnabled, Callback<SetSourceFilterVisibilityResponse> callback) {
        this.communicator.setSourceFilterVisibility(sourceName, filterName, filterEnabled, callback);
    }

    public void getTransitionList(Callback<GetTransitionListResponse> callback) {
        this.communicator.getTransitionList(callback);
    }

    public void transitionToProgram(String transitionName, int duration, Callback<TransitionToProgramResponse> callback) {
        this.communicator.transitionToProgram(transitionName, duration, callback);
    }

    public void getSourceSettings(String sourceName, Callback<GetSourceSettingsResponse> callback) {
        this.communicator.getSourceSettings(sourceName, callback);
    }

    public void setSourceSettings(String sourceName, Map<String, Object> settings, Callback<SetSourceSettingsResponse> callback) {
        this.communicator.setSourceSettings(sourceName, settings, callback);
    }

    public void getStreamingStatus(Callback<GetStreamingStatusResponse> callback) {
        this.communicator.getStreamingStatus(callback);
    }

    public void startStreaming(Callback<StartStreamingResponse> callback) {
        this.communicator.startStreaming(callback);
    }

    public void stopStreaming(Callback<StopStreamingResponse> callback) {
        this.communicator.stopStreaming(callback);
    }

    public void startRecording(Callback<StartRecordingResponse> callback) {
        this.communicator.startRecording(callback);
    }

    public void stopRecording(Callback<StopRecordingResponse> callback) {
        this.communicator.stopRecording(callback);
    }

    public void listProfiles(Callback<ListProfilesResponse> callback) {
        this.communicator.listProfiles(callback);
    }

    public void getCurrentProfile(Callback<GetCurrentProfileResponse> callback) {
        this.communicator.getCurrentProfile(callback);
    }

    public void setCurrentProfile(String profile, Callback<SetCurrentProfileResponse> callback) {
        this.communicator.setCurrentProfile(profile, callback);
    }

    public void getCurrentScene(Callback<GetCurrentSceneResponse> callback) {
        this.communicator.getCurrentScene(callback);
    }

    public void getVolume(String source, Callback<GetVolumeResponse> callback) {
        this.communicator.getVolume(source, callback);
    }

    public void setVolume(String source, double volume, Callback<SetVolumeResponse> callback) {
        this.communicator.setVolume(source, volume, callback);
    }

    public void setMute(String source, boolean mute, Callback<SetMuteResponse> callback) {
        this.communicator.setMute(source, mute, callback);
    }

    public void getPreviewScene(Callback<GetPreviewSceneResponse> callback) {
        this.communicator.getPreviewScene(callback);
    }

    public void setPreviewScene(String name, Callback<SetPreviewSceneResponse> callback) {
        this.communicator.setPreviewScene(name, callback);
    }

    public void getTransitionDuration(Callback<GetTransitionDurationResponse> callback) {
        this.communicator.getTransitionDuration(callback);
    }

    public void setTransitionDuration(int duration, Callback<SetTransitionDurationResponse> callback) {
        this.communicator.setTransitionDuration(duration, callback);
    }

    public void getStudioModeEnabled(Callback<GetStudioModeEnabledResponse> callback) {
        this.communicator.getStudioModeEnabled(callback);
    }

    public void setStudioModeEnabled(boolean enabled, Callback<SetStudioModeEnabledResponse> callback) {
        this.communicator.setStudioModeEnabled(enabled, callback);
    }

    public void startReplayBuffer(Callback<StartReplayBufferResponse> callback) {
        this.communicator.startReplayBuffer(callback);
    }

    public void stopReplayBuffer(Callback<StopReplayBufferResponse> callback) {
        this.communicator.stopReplayBuffer(callback);
    }

    public void saveReplayBuffer(Callback<SaveReplayBufferResponse> callback) {
        this.communicator.saveReplayBuffer(callback);
    }

    private void runOnError(String message, Throwable throwable) {
        this.log.debug("Running onError with message: " + message + " and exception:", throwable);
        if (this.onError == null) {
            this.log.debug("No onError callback was registered");
            return;
        }
        try {
            this.onError.run(message, throwable);
        }
        catch (Exception e) {
            this.log.error("Unable to run OnError callback", (Throwable)e);
        }
    }

    private void runOnConnectionFailed(String message, Throwable throwable) {
        this.log.debug("Running onConnectionFailed with message: " + message + " with exception:", throwable);
        if (this.onConnectionFailed == null) {
            this.log.debug("No onConnectionFailed callback was registered");
            return;
        }
        try {
            this.onConnectionFailed.run(message);
        }
        catch (Exception e) {
            this.log.error("Unable to run OnConnectionFailed callback", (Throwable)e);
        }
    }
}

