/*
 * Decompiled with CFR 0.152.
 */
package net.twasi.obsremotejava;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.twasi.obsremotejava.callbacks.Callback;
import net.twasi.obsremotejava.callbacks.CloseCallback;
import net.twasi.obsremotejava.callbacks.ErrorCallback;
import net.twasi.obsremotejava.callbacks.StringCallback;
import net.twasi.obsremotejava.callbacks.VoidCallback;
import net.twasi.obsremotejava.events.EventType;
import net.twasi.obsremotejava.events.responses.ScenesChangedResponse;
import net.twasi.obsremotejava.events.responses.SourceFilterVisibilityChangedResponse;
import net.twasi.obsremotejava.events.responses.SwitchScenesResponse;
import net.twasi.obsremotejava.events.responses.SwitchTransitionResponse;
import net.twasi.obsremotejava.events.responses.TransitionBeginResponse;
import net.twasi.obsremotejava.events.responses.TransitionEndResponse;
import net.twasi.obsremotejava.events.responses.TransitionListChangedResponse;
import net.twasi.obsremotejava.objects.throwables.InvalidResponseTypeError;
import net.twasi.obsremotejava.requests.Authenticate.AuthenticateRequest;
import net.twasi.obsremotejava.requests.Authenticate.AuthenticateResponse;
import net.twasi.obsremotejava.requests.GetAuthRequired.GetAuthRequiredRequest;
import net.twasi.obsremotejava.requests.GetAuthRequired.GetAuthRequiredResponse;
import net.twasi.obsremotejava.requests.GetCurrentProfile.GetCurrentProfileRequest;
import net.twasi.obsremotejava.requests.GetCurrentProfile.GetCurrentProfileResponse;
import net.twasi.obsremotejava.requests.GetCurrentScene.GetCurrentSceneRequest;
import net.twasi.obsremotejava.requests.GetCurrentScene.GetCurrentSceneResponse;
import net.twasi.obsremotejava.requests.GetPreviewScene.GetPreviewSceneRequest;
import net.twasi.obsremotejava.requests.GetPreviewScene.GetPreviewSceneResponse;
import net.twasi.obsremotejava.requests.GetSceneItemProperties.GetSceneItemPropertiesRequest;
import net.twasi.obsremotejava.requests.GetSceneList.GetSceneListRequest;
import net.twasi.obsremotejava.requests.GetSceneList.GetSceneListResponse;
import net.twasi.obsremotejava.requests.GetSourceFilterInfo.GetSourceFilterInfoRequest;
import net.twasi.obsremotejava.requests.GetSourceFilterInfo.GetSourceFilterInfoResponse;
import net.twasi.obsremotejava.requests.GetSourceFilters.GetSourceFiltersRequest;
import net.twasi.obsremotejava.requests.GetSourceFilters.GetSourceFiltersResponse;
import net.twasi.obsremotejava.requests.GetSourceSettings.GetSourceSettingsRequest;
import net.twasi.obsremotejava.requests.GetSourceSettings.GetSourceSettingsResponse;
import net.twasi.obsremotejava.requests.GetStreamingStatus.GetStreamingStatusRequest;
import net.twasi.obsremotejava.requests.GetStreamingStatus.GetStreamingStatusResponse;
import net.twasi.obsremotejava.requests.GetStudioModeEnabled.GetStudioModeEnabledRequest;
import net.twasi.obsremotejava.requests.GetStudioModeEnabled.GetStudioModeEnabledResponse;
import net.twasi.obsremotejava.requests.GetTransitionDuration.GetTransitionDurationRequest;
import net.twasi.obsremotejava.requests.GetTransitionDuration.GetTransitionDurationResponse;
import net.twasi.obsremotejava.requests.GetTransitionList.GetTransitionListRequest;
import net.twasi.obsremotejava.requests.GetTransitionList.GetTransitionListResponse;
import net.twasi.obsremotejava.requests.GetVersion.GetVersionRequest;
import net.twasi.obsremotejava.requests.GetVersion.GetVersionResponse;
import net.twasi.obsremotejava.requests.GetVolume.GetVolumeRequest;
import net.twasi.obsremotejava.requests.GetVolume.GetVolumeResponse;
import net.twasi.obsremotejava.requests.ListProfiles.ListProfilesRequest;
import net.twasi.obsremotejava.requests.ListProfiles.ListProfilesResponse;
import net.twasi.obsremotejava.requests.ResponseBase;
import net.twasi.obsremotejava.requests.SaveReplayBuffer.SaveReplayBufferRequest;
import net.twasi.obsremotejava.requests.SaveReplayBuffer.SaveReplayBufferResponse;
import net.twasi.obsremotejava.requests.SetCurrentProfile.SetCurrentProfileRequest;
import net.twasi.obsremotejava.requests.SetCurrentProfile.SetCurrentProfileResponse;
import net.twasi.obsremotejava.requests.SetCurrentScene.SetCurrentSceneRequest;
import net.twasi.obsremotejava.requests.SetCurrentScene.SetCurrentSceneResponse;
import net.twasi.obsremotejava.requests.SetCurrentTransition.SetCurrentTransitionRequest;
import net.twasi.obsremotejava.requests.SetCurrentTransition.SetCurrentTransitionResponse;
import net.twasi.obsremotejava.requests.SetMute.SetMuteRequest;
import net.twasi.obsremotejava.requests.SetMute.SetMuteResponse;
import net.twasi.obsremotejava.requests.SetPreviewScene.SetPreviewSceneRequest;
import net.twasi.obsremotejava.requests.SetPreviewScene.SetPreviewSceneResponse;
import net.twasi.obsremotejava.requests.SetSceneItemProperties.SetSceneItemPropertiesRequest;
import net.twasi.obsremotejava.requests.SetSceneItemProperties.SetSceneItemPropertiesResponse;
import net.twasi.obsremotejava.requests.SetSourceFilterVisibility.SetSourceFilterVisibilityRequest;
import net.twasi.obsremotejava.requests.SetSourceFilterVisibility.SetSourceFilterVisibilityResponse;
import net.twasi.obsremotejava.requests.SetSourceSettings.SetSourceSettingsRequest;
import net.twasi.obsremotejava.requests.SetSourceSettings.SetSourceSettingsResponse;
import net.twasi.obsremotejava.requests.SetStudioModeEnabled.SetStudioModeEnabledRequest;
import net.twasi.obsremotejava.requests.SetStudioModeEnabled.SetStudioModeEnabledResponse;
import net.twasi.obsremotejava.requests.SetTransitionDuration.SetTransitionDurationRequest;
import net.twasi.obsremotejava.requests.SetTransitionDuration.SetTransitionDurationResponse;
import net.twasi.obsremotejava.requests.SetVolume.SetVolumeRequest;
import net.twasi.obsremotejava.requests.SetVolume.SetVolumeResponse;
import net.twasi.obsremotejava.requests.StartRecording.StartRecordingRequest;
import net.twasi.obsremotejava.requests.StartRecording.StartRecordingResponse;
import net.twasi.obsremotejava.requests.StartReplayBuffer.StartReplayBufferRequest;
import net.twasi.obsremotejava.requests.StartReplayBuffer.StartReplayBufferResponse;
import net.twasi.obsremotejava.requests.StartStreaming.StartStreamingRequest;
import net.twasi.obsremotejava.requests.StartStreaming.StartStreamingResponse;
import net.twasi.obsremotejava.requests.StopRecording.StopRecordingRequest;
import net.twasi.obsremotejava.requests.StopRecording.StopRecordingResponse;
import net.twasi.obsremotejava.requests.StopReplayBuffer.StopReplayBufferRequest;
import net.twasi.obsremotejava.requests.StopReplayBuffer.StopReplayBufferResponse;
import net.twasi.obsremotejava.requests.StopStreaming.StopStreamingRequest;
import net.twasi.obsremotejava.requests.StopStreaming.StopStreamingResponse;
import net.twasi.obsremotejava.requests.TransitionToProgram.TransitionToProgramRequest;
import net.twasi.obsremotejava.requests.TransitionToProgram.TransitionToProgramResponse;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket(maxIdleTime=360000000)
public class OBSCommunicator {
    Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean debug;
    private final String password;
    private final CountDownLatch closeLatch;
    public final Map<String, Class> messageTypes = new HashMap<String, Class>();
    private final Map<Class, Callback> callbacks = new HashMap<Class, Callback>();
    private Session session;
    private Callback<GetVersionResponse> onConnect;
    private VoidCallback onDisconnect;
    private CloseCallback onClose;
    private StringCallback onConnectionFailed;
    private ErrorCallback onError;
    private VoidCallback onRecordingStarted;
    private VoidCallback onRecordingStopped;
    private VoidCallback onReplayStarted;
    private VoidCallback onReplayStarting;
    private VoidCallback onReplayStopped;
    private VoidCallback onReplayStopping;
    private VoidCallback onStreamStarted;
    private VoidCallback onStreamStopped;
    private Callback<SwitchScenesResponse> onSwitchScenes;
    private Callback<ScenesChangedResponse> onScenesChanged;
    private Callback<SwitchTransitionResponse> onSwitchTransition;
    private Callback<TransitionListChangedResponse> onTransitionListChanged;
    private Callback<TransitionBeginResponse> onTransitionBegin;
    private Callback<TransitionEndResponse> onTransitionEnd;
    private Callback<SourceFilterVisibilityChangedResponse> onSourceFilterVisibilityChanged;
    private GetVersionResponse versionInfo;

    public OBSCommunicator(boolean debug, String password) {
        this.closeLatch = new CountDownLatch(1);
        this.debug = debug;
        this.password = password;
    }

    public OBSCommunicator(boolean debug) {
        this(debug, null);
    }

    public boolean awaitClose(int duration, TimeUnit unit) throws InterruptedException {
        return this.closeLatch.await(duration, unit);
    }

    public void await() throws InterruptedException {
        this.closeLatch.await();
    }

    @OnWebSocketError
    public void onError(Session session, Throwable throwable) {
        this.runOnConnectionFailed("Websocket error occurred with session " + session, throwable);
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        this.log.info(String.format("Connection closed: %d - %s%n", statusCode, reason));
        this.runOnDisconnect();
        this.closeLatch.countDown();
        this.runOnClosed(statusCode, reason);
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        this.session = session;
        try {
            Future fut = session.getRemote().sendStringByFuture(new Gson().toJson((Object)new GetVersionRequest(this)));
            fut.get(2L, TimeUnit.SECONDS);
        }
        catch (Throwable t) {
            this.runOnError("An error occurred while trying to get a session", t);
        }
    }

    @OnWebSocketMessage
    public void onMessage(String msg) {
        block11: {
            if (msg == null) {
                this.log.debug("Ignored empty message");
                return;
            }
            if (this.debug) {
                this.log.debug("onMessage: " + msg);
            }
            try {
                EventType eventType;
                if (((JsonObject)new Gson().fromJson(msg, JsonObject.class)).has("message-id")) {
                    ResponseBase responseBase = (ResponseBase)new Gson().fromJson(msg, ResponseBase.class);
                    Class type = this.messageTypes.get(responseBase.getMessageId());
                    this.log.trace(String.format("Trying to deserialize response with type %s and message '%s'", type, msg));
                    responseBase = (ResponseBase)new Gson().fromJson(msg, type);
                    try {
                        this.processIncomingResponse(responseBase, type);
                    }
                    catch (Throwable t) {
                        this.runOnError("Failed to process response '" + type.getSimpleName() + "' from websocket", t);
                    }
                    break block11;
                }
                JsonElement elem = new JsonParser().parse(msg);
                try {
                    eventType = EventType.valueOf(elem.getAsJsonObject().get("update-type").getAsString());
                }
                catch (Throwable t) {
                    return;
                }
                try {
                    this.processIncomingEvent(msg, eventType);
                }
                catch (Throwable t) {
                    this.runOnError("Failed to execute callback for event: " + (Object)((Object)eventType), t);
                }
            }
            catch (Throwable t) {
                this.runOnError("Failed to process message from websocket", t);
            }
        }
    }

    private void processIncomingResponse(ResponseBase responseBase, Class type) {
        switch (type.getSimpleName()) {
            case "GetVersionResponse": {
                this.versionInfo = (GetVersionResponse)responseBase;
                this.log.info(String.format("Connected to OBS. Websocket Version: %s, Studio Version: %s\n", this.versionInfo.getObsWebsocketVersion(), this.versionInfo.getObsStudioVersion()));
                this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)new GetAuthRequiredRequest(this)));
                break;
            }
            case "GetAuthRequiredResponse": {
                GetAuthRequiredResponse authRequiredResponse = (GetAuthRequiredResponse)responseBase;
                if (authRequiredResponse.isAuthRequired()) {
                    this.log.info("Authentication is required.");
                    this.authenticateWithServer(authRequiredResponse.getChallenge(), authRequiredResponse.getSalt());
                    break;
                }
                this.log.info("Authentication is not required. You're ready to go!");
                this.runOnConnect(this.versionInfo);
                break;
            }
            case "AuthenticateResponse": {
                AuthenticateResponse authenticateResponse = (AuthenticateResponse)responseBase;
                if ("ok".equals(authenticateResponse.getStatus())) {
                    this.runOnConnect(this.versionInfo);
                    break;
                }
                this.runOnConnectionFailed("Failed to authenticate with password. Error: " + authenticateResponse.getError(), null);
                break;
            }
            default: {
                if (!this.callbacks.containsKey(type)) {
                    this.log.warn("Invalid type received: " + type.getName());
                    this.runOnError("Invalid response type received", new InvalidResponseTypeError(type.getName()));
                    return;
                }
                try {
                    this.callbacks.get(type).run(responseBase);
                    break;
                }
                catch (Throwable t) {
                    this.runOnError("Failed to execute callback for response: " + type, t);
                }
            }
        }
    }

    private void processIncomingEvent(String msg, EventType eventType) {
        switch (eventType) {
            case ReplayStarted: {
                if (this.onReplayStarted == null) break;
                this.onReplayStarted.run();
                break;
            }
            case ReplayStarting: {
                if (this.onReplayStarting == null) break;
                this.onReplayStarting.run();
                break;
            }
            case ReplayStopped: {
                if (this.onReplayStopped == null) break;
                this.onReplayStopped.run();
                break;
            }
            case ReplayStopping: {
                if (this.onReplayStopping == null) break;
                this.onReplayStopping.run();
                break;
            }
            case SwitchScenes: {
                if (this.onSwitchScenes == null) break;
                this.onSwitchScenes.run((SwitchScenesResponse)((ResponseBase)new Gson().fromJson(msg, SwitchScenesResponse.class)));
                break;
            }
            case ScenesChanged: {
                if (this.onScenesChanged == null) break;
                this.onScenesChanged.run((ScenesChangedResponse)((ResponseBase)new Gson().fromJson(msg, ScenesChangedResponse.class)));
                break;
            }
            case SourceFilterVisibilityChanged: {
                if (this.onSourceFilterVisibilityChanged == null) break;
                this.onSourceFilterVisibilityChanged.run((SourceFilterVisibilityChangedResponse)((ResponseBase)new Gson().fromJson(msg, SourceFilterVisibilityChangedResponse.class)));
                break;
            }
            case SwitchTransition: {
                if (this.onSwitchTransition == null) break;
                this.onSwitchTransition.run((SwitchTransitionResponse)((ResponseBase)new Gson().fromJson(msg, SwitchTransitionResponse.class)));
                break;
            }
            case TransitionListChanged: {
                if (this.onTransitionListChanged == null) break;
                this.onTransitionListChanged.run((TransitionListChangedResponse)((ResponseBase)new Gson().fromJson(msg, TransitionListChangedResponse.class)));
                break;
            }
            case TransitionBegin: {
                if (this.onTransitionBegin == null) break;
                this.onTransitionBegin.run((TransitionBeginResponse)((ResponseBase)new Gson().fromJson(msg, TransitionBeginResponse.class)));
                break;
            }
            case TransitionEnd: {
                if (this.onTransitionEnd == null) break;
                this.onTransitionEnd.run((TransitionEndResponse)((ResponseBase)new Gson().fromJson(msg, TransitionEndResponse.class)));
                break;
            }
            case RecordingStarted: {
                if (this.onRecordingStarted == null) break;
                this.onRecordingStarted.run();
                break;
            }
            case RecordingStopped: {
                if (this.onRecordingStopped == null) break;
                this.onRecordingStopped.run();
                break;
            }
            case StreamStarted: {
                if (this.onStreamStarted == null) break;
                this.onStreamStarted.run();
                break;
            }
            case StreamStopped: {
                if (this.onStreamStopped == null) break;
                this.onStreamStopped.run();
            }
        }
    }

    private void authenticateWithServer(String challenge, String salt) {
        if (this.password == null) {
            this.runOnConnectionFailed("Authentication required by server but no password set by client", null);
            return;
        }
        String authResponse = this.generateAuthenticationResponseString(challenge, salt);
        if (authResponse == null) {
            return;
        }
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)new AuthenticateRequest(this, authResponse)));
    }

    private String generateAuthenticationResponseString(String challenge, String salt) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            this.runOnConnectionFailed("Failed to perform password authentication with server", null);
            return null;
        }
        String secretString = this.password + salt;
        byte[] secretHash = digest.digest(secretString.getBytes(StandardCharsets.UTF_8));
        String encodedSecret = Base64.getEncoder().encodeToString(secretHash);
        String authResponseString = encodedSecret + challenge;
        byte[] authResponseHash = digest.digest(authResponseString.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(authResponseHash);
    }

    public void registerOnError(ErrorCallback onError) {
        this.onError = onError;
    }

    public void registerOnConnect(Callback<GetVersionResponse> onConnect) {
        this.onConnect = onConnect;
    }

    public void registerOnDisconnect(VoidCallback onDisconnect) {
        this.onDisconnect = onDisconnect;
    }

    public void registerOnClose(CloseCallback closeCallback) {
        this.onClose = closeCallback;
    }

    public void registerOnConnectionFailed(StringCallback onConnectionFailed) {
        this.onConnectionFailed = onConnectionFailed;
    }

    public void registerOnReplayStarted(VoidCallback onReplayStarted) {
        this.onReplayStarted = onReplayStarted;
    }

    public void registerOnReplayStarting(VoidCallback onReplayStarting) {
        this.onReplayStarting = onReplayStarting;
    }

    public void registerOnReplayStopped(VoidCallback onReplayStopped) {
        this.onReplayStopped = onReplayStopped;
    }

    public void registerOnReplayStopping(VoidCallback onReplayStopping) {
        this.onReplayStopping = onReplayStopping;
    }

    public void registerOnSwitchScenes(Callback<SwitchScenesResponse> onSwitchScenes) {
        this.onSwitchScenes = onSwitchScenes;
    }

    public void registerOnScenesChanged(Callback<ScenesChangedResponse> onScenesChanged) {
        this.onScenesChanged = onScenesChanged;
    }

    public void registerOnSourceFilterVisibilityChanged(Callback<SourceFilterVisibilityChangedResponse> onSourceFilterVisibilityChanged) {
        this.onSourceFilterVisibilityChanged = onSourceFilterVisibilityChanged;
    }

    public void registerOnSwitchTransition(Callback<SwitchTransitionResponse> onSwitchTransition) {
        this.onSwitchTransition = onSwitchTransition;
    }

    public void registerOnTransitionListChanged(Callback<TransitionListChangedResponse> onTransitionListChanged) {
        this.onTransitionListChanged = onTransitionListChanged;
    }

    public void registerOnTransitionBegin(Callback<TransitionBeginResponse> onTransitionBegin) {
        this.onTransitionBegin = onTransitionBegin;
    }

    public void registerOnTransitionEnd(Callback<TransitionEndResponse> onTransitionEnd) {
        this.onTransitionEnd = onTransitionEnd;
    }

    public void registerOnRecordingStarted(VoidCallback onRecordingStarted) {
        this.onRecordingStarted = onRecordingStarted;
    }

    public void registerOnRecordingStopped(VoidCallback onRecordingStopped) {
        this.onRecordingStopped = onRecordingStopped;
    }

    public void registerOnStreamStarted(VoidCallback onStreamStarted) {
        this.onStreamStarted = onStreamStarted;
    }

    public void registerOnStreamStopped(VoidCallback onStreamStopped) {
        this.onStreamStopped = onStreamStopped;
    }

    public void getScenes(Callback<GetSceneListResponse> callback) {
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)new GetSceneListRequest(this)));
        this.callbacks.put(GetSceneListResponse.class, callback);
    }

    public void setCurrentScene(String scene, Callback<SetCurrentSceneResponse> callback) {
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)new SetCurrentSceneRequest(this, scene)));
        this.callbacks.put(SetCurrentSceneResponse.class, callback);
    }

    public void setCurrentTransition(String transition, Callback<SetCurrentTransitionResponse> callback) {
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)new SetCurrentTransitionRequest(this, transition)));
        this.callbacks.put(SetCurrentTransitionResponse.class, callback);
    }

    public void setSourceVisiblity(String scene, String source, boolean visibility, Callback<SetSceneItemPropertiesResponse> callback) {
        SetSceneItemPropertiesRequest request = new SetSceneItemPropertiesRequest(this, scene, source, visibility);
        this.log.debug(new Gson().toJson((Object)request));
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(SetSceneItemPropertiesResponse.class, callback);
    }

    public void getSceneItemProperties(String scene, String source, Callback<SetSceneItemPropertiesResponse> callback) {
        GetSceneItemPropertiesRequest request = new GetSceneItemPropertiesRequest(this, scene, source);
        this.log.debug(new Gson().toJson((Object)request));
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(SetSceneItemPropertiesResponse.class, callback);
    }

    public void getTransitionList(Callback<GetTransitionListResponse> callback) {
        GetTransitionListRequest request = new GetTransitionListRequest(this);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(GetTransitionListResponse.class, callback);
    }

    public void transitionToProgram(String transitionName, int duration, Callback<TransitionToProgramResponse> callback) {
        TransitionToProgramRequest request = new TransitionToProgramRequest(this, transitionName, duration);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(TransitionToProgramResponse.class, callback);
    }

    public void getSourceSettings(String sourceName, Callback<GetSourceSettingsResponse> callback) {
        GetSourceSettingsRequest request = new GetSourceSettingsRequest(this, sourceName);
        this.log.debug(new Gson().toJson((Object)request));
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(GetSourceSettingsResponse.class, callback);
    }

    public void setSourceSettings(String sourceName, Map<String, Object> settings, Callback<SetSourceSettingsResponse> callback) {
        SetSourceSettingsRequest request = new SetSourceSettingsRequest(this, sourceName, settings);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(SetSourceSettingsResponse.class, callback);
    }

    public void getSourceFilters(String sourceName, Callback<GetSourceFiltersResponse> callback) {
        GetSourceFiltersRequest request = new GetSourceFiltersRequest(sourceName);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(GetSourceFiltersResponse.class, callback);
    }

    public void getSourceFilterInfo(String sourceName, String filterName, Callback<GetSourceFilterInfoResponse> callback) {
        GetSourceFilterInfoRequest request = new GetSourceFilterInfoRequest(sourceName, filterName);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(GetSourceFilterInfoResponse.class, callback);
    }

    public void setSourceFilterVisibility(String sourceName, String filterName, boolean filterEnabled, Callback<SetSourceFilterVisibilityResponse> callback) {
        SetSourceFilterVisibilityRequest request = new SetSourceFilterVisibilityRequest(sourceName, filterName, filterEnabled);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(SetSourceFilterVisibilityResponse.class, callback);
    }

    public void startRecording(Callback<StartRecordingResponse> callback) {
        StartRecordingRequest request = new StartRecordingRequest(this);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(StartRecordingResponse.class, callback);
    }

    public void stopRecording(Callback<StopRecordingResponse> callback) {
        StopRecordingRequest request = new StopRecordingRequest(this);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(StopRecordingResponse.class, callback);
    }

    public void getStreamingStatus(Callback<GetStreamingStatusResponse> callback) {
        GetStreamingStatusRequest request = new GetStreamingStatusRequest(this);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(GetStreamingStatusResponse.class, callback);
    }

    public void startStreaming(Callback<StartStreamingResponse> callback) {
        StartStreamingRequest request = new StartStreamingRequest(this);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(StartStreamingResponse.class, callback);
    }

    public void stopStreaming(Callback<StopStreamingResponse> callback) {
        StopStreamingRequest request = new StopStreamingRequest(this);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(StopStreamingResponse.class, callback);
    }

    public void listProfiles(Callback<ListProfilesResponse> callback) {
        ListProfilesRequest request = new ListProfilesRequest(this);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(ListProfilesResponse.class, callback);
    }

    public void getCurrentProfile(Callback<GetCurrentProfileResponse> callback) {
        GetCurrentProfileRequest request = new GetCurrentProfileRequest(this);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(GetCurrentProfileResponse.class, callback);
    }

    public void setCurrentProfile(String profile, Callback<SetCurrentProfileResponse> callback) {
        SetCurrentProfileRequest request = new SetCurrentProfileRequest(this, profile);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(SetCurrentProfileResponse.class, callback);
    }

    public void getCurrentScene(Callback<GetCurrentSceneResponse> callback) {
        GetCurrentSceneRequest request = new GetCurrentSceneRequest(this);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(GetCurrentSceneResponse.class, callback);
    }

    public void getVolume(String source, Callback<GetVolumeResponse> callback) {
        GetVolumeRequest request = new GetVolumeRequest(this, source);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(GetVolumeResponse.class, callback);
    }

    public void setVolume(String source, double volume, Callback<SetVolumeResponse> callback) {
        SetVolumeRequest request = new SetVolumeRequest(this, source, volume);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(SetVolumeResponse.class, callback);
    }

    public void setMute(String source, boolean mute, Callback<SetMuteResponse> callback) {
        SetMuteRequest request = new SetMuteRequest(this, source, mute);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(SetMuteResponse.class, callback);
    }

    public void getPreviewScene(Callback<GetPreviewSceneResponse> callback) {
        GetPreviewSceneRequest request = new GetPreviewSceneRequest(this);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(GetPreviewSceneResponse.class, callback);
    }

    public void setPreviewScene(String name, Callback<SetPreviewSceneResponse> callback) {
        SetPreviewSceneRequest request = new SetPreviewSceneRequest(this, name);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(SetPreviewSceneResponse.class, callback);
    }

    public void getTransitionDuration(Callback<GetTransitionDurationResponse> callback) {
        GetTransitionDurationRequest request = new GetTransitionDurationRequest(this);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(GetTransitionDurationResponse.class, callback);
    }

    public void setTransitionDuration(int duration, Callback<SetTransitionDurationResponse> callback) {
        SetTransitionDurationRequest request = new SetTransitionDurationRequest(this, duration);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(SetTransitionDurationResponse.class, callback);
    }

    public void startReplayBuffer(Callback<StartReplayBufferResponse> callback) {
        StartReplayBufferRequest request = new StartReplayBufferRequest(this);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(StartReplayBufferResponse.class, callback);
    }

    public void stopReplayBuffer(Callback<StopReplayBufferResponse> callback) {
        StopReplayBufferRequest request = new StopReplayBufferRequest(this);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(StopReplayBufferResponse.class, callback);
    }

    public void saveReplayBuffer(Callback<SaveReplayBufferResponse> callback) {
        SaveReplayBufferRequest request = new SaveReplayBufferRequest(this);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(SaveReplayBufferResponse.class, callback);
    }

    public void getStudioModeEnabled(Callback<GetStudioModeEnabledResponse> callback) {
        GetStudioModeEnabledRequest request = new GetStudioModeEnabledRequest(this);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(GetStudioModeEnabledResponse.class, callback);
    }

    public void setStudioModeEnabled(boolean enabled, Callback<SetStudioModeEnabledResponse> callback) {
        SetStudioModeEnabledRequest request = new SetStudioModeEnabledRequest(this, enabled);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(SetStudioModeEnabledResponse.class, callback);
    }

    private void runOnError(String message, Throwable throwable) {
        this.log.debug("Running onError with message: " + message + " and exception:", throwable);
        if (this.onError == null) {
            this.log.debug("No onError callback was registered");
            return;
        }
        try {
            this.onError.run(message, throwable);
        }
        catch (Throwable t) {
            this.log.error("Unable to run onError callback", t);
        }
    }

    private void runOnConnectionFailed(String message, Throwable throwable) {
        this.log.debug("Running onConnectionFailed, with message: " + message);
        if (this.onConnectionFailed == null) {
            this.log.debug("No onConnectionFailed callback was registered");
            return;
        }
        try {
            this.onConnectionFailed.run(message);
        }
        catch (Throwable t) {
            this.log.error("Unable to run OnConnectionFailed callback", t);
        }
    }

    private void runOnConnect(GetVersionResponse versionInfo) {
        this.log.debug("Running onConnect with versionInfo: " + versionInfo);
        if (this.onConnect == null) {
            this.log.debug("No onConnect callback was registered");
            return;
        }
        try {
            this.onConnect.run(versionInfo);
        }
        catch (Throwable t) {
            this.log.error("Unable to run OnConnect callback", t);
        }
    }

    void runOnDisconnect() {
        this.log.debug("Running onDisconnect");
        if (this.onDisconnect == null) {
            this.log.debug("No onDisconnect callback was registered");
            return;
        }
        try {
            this.onDisconnect.run();
        }
        catch (Throwable t) {
            this.log.error("Unable to run OnDisconnect callback", t);
        }
    }

    private void runOnClosed(int statusCode, String reason) {
        this.log.debug("Running onClose with statusCode " + statusCode + " and reason: " + reason);
        if (this.onClose == null) {
            this.log.debug("No onClose was registered.");
            return;
        }
        try {
            this.onClose.run(statusCode, reason);
        }
        catch (Throwable t) {
            this.log.error("Unable to run onClose callback", t);
        }
    }
}

