/*
 * Decompiled with CFR 0.152.
 */
package net.twasi.obsremotejava;

import java.net.ConnectException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.twasi.obsremotejava.OBSCommunicator;
import net.twasi.obsremotejava.callbacks.Callback;
import net.twasi.obsremotejava.callbacks.ErrorCallback;
import net.twasi.obsremotejava.callbacks.StringCallback;
import net.twasi.obsremotejava.objects.throwables.OBSResponseError;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;

public class OBSRemoteController {
    private String address;
    private final boolean debug;
    private final OBSCommunicator communicator;
    private final String password;
    private final WebSocketClient client;
    private StringCallback onConnectionFailed;
    private ErrorCallback onError;
    private boolean failed;

    public OBSRemoteController(String address, boolean debug, String password, boolean autoConnect) {
        this.address = address;
        this.debug = debug;
        this.password = password;
        this.client = new WebSocketClient();
        this.communicator = new OBSCommunicator(debug, password);
        if (autoConnect) {
            this.connect();
        }
    }

    public OBSRemoteController(String address, boolean debug, String password) {
        this(address, debug, password, true);
    }

    public OBSRemoteController(String address, boolean debug) {
        this(address, debug, null);
    }

    public void connect() {
        block7: {
            try {
                this.client.start();
            }
            catch (Exception e) {
                System.err.println("Failed to start WebSocketClient.");
                e.printStackTrace();
                this.runOnError("Failed to start WebSocketClient", e);
                return;
            }
            try {
                URI uri = new URI(this.address);
                ClientUpgradeRequest request = new ClientUpgradeRequest();
                Future connection = this.client.connect((Object)this.communicator, uri, request);
                System.out.printf("Connecting to: %s%s.%n", uri, this.password != null ? " with password" : "");
                try {
                    connection.get();
                    this.failed = false;
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof ConnectException) {
                        System.out.println("Failed to connect to OBS.");
                        e.printStackTrace();
                        this.failed = true;
                        this.runOnConnectionFailed("Failed to connect to OBS");
                        break block7;
                    }
                    throw e;
                }
            }
            catch (Throwable t) {
                System.err.println("Failed to setup connection with OBS.");
                t.printStackTrace();
                this.runOnConnectionFailed("Failed to setup connection with OBS");
            }
        }
    }

    public void disconnect() {
        try {
            if (this.debug) {
                System.out.println("Closing connection.");
            }
            this.communicator.awaitClose(1, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.runOnError("Error during closing websocket connection", e);
        }
        if (!this.client.isStopped() && !this.client.isStopping()) {
            try {
                if (this.debug) {
                    System.out.println("Stopping client.");
                }
                this.client.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.runOnError("Error during stopping websocket client", e);
            }
        }
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void getScenes(Callback callback) {
        this.communicator.getScenes(callback);
    }

    public void registerOnError(ErrorCallback onError) {
        this.onError = onError;
        this.communicator.registerOnError(onError);
    }

    public void registerConnectCallback(Callback onConnect) {
        this.communicator.registerOnConnect(onConnect);
    }

    public void registerDisconnectCallback(Callback onDisconnect) {
        this.communicator.registerOnDisconnect(onDisconnect);
    }

    public void registerConnectionFailedCallback(StringCallback onConnectionFailed) {
        this.onConnectionFailed = onConnectionFailed;
        this.communicator.registerOnConnectionFailed(onConnectionFailed);
    }

    public void registerReplayStartedCallback(Callback onReplayStarted) {
        this.communicator.registerOnReplayStarted(onReplayStarted);
    }

    public void registerReplayStartingCallback(Callback onReplayStarting) {
        this.communicator.registerOnReplayStarting(onReplayStarting);
    }

    public void registerReplayStoppedCallback(Callback onReplayStopped) {
        this.communicator.registerOnReplayStopped(onReplayStopped);
    }

    public void registerReplayStoppingCallback(Callback onReplayStopping) {
        this.communicator.registerOnReplayStopping(onReplayStopping);
    }

    public void registerSwitchScenesCallback(Callback onSwitchScenes) {
        this.communicator.registerOnSwitchScenes(onSwitchScenes);
    }

    public void registerScenesChangedCallback(Callback onScenesChanged) {
        this.communicator.registerOnScenesChanged(onScenesChanged);
    }

    public void registerTransitionBeginCallback(Callback onTransitionBegin) {
        this.communicator.registerOnTransitionBegin(onTransitionBegin);
    }

    public void registerTransitionEndCallback(Callback onTransitionEnd) {
        this.communicator.registerOnTransitionEnd(onTransitionEnd);
    }

    public void await() throws InterruptedException {
        this.communicator.await();
    }

    public void setCurrentScene(String szene, Callback callback) {
        this.communicator.setCurrentScene(szene, callback);
    }

    public void setCurrentTransition(String transition, Callback callback) {
        this.communicator.setCurrentTransition(transition, callback);
    }

    public void changeSceneWithTransition(String scene, String transition, Callback callback) {
        this.communicator.setCurrentTransition(transition, response -> {
            if (!response.getStatus().equals("ok")) {
                System.out.println("Failed to change transition. Pls fix.");
                this.runOnError("Error response for changeSceneWithTransition", new OBSResponseError(response.getError()));
            }
            this.communicator.setCurrentScene(scene, callback);
        });
    }

    public void setSourceVisibility(String scene, String source, boolean visibility, Callback callback) {
        this.communicator.setSourceVisiblity(scene, source, visibility, callback);
    }

    public void getSceneItemProperties(String scene, String source, Callback callback) {
        this.communicator.getSceneItemProperties(scene, source, callback);
    }

    public void getTransitionList(Callback callback) {
        this.communicator.getTransitionList(callback);
    }

    public void transitionToProgram(String transitionName, int duration, Callback callback) {
        this.communicator.transitionToProgram(transitionName, duration, callback);
    }

    public void getSourceSettings(String sourceName, Callback callback) {
        this.communicator.getSourceSettings(sourceName, callback);
    }

    public void setSourceSettings(String sourceName, Map<String, Object> settings, Callback callback) {
        this.communicator.setSourceSettings(sourceName, settings, callback);
    }

    public void getStreamingStatus(Callback callback) {
        this.communicator.getStreamingStatus(callback);
    }

    public void startStreaming(Callback callback) {
        this.communicator.startStreaming(callback);
    }

    public void stopStreaming(Callback callback) {
        this.communicator.stopStreaming(callback);
    }

    public void listProfiles(Callback callback) {
        this.communicator.listProfiles(callback);
    }

    public void getCurrentProfile(Callback callback) {
        this.communicator.getCurrentProfile(callback);
    }

    public void setCurrentProfile(String profile, Callback callback) {
        this.communicator.setCurrentProfile(profile, callback);
    }

    public void getCurrentScene(Callback callback) {
        this.communicator.getCurrentScene(callback);
    }

    public void getVolume(String source, Callback callback) {
        this.communicator.getVolume(source, callback);
    }

    public void setVolume(String source, double volume, Callback callback) {
        this.communicator.setVolume(source, volume, callback);
    }

    public void setMute(String source, boolean mute, Callback callback) {
        this.communicator.setMute(source, mute, callback);
    }

    public void getPreviewScene(Callback callback) {
        this.communicator.getPreviewScene(callback);
    }

    public void setPreviewScene(String name, Callback callback) {
        this.communicator.setPreviewScene(name, callback);
    }

    public void getTransitionDuration(Callback callback) {
        this.communicator.getTransitionDuration(callback);
    }

    public void setTransitionDuration(int duration, Callback callback) {
        this.communicator.setTransitionDuration(duration, callback);
    }

    public void getStudioModeEnabled(Callback callback) {
        this.communicator.getStudioModeEnabled(callback);
    }

    public void setStudioModeEnabled(boolean enabled, Callback callback) {
        this.communicator.setStudioModeEnabled(enabled, callback);
    }

    public void startReplayBuffer(Callback callback) {
        this.communicator.startReplayBuffer(callback);
    }

    public void stopReplayBuffer(Callback callback) {
        this.communicator.stopReplayBuffer(callback);
    }

    public void saveReplayBuffer(Callback callback) {
        this.communicator.saveReplayBuffer(callback);
    }

    private void runOnError(String message, Throwable throwable) {
        if (this.onError == null) {
            return;
        }
        try {
            this.onError.run(message, throwable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void runOnConnectionFailed(String message) {
        if (this.onConnectionFailed == null) {
            return;
        }
        try {
            this.onConnectionFailed.run(message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

