/*
 * Decompiled with CFR 0.152.
 */
package net.twasi.obsremotejava;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.twasi.obsremotejava.Callback;
import net.twasi.obsremotejava.events.EventType;
import net.twasi.obsremotejava.events.responses.ScenesChangedResponse;
import net.twasi.obsremotejava.events.responses.SwitchScenesResponse;
import net.twasi.obsremotejava.events.responses.TransitionBeginResponse;
import net.twasi.obsremotejava.events.responses.TransitionEndResponse;
import net.twasi.obsremotejava.requests.GetAuthRequired.GetAuthRequiredRequest;
import net.twasi.obsremotejava.requests.GetAuthRequired.GetAuthRequiredResponse;
import net.twasi.obsremotejava.requests.GetCurrentProfile.GetCurrentProfileRequest;
import net.twasi.obsremotejava.requests.GetCurrentProfile.GetCurrentProfileResponse;
import net.twasi.obsremotejava.requests.GetCurrentScene.GetCurrentSceneRequest;
import net.twasi.obsremotejava.requests.GetCurrentScene.GetCurrentSceneResponse;
import net.twasi.obsremotejava.requests.GetPreviewScene.GetPreviewSceneRequest;
import net.twasi.obsremotejava.requests.GetPreviewScene.GetPreviewSceneResponse;
import net.twasi.obsremotejava.requests.GetSceneItemProperties.GetSceneItemPropertiesRequest;
import net.twasi.obsremotejava.requests.GetSceneList.GetSceneListRequest;
import net.twasi.obsremotejava.requests.GetSceneList.GetSceneListResponse;
import net.twasi.obsremotejava.requests.GetSourceSettings.GetSourceSettingsRequest;
import net.twasi.obsremotejava.requests.GetSourceSettings.GetSourceSettingsResponse;
import net.twasi.obsremotejava.requests.GetStreamingStatus.GetStreamingStatusRequest;
import net.twasi.obsremotejava.requests.GetStreamingStatus.GetStreamingStatusResponse;
import net.twasi.obsremotejava.requests.GetStudioModeEnabled.GetStudioModeEnabledRequest;
import net.twasi.obsremotejava.requests.GetStudioModeEnabled.GetStudioModeEnabledResponse;
import net.twasi.obsremotejava.requests.GetTransitionDuration.GetTransitionDurationRequest;
import net.twasi.obsremotejava.requests.GetTransitionDuration.GetTransitionDurationResponse;
import net.twasi.obsremotejava.requests.GetTransitionList.GetTransitionListRequest;
import net.twasi.obsremotejava.requests.GetTransitionList.GetTransitionListResponse;
import net.twasi.obsremotejava.requests.GetVersion.GetVersionRequest;
import net.twasi.obsremotejava.requests.GetVersion.GetVersionResponse;
import net.twasi.obsremotejava.requests.GetVolume.GetVolumeRequest;
import net.twasi.obsremotejava.requests.GetVolume.GetVolumeResponse;
import net.twasi.obsremotejava.requests.ListProfiles.ListProfilesRequest;
import net.twasi.obsremotejava.requests.ListProfiles.ListProfilesResponse;
import net.twasi.obsremotejava.requests.ResponseBase;
import net.twasi.obsremotejava.requests.SaveReplayBuffer.SaveReplayBufferRequest;
import net.twasi.obsremotejava.requests.SaveReplayBuffer.SaveReplayBufferResponse;
import net.twasi.obsremotejava.requests.SetCurrentProfile.SetCurrentProfileRequest;
import net.twasi.obsremotejava.requests.SetCurrentProfile.SetCurrentProfileResponse;
import net.twasi.obsremotejava.requests.SetCurrentScene.SetCurrentSceneRequest;
import net.twasi.obsremotejava.requests.SetCurrentScene.SetCurrentSceneResponse;
import net.twasi.obsremotejava.requests.SetCurrentTransition.SetCurrentTransitionRequest;
import net.twasi.obsremotejava.requests.SetCurrentTransition.SetCurrentTransitionResponse;
import net.twasi.obsremotejava.requests.SetMute.SetMuteRequest;
import net.twasi.obsremotejava.requests.SetMute.SetMuteResponse;
import net.twasi.obsremotejava.requests.SetPreviewScene.SetPreviewSceneRequest;
import net.twasi.obsremotejava.requests.SetPreviewScene.SetPreviewSceneResponse;
import net.twasi.obsremotejava.requests.SetSceneItemProperties.SetSceneItemPropertiesRequest;
import net.twasi.obsremotejava.requests.SetSceneItemProperties.SetSceneItemPropertiesResponse;
import net.twasi.obsremotejava.requests.SetSourceSettings.SetSourceSettingsRequest;
import net.twasi.obsremotejava.requests.SetSourceSettings.SetSourceSettingsResponse;
import net.twasi.obsremotejava.requests.SetStudioModeEnabled.SetStudioModeEnabledRequest;
import net.twasi.obsremotejava.requests.SetStudioModeEnabled.SetStudioModeEnabledResponse;
import net.twasi.obsremotejava.requests.SetTransitionDuration.SetTransitionDurationRequest;
import net.twasi.obsremotejava.requests.SetTransitionDuration.SetTransitionDurationResponse;
import net.twasi.obsremotejava.requests.SetVolume.SetVolumeRequest;
import net.twasi.obsremotejava.requests.SetVolume.SetVolumeResponse;
import net.twasi.obsremotejava.requests.StartReplayBuffer.StartReplayBufferRequest;
import net.twasi.obsremotejava.requests.StartReplayBuffer.StartReplayBufferResponse;
import net.twasi.obsremotejava.requests.StartStreaming.StartStreamingRequest;
import net.twasi.obsremotejava.requests.StartStreaming.StartStreamingResponse;
import net.twasi.obsremotejava.requests.StopReplayBuffer.StopReplayBufferRequest;
import net.twasi.obsremotejava.requests.StopReplayBuffer.StopReplayBufferResponse;
import net.twasi.obsremotejava.requests.StopStreaming.StopStreamingRequest;
import net.twasi.obsremotejava.requests.StopStreaming.StopStreamingResponse;
import net.twasi.obsremotejava.requests.TransitionToProgram.TransitionToProgramRequest;
import net.twasi.obsremotejava.requests.TransitionToProgram.TransitionToProgramResponse;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;

@WebSocket(maxTextMessageSize=65536, maxIdleTime=360000000)
public class OBSCommunicator {
    private boolean debug;
    private final CountDownLatch closeLatch;
    public final Map<String, Class> messageTypes = new HashMap<String, Class>();
    private final Map<Class, Callback> callbacks = new HashMap<Class, Callback>();
    private Session session;
    private Callback onConnect;
    private Callback onDisconnect;
    private Callback onReplayStarted;
    private Callback onReplayStarting;
    private Callback onReplayStopped;
    private Callback onReplayStopping;
    private Callback onSwitchScenes;
    private Callback onScenesChanged;
    private Callback onTransitionBegin;
    private Callback onTransitionEnd;
    private GetVersionResponse versionInfo;

    public OBSCommunicator(boolean debug) {
        this.closeLatch = new CountDownLatch(1);
        this.debug = debug;
    }

    public boolean awaitClose(int duration, TimeUnit unit) throws InterruptedException {
        return this.closeLatch.await(duration, unit);
    }

    public void await() throws InterruptedException {
        this.closeLatch.await();
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        System.out.printf("Connection closed: %d - %s%n", statusCode, reason);
        this.closeLatch.countDown();
        this.onDisconnect.run(null);
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        this.session = session;
        try {
            Future fut = session.getRemote().sendStringByFuture(new Gson().toJson((Object)new GetVersionRequest(this)));
            fut.get(2L, TimeUnit.SECONDS);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @OnWebSocketMessage
    public void onMessage(String msg) {
        block27: {
            try {
                EventType eventType;
                if (msg == null) {
                    System.out.println("Ignored empty message");
                    return;
                }
                if (this.debug) {
                    System.out.println(msg);
                }
                if (((JsonObject)new Gson().fromJson(msg, JsonObject.class)).has("message-id")) {
                    ResponseBase responseBase = (ResponseBase)new Gson().fromJson(msg, ResponseBase.class);
                    Class type = this.messageTypes.get(responseBase.getMessageId());
                    responseBase = (ResponseBase)new Gson().fromJson(msg, type);
                    switch (type.getSimpleName()) {
                        case "GetVersionResponse": {
                            this.versionInfo = (GetVersionResponse)responseBase;
                            System.out.printf("Connected to OBS. Websocket Version: %s, Studio Version: %s\n", this.versionInfo.getObsWebsocketVersion(), this.versionInfo.getObsStudioVersion());
                            this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)new GetAuthRequiredRequest(this)));
                            break;
                        }
                        case "GetAuthRequiredResponse": {
                            GetAuthRequiredResponse authRequiredResponse = (GetAuthRequiredResponse)responseBase;
                            if (authRequiredResponse.isAuthRequired()) {
                                System.out.println("Authentication is required.");
                                break;
                            }
                            System.out.println("Authentication is not required. You're ready to go!");
                            this.onConnect.run(this.versionInfo);
                            break;
                        }
                        default: {
                            if (this.callbacks.containsKey(type)) {
                                this.callbacks.get(type).run(responseBase);
                                break;
                            }
                            System.out.println("Invalid type received: " + type.getName());
                            break;
                        }
                    }
                    break block27;
                }
                JsonElement elem = new JsonParser().parse(msg);
                try {
                    eventType = EventType.valueOf(elem.getAsJsonObject().get("update-type").getAsString());
                }
                catch (Exception e) {
                    return;
                }
                switch (eventType) {
                    case ReplayStarted: {
                        if (this.onReplayStarted == null) break;
                        this.onReplayStarted.run(null);
                        break;
                    }
                    case ReplayStarting: {
                        if (this.onReplayStarting == null) break;
                        this.onReplayStarting.run(null);
                        break;
                    }
                    case ReplayStopped: {
                        if (this.onReplayStopped == null) break;
                        this.onReplayStopped.run(null);
                        break;
                    }
                    case ReplayStopping: {
                        if (this.onReplayStopping == null) break;
                        this.onReplayStopping.run(null);
                        break;
                    }
                    case SwitchScenes: {
                        if (this.onSwitchScenes == null) break;
                        this.onSwitchScenes.run((ResponseBase)new Gson().fromJson(msg, SwitchScenesResponse.class));
                        break;
                    }
                    case ScenesChanged: {
                        if (this.onScenesChanged == null) break;
                        this.onScenesChanged.run((ResponseBase)new Gson().fromJson(msg, ScenesChangedResponse.class));
                        break;
                    }
                    case TransitionBegin: {
                        if (this.onTransitionBegin == null) break;
                        this.onTransitionBegin.run((ResponseBase)new Gson().fromJson(msg, TransitionBeginResponse.class));
                        break;
                    }
                    case TransitionEnd: {
                        if (this.onTransitionEnd == null) break;
                        this.onTransitionEnd.run((ResponseBase)new Gson().fromJson(msg, TransitionEndResponse.class));
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Websocket Exception: " + e.getMessage());
            }
        }
    }

    public void registerOnConnect(Callback onConnect) {
        this.onConnect = onConnect;
    }

    public void registerOnDisconnect(Callback onDisconnect) {
        this.onDisconnect = onDisconnect;
    }

    public void registerOnReplayStarted(Callback onReplayStarted) {
        this.onReplayStarted = onReplayStarted;
    }

    public void registerOnReplayStarting(Callback onReplayStarting) {
        this.onReplayStarting = onReplayStarting;
    }

    public void registerOnReplayStopped(Callback onReplayStopped) {
        this.onReplayStopped = onReplayStopped;
    }

    public void registerOnReplayStopping(Callback onReplayStopping) {
        this.onReplayStopping = onReplayStopping;
    }

    public void registerOnSwitchScenes(Callback onSwitchScenes) {
        this.onSwitchScenes = onSwitchScenes;
    }

    public void registerOnScenesChanged(Callback onScenesChanged) {
        this.onScenesChanged = onScenesChanged;
    }

    public void registerOnTransitionBegin(Callback onTransitionBegin) {
        this.onTransitionBegin = onTransitionBegin;
    }

    public void registerOnTransitionEnd(Callback onTransitionEnd) {
        this.onTransitionEnd = onTransitionEnd;
    }

    public void getScenes(Callback callback) {
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)new GetSceneListRequest(this)));
        this.callbacks.put(GetSceneListResponse.class, callback);
    }

    public void setCurrentScene(String scene, Callback callback) {
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)new SetCurrentSceneRequest(this, scene)));
        this.callbacks.put(SetCurrentSceneResponse.class, callback);
    }

    public void setCurrentTransition(String transition, Callback callback) {
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)new SetCurrentTransitionRequest(this, transition)));
        this.callbacks.put(SetCurrentTransitionResponse.class, callback);
    }

    public void setSourceVisiblity(String scene, String source, boolean visibility, Callback callback) {
        SetSceneItemPropertiesRequest request = new SetSceneItemPropertiesRequest(this, scene, source, visibility);
        System.out.println(new Gson().toJson((Object)request));
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(SetSceneItemPropertiesResponse.class, callback);
    }

    public void getSceneItemProperties(String scene, String source, Callback callback) {
        GetSceneItemPropertiesRequest request = new GetSceneItemPropertiesRequest(this, scene, source);
        System.out.println(new Gson().toJson((Object)request));
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(SetSceneItemPropertiesResponse.class, callback);
    }

    public void getTransitionList(Callback callback) {
        GetTransitionListRequest request = new GetTransitionListRequest(this);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(GetTransitionListResponse.class, callback);
    }

    public void transitionToProgram(String transitionName, int duration, Callback callback) {
        TransitionToProgramRequest request = new TransitionToProgramRequest(this, transitionName, duration);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(TransitionToProgramResponse.class, callback);
    }

    public void getSourceSettings(String sourceName, Callback callback) {
        GetSourceSettingsRequest request = new GetSourceSettingsRequest(this, sourceName);
        System.out.println(new Gson().toJson((Object)request));
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(GetSourceSettingsResponse.class, callback);
    }

    public void setSourceSettings(String sourceName, Map<String, Object> settings, Callback callback) {
        SetSourceSettingsRequest request = new SetSourceSettingsRequest(this, sourceName, settings);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(SetSourceSettingsResponse.class, callback);
    }

    public void getStreamingStatus(Callback callback) {
        GetStreamingStatusRequest request = new GetStreamingStatusRequest(this);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(GetStreamingStatusResponse.class, callback);
    }

    public void startStreaming(Callback callback) {
        StartStreamingRequest request = new StartStreamingRequest(this);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(StartStreamingResponse.class, callback);
    }

    public void stopStreaming(Callback callback) {
        StopStreamingRequest request = new StopStreamingRequest(this);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(StopStreamingResponse.class, callback);
    }

    public void listProfiles(Callback callback) {
        ListProfilesRequest request = new ListProfilesRequest(this);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(ListProfilesResponse.class, callback);
    }

    public void getCurrentProfile(Callback callback) {
        GetCurrentProfileRequest request = new GetCurrentProfileRequest(this);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(GetCurrentProfileResponse.class, callback);
    }

    public void setCurrentProfile(String profile, Callback callback) {
        SetCurrentProfileRequest request = new SetCurrentProfileRequest(this, profile);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(SetCurrentProfileResponse.class, callback);
    }

    public void getCurrentScene(Callback callback) {
        GetCurrentSceneRequest request = new GetCurrentSceneRequest(this);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(GetCurrentSceneResponse.class, callback);
    }

    public void getVolume(String source, Callback callback) {
        GetVolumeRequest request = new GetVolumeRequest(this, source);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(GetVolumeResponse.class, callback);
    }

    public void setVolume(String source, double volume, Callback callback) {
        SetVolumeRequest request = new SetVolumeRequest(this, source, volume);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(SetVolumeResponse.class, callback);
    }

    public void setMute(String source, boolean mute, Callback callback) {
        SetMuteRequest request = new SetMuteRequest(this, source, mute);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(SetMuteResponse.class, callback);
    }

    public void getPreviewScene(Callback callback) {
        GetPreviewSceneRequest request = new GetPreviewSceneRequest(this);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(GetPreviewSceneResponse.class, callback);
    }

    public void setPreviewScene(String name, Callback callback) {
        SetPreviewSceneRequest request = new SetPreviewSceneRequest(this, name);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(SetPreviewSceneResponse.class, callback);
    }

    public void getTransitionDuration(Callback callback) {
        GetTransitionDurationRequest request = new GetTransitionDurationRequest(this);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(GetTransitionDurationResponse.class, callback);
    }

    public void setTransitionDuration(int duration, Callback callback) {
        SetTransitionDurationRequest request = new SetTransitionDurationRequest(this, duration);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(SetTransitionDurationResponse.class, callback);
    }

    public void startReplayBuffer(Callback callback) {
        StartReplayBufferRequest request = new StartReplayBufferRequest(this);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(StartReplayBufferResponse.class, callback);
    }

    public void stopReplayBuffer(Callback callback) {
        StopReplayBufferRequest request = new StopReplayBufferRequest(this);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(StopReplayBufferResponse.class, callback);
    }

    public void saveReplayBuffer(Callback callback) {
        SaveReplayBufferRequest request = new SaveReplayBufferRequest(this);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(SaveReplayBufferResponse.class, callback);
    }

    public void getStudioModeEnabled(Callback callback) {
        GetStudioModeEnabledRequest request = new GetStudioModeEnabledRequest(this);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(GetStudioModeEnabledResponse.class, callback);
    }

    public void setStudioModeEnabled(boolean enabled, Callback callback) {
        SetStudioModeEnabledRequest request = new SetStudioModeEnabledRequest(this, enabled);
        this.session.getRemote().sendStringByFuture(new Gson().toJson((Object)request));
        this.callbacks.put(SetStudioModeEnabledResponse.class, callback);
    }
}

