/*
 * Decompiled with CFR 0.152.
 */
package net.twasi.obsremotejava;

import java.net.ConnectException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.twasi.obsremotejava.Callback;
import net.twasi.obsremotejava.OBSCommunicator;
import net.twasi.obsremotejava.requests.ResponseBase;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;

public class OBSRemoteController {
    private String address;
    private OBSCommunicator communicator;
    private WebSocketClient client;
    private boolean failed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OBSRemoteController(String address, boolean debug) {
        this.address = address;
        this.communicator = new OBSCommunicator(debug);
        this.client = new WebSocketClient();
        try {
            this.client.start();
            URI uri = new URI(address);
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            Future connection = this.client.connect((Object)this.communicator, uri, request);
            System.out.printf("Connecting to: %s%n", uri);
            try {
                connection.get();
                this.failed = false;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof ConnectException) {
                    System.out.println("Connection to OBS failed.");
                    this.failed = true;
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void getScenes(Callback callback) {
        this.communicator.getScenes(callback);
    }

    public void registerConnectCallback(Callback onConnect) {
        this.communicator.registerOnConnect(onConnect);
    }

    public void registerDisconnectCallback(Callback onDisconnect) {
        this.communicator.registerOnDisconnect(onDisconnect);
    }

    public void registerReplayStartedCallback(Callback onReplayStarted) {
        this.communicator.registerOnReplayStarted(onReplayStarted);
    }

    public void registerReplayStartingCallback(Callback onReplayStarting) {
        this.communicator.registerOnReplayStarting(onReplayStarting);
    }

    public void registerReplayStoppedCallback(Callback onReplayStopped) {
        this.communicator.registerOnReplayStopped(onReplayStopped);
    }

    public void registerReplayStoppingCallback(Callback onReplayStopping) {
        this.communicator.registerOnReplayStopping(onReplayStopping);
    }

    public void await() throws InterruptedException {
        this.communicator.await();
    }

    public void setCurrentScene(String szene, Callback callback) {
        this.communicator.setCurrentScene(szene, callback);
    }

    public void setCurrentTransition(String transition, Callback callback) {
        this.communicator.setCurrentTransition(transition, callback);
    }

    public void changeSceneWithTransition(final String scene, String transition, final Callback callback) {
        this.communicator.setCurrentTransition(transition, new Callback(){

            @Override
            public void run(ResponseBase response) {
                if (!response.getStatus().equals("ok")) {
                    System.out.println("Failed to change transition. Pls fix.");
                }
                OBSRemoteController.this.communicator.setCurrentScene(scene, callback);
            }
        });
    }

    public void setSourceVisibility(String scene, String source, boolean visibility, Callback callback) {
        this.communicator.setSourceVisiblity(scene, source, visibility, callback);
    }

    public void getSceneItemProperties(String scene, String source, Callback callback) {
        this.communicator.getSceneItemProperties(scene, source, callback);
    }

    public void getTransitionList(Callback callback) {
        this.communicator.getTransitionList(callback);
    }

    public void transitionToProgram(String transitionName, int duration, Callback callback) {
        this.communicator.transitionToProgram(transitionName, duration, callback);
    }

    public void getSourceSettings(String sourceName, Callback callback) {
        this.communicator.getSourceSettings(sourceName, callback);
    }

    public void setSourceSettings(String sourceName, Map<String, Object> settings, Callback callback) {
        this.communicator.setSourceSettings(sourceName, settings, callback);
    }

    public void getStreamingStatus(Callback callback) {
        this.communicator.getStreamingStatus(callback);
    }

    public void startStreaming(Callback callback) {
        this.communicator.startStreaming(callback);
    }

    public void stopStreaming(Callback callback) {
        this.communicator.stopStreaming(callback);
    }

    public void listProfiles(Callback callback) {
        this.communicator.listProfiles(callback);
    }

    public void getCurrentProfile(Callback callback) {
        this.communicator.getCurrentProfile(callback);
    }

    public void setCurrentProfile(String profile, Callback callback) {
        this.communicator.setCurrentProfile(profile, callback);
    }

    public void getCurrentScene(Callback callback) {
        this.communicator.getCurrentScene(callback);
    }

    public void getVolume(String source, Callback callback) {
        this.communicator.getVolume(source, callback);
    }

    public void setVolume(String source, double volume, Callback callback) {
        this.communicator.setVolume(source, volume, callback);
    }

    public void setMute(String source, boolean mute, Callback callback) {
        this.communicator.setMute(source, mute, callback);
    }

    public void getPreviewScene(Callback callback) {
        this.communicator.getPreviewScene(callback);
    }

    public void setPreviewScene(String name, Callback callback) {
        this.communicator.setPreviewScene(name, callback);
    }

    public void getTransitionDuration(Callback callback) {
        this.communicator.getTransitionDuration(callback);
    }

    public void setTransitionDuration(int duration, Callback callback) {
        this.communicator.setTransitionDuration(duration, callback);
    }

    public void getStudioModeEnabled(Callback callback) {
        this.communicator.getStudioModeEnabled(callback);
    }

    public void setStudioModeEnabled(boolean enabled, Callback callback) {
        this.communicator.setStudioModeEnabled(enabled, callback);
    }

    public void startReplayBuffer(Callback callback) {
        this.communicator.startReplayBuffer(callback);
    }

    public void stopReplayBuffer(Callback callback) {
        this.communicator.stopReplayBuffer(callback);
    }

    public void saveReplayBuffer(Callback callback) {
        this.communicator.saveReplayBuffer(callback);
    }
}

