/*
 * Decompiled with CFR 0.152.
 */
package net.toddm.comm.tests;

import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import junit.framework.TestCase;
import net.toddm.cache.CachePriority;
import net.toddm.cache.DefaultLogger;
import net.toddm.cache.LoggingProvider;
import net.toddm.comm.CacheBehavior;
import net.toddm.comm.CommManager;
import net.toddm.comm.DependentWorkListener;
import net.toddm.comm.MapConfigurationProvider;
import net.toddm.comm.Priority;
import net.toddm.comm.Request;
import net.toddm.comm.Response;
import net.toddm.comm.SubmittableWork;
import net.toddm.comm.Work;
import org.junit.Test;

public class TestWork
extends TestCase {
    @Test
    public void testGetException() throws Exception {
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManagerThatWillTimeout = commManagerBuilder.setConfigurationProvider(new MapConfigurationProvider((Map<String, Object>)new HashMap<String, Object>(){
            private static final long serialVersionUID = 9063689608986469630L;
            {
                this.put("connect_timeout_milliseconds", 1);
                this.put("read_timeout_milliseconds", 1);
            }
        })).setName("TEST").setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManagerThatWillTimeout.enqueueWork(new URI("https://toddm.net/"), Request.RequestMethod.GET, null, null, false, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        TestWork.assertNotNull((Object)work);
        try {
            Response response = work.get();
            TestWork.assertNull((Object)response);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        TestWork.assertNotNull((Object)work.getException());
        TestWork.assertTrue((boolean)(work.getException() instanceof SocketTimeoutException));
    }

    @Test
    public void testDependentWorkCallbackAllowsCurrentWork() throws Exception {
        CommManager commManager = new CommManager.Builder().setName("TEST").setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        final SubmittableWork work1 = commManager.getWork(new URI("https://toddm.net/"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        final SubmittableWork work2 = commManager.getWork(new URI("http://toddm.net/art/index.html"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        final SubmittableWork work3 = commManager.getWork(new URI("http://toddm.net/ants/index.html"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        final SubmittableWork work4 = commManager.getWork(new URI("http://toddm.net/gravity/index.html"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        DependentWorkListener dependentWorkListener = new DependentWorkListener(){

            @Override
            public boolean onDependentWorkCompleted(Work dependentWork, Work currentWork) {
                TestCase.assertTrue((currentWork.getId() == work1.getId() && dependentWork.getId() == work2.getId() || currentWork.getId() == work2.getId() && dependentWork.getId() == work3.getId() || currentWork.getId() == work3.getId() && dependentWork.getId() == work4.getId() ? 1 : 0) != 0);
                return true;
            }
        };
        work1.setDependentWork(work2, dependentWorkListener);
        work2.setDependentWork(work3, dependentWorkListener);
        work3.setDependentWork(work4, dependentWorkListener);
        Work work = commManager.enqueueWork(work1);
        Response result = work.get();
        TestWork.assertNotNull((Object)result);
        TestWork.assertTrue((boolean)result.isSuccessful());
        Response result2 = ((Work)work2).get();
        TestWork.assertNotNull((Object)result2);
        TestWork.assertTrue((boolean)result2.isSuccessful());
        Response result3 = ((Work)work3).get();
        TestWork.assertNotNull((Object)result3);
        TestWork.assertTrue((boolean)result3.isSuccessful());
        Response result4 = ((Work)work4).get();
        TestWork.assertNotNull((Object)result4);
        TestWork.assertTrue((boolean)result4.isSuccessful());
    }

    @Test
    public void testDependentWorkCallbackCancelsCurrentWork() throws Exception {
        CommManager commManager = new CommManager.Builder().setName("TEST").setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        final SubmittableWork work1 = commManager.getWork(new URI("https://toddm.net/"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        final SubmittableWork work2 = commManager.getWork(new URI("http://toddm.net/art/index.html"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        DependentWorkListener dependentWorkListener = new DependentWorkListener(){

            @Override
            public boolean onDependentWorkCompleted(Work dependentWork, Work currentWork) {
                TestCase.assertEquals((int)work1.getId(), (int)currentWork.getId());
                TestCase.assertEquals((int)work2.getId(), (int)dependentWork.getId());
                return false;
            }
        };
        work1.setDependentWork(work2, dependentWorkListener);
        Work work = commManager.enqueueWork(work1);
        Response result = work.get();
        TestWork.assertNull((Object)result);
        TestWork.assertEquals((Object)((Object)Work.Status.CANCELLED), (Object)((Object)work.getState()));
        Response result2 = ((Work)work2).get();
        TestWork.assertNotNull((Object)result2);
        TestWork.assertTrue((boolean)result2.isSuccessful());
    }

    @Test
    public void testSetDependentWorkCyclicDependence() throws Exception {
        CommManager commManager = new CommManager.Builder().setName("TEST").setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        SubmittableWork work1 = commManager.getWork(new URI("https://toddm.net/one"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        SubmittableWork work2 = commManager.getWork(new URI("https://toddm.net/two"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        SubmittableWork work3 = commManager.getWork(new URI("https://toddm.net/three"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        SubmittableWork work4 = commManager.getWork(new URI("https://toddm.net/four"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        SubmittableWork work5 = commManager.getWork(new URI("https://toddm.net/five"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        work1.setDependentWork(work2, null);
        work2.setDependentWork(work3, null);
        work3.setDependentWork(work4, null);
        work4.setDependentWork(work5, null);
        try {
            work5.setDependentWork(work1, null);
            TestWork.fail((String)"Expected IllegalArgumentException due to cyclic dependence");
        }
        catch (IllegalArgumentException e) {
            TestWork.assertEquals((String)"Cyclic dependence detected", (String)e.getMessage());
        }
    }
}

