/*
 * Decompiled with CFR 0.152.
 */
package net.toddm.comm.tests;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import net.toddm.cache.CachePriority;
import net.toddm.cache.DefaultLogger;
import net.toddm.cache.LoggingProvider;
import net.toddm.comm.CacheBehavior;
import net.toddm.comm.CommManager;
import net.toddm.comm.MapConfigurationProvider;
import net.toddm.comm.Priority;
import net.toddm.comm.Request;
import net.toddm.comm.Response;
import net.toddm.comm.Work;
import org.junit.Test;

public class TestSSL
extends TestCase {
    @Test
    public void testGoodCert() throws Exception {
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManager = commManagerBuilder.setName("TEST").setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI("https://httpbin.org/status/200"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        TestSSL.assertNotNull((Object)work);
        Response response = work.get();
        TestSSL.assertNotNull((Object)response);
        TestSSL.assertEquals((int)200, (int)response.getResponseCode());
    }

    @Test
    public void testBadCert() throws Exception {
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManagerNoCerts = commManagerBuilder.setConfigurationProvider(new MapConfigurationProvider((Map<String, Object>)new HashMap<String, Object>(){
            private static final long serialVersionUID = 9063689608986469630L;
            {
                this.put("disable_ssl_cert_checking", true);
            }
        })).setName("TEST").setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManagerNoCerts.enqueueWork(new URI("https://testssl-expire.disig.sk/index.en.html"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        TestSSL.assertNotNull((Object)work);
        Response response = work.get();
        TestSSL.assertNotNull((Object)response);
        TestSSL.assertEquals((int)200, (int)response.getResponseCode());
        CommManager commManagerWithCerts = commManagerBuilder.setConfigurationProvider(new MapConfigurationProvider((Map<String, Object>)new HashMap<String, Object>(){
            private static final long serialVersionUID = 9063689608986469630L;
            {
                this.put("disable_ssl_cert_checking", false);
            }
        })).setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        work = commManagerWithCerts.enqueueWork(new URI("https://testssl-expire.disig.sk/index.en.html"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        TestSSL.assertNotNull((Object)work);
        response = work.get();
        TestSSL.assertNull((Object)response);
    }
}

