/*
 * Decompiled with CFR 0.152.
 */
package net.toddm.comm.tests;

import java.net.URI;
import java.util.Locale;
import java.util.UUID;
import junit.framework.TestCase;
import net.toddm.cache.CacheEntry;
import net.toddm.cache.CachePriority;
import net.toddm.cache.CacheProvider;
import net.toddm.cache.DefaultLogger;
import net.toddm.cache.LoggingProvider;
import net.toddm.cache.MemoryCacheProvider;
import net.toddm.comm.CacheBehavior;
import net.toddm.comm.CommManager;
import net.toddm.comm.Priority;
import net.toddm.comm.Request;
import net.toddm.comm.Response;
import net.toddm.comm.Work;
import org.junit.Test;

public class TestResponse
extends TestCase {
    @Test
    public void testInvalidateCache() throws Exception {
        MemoryCacheProvider cache = new MemoryCacheProvider("testInvalidateCache", 20, (LoggingProvider)new DefaultLogger());
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManager = commManagerBuilder.setName("testInvalidateCache").setCacheProvider((CacheProvider)cache).setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI("http://httpbin.org/cache/1000"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.NORMAL);
        TestResponse.assertNotNull((Object)work);
        Response response = work.get();
        TestResponse.assertNotNull((Object)response);
        TestResponse.assertEquals((int)200, (int)response.getResponseCode());
        String cacheKey = Integer.toString(work.getId());
        TestResponse.assertTrue((boolean)cache.containsKey(cacheKey, false));
        commManager.invalidateCache(work.getId());
        TestResponse.assertTrue((boolean)cache.containsKey(cacheKey, true));
        TestResponse.assertFalse((boolean)cache.containsKey(cacheKey, false));
    }

    @Test
    public void testPurgeCache() throws Exception {
        MemoryCacheProvider cache = new MemoryCacheProvider("testPurgeCache", 20, (LoggingProvider)new DefaultLogger());
        TestResponse.validatePurgeCache((CacheProvider)cache);
    }

    @Test
    public static void validatePurgeCache(CacheProvider cache) throws Exception {
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManager = commManagerBuilder.setName("testPurgeCache").setCacheProvider(cache).setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work1 = commManager.enqueueWork(new URI("http://httpbin.org/cache/1000"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.NORMAL);
        TestResponse.assertNotNull((Object)work1);
        Response response = work1.get();
        TestResponse.assertNotNull((Object)response);
        TestResponse.assertEquals((int)200, (int)response.getResponseCode());
        Work work2 = commManager.enqueueWork(new URI("http://httpbin.org/cache/2000"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.NORMAL);
        TestResponse.assertNotNull((Object)work2);
        response = work2.get();
        TestResponse.assertNotNull((Object)response);
        TestResponse.assertEquals((int)200, (int)response.getResponseCode());
        String cacheKey1 = Integer.toString(work1.getId());
        TestResponse.assertTrue((boolean)cache.containsKey(cacheKey1, false));
        String cacheKey2 = Integer.toString(work2.getId());
        TestResponse.assertTrue((boolean)cache.containsKey(cacheKey2, false));
        commManager.purgeCache(work1.getId());
        TestResponse.assertFalse((boolean)cache.containsKey(cacheKey1, true));
        TestResponse.assertTrue((boolean)cache.containsKey(cacheKey2, true));
        commManager.purgeCache();
        TestResponse.assertFalse((boolean)cache.containsKey(cacheKey1, true));
        TestResponse.assertFalse((boolean)cache.containsKey(cacheKey2, true));
    }

    @Test
    public void testGetLocationFromHeadersAbsolute() throws Exception {
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManager = commManagerBuilder.setName("TEST").setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI("http://httpbin.org/response-headers?Location=https%3A%2F%2Ftoddm.net%2F"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        TestResponse.assertNotNull((Object)work);
        Response response = work.get();
        TestResponse.assertNotNull((Object)response);
        TestResponse.assertEquals((int)200, (int)response.getResponseCode());
        URI locationHeaderValue = response.getLocationFromHeaders(work.getRequest());
        TestResponse.assertNotNull((Object)locationHeaderValue);
        TestResponse.assertEquals((String)"https://toddm.net/", (String)locationHeaderValue.toString());
    }

    @Test
    public void testGetLocationFromHeadersRelative() throws Exception {
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManager = commManagerBuilder.setName("TEST").setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI("http://httpbin.org/response-headers?Location=%2Fget"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        TestResponse.assertNotNull((Object)work);
        Response response = work.get();
        TestResponse.assertNotNull((Object)response);
        TestResponse.assertEquals((int)200, (int)response.getResponseCode());
        URI locationHeaderValue = response.getLocationFromHeaders(work.getRequest());
        TestResponse.assertNotNull((Object)locationHeaderValue);
        TestResponse.assertEquals((String)"http://httpbin.org/get?Location=/get", (String)locationHeaderValue.toString());
    }

    @Test
    public void testGetETagFromHeaders() throws Exception {
        String eTag = UUID.randomUUID().toString();
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManager = commManagerBuilder.setName("TEST").setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI(String.format(Locale.US, "http://httpbin.org/response-headers?ETag=%1$s", eTag)), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        TestResponse.assertNotNull((Object)work);
        Response response = work.get();
        TestResponse.assertNotNull((Object)response);
        TestResponse.assertEquals((int)200, (int)response.getResponseCode());
        TestResponse.assertNotNull((Object)response.getETagFromHeaders());
        TestResponse.assertEquals((String)eTag, (String)response.getETagFromHeaders());
    }

    @Test
    public void testGetTtlFromHeaders() throws Exception {
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManager = commManagerBuilder.setName("TEST").setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI("http://httpbin.org/cache/100"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        TestResponse.assertNotNull((Object)work);
        Response response = work.get();
        TestResponse.assertNotNull((Object)response);
        TestResponse.assertEquals((int)200, (int)response.getResponseCode());
        TestResponse.assertNotNull((Object)response.getTtlFromHeaders());
        TestResponse.assertEquals((long)100000L, (long)response.getTtlFromHeaders());
    }

    @Test
    public void testGetMaxStaleFromHeaders() throws Exception {
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManager = commManagerBuilder.setName("TEST").setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI("http://httpbin.org/response-headers?Cache-Control=public,+max-age=100,+max-stale=13"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        TestResponse.assertNotNull((Object)work);
        Response response = work.get();
        TestResponse.assertNotNull((Object)response);
        TestResponse.assertEquals((int)200, (int)response.getResponseCode());
        TestResponse.assertNotNull((Object)response.getMaxStaleFromHeaders());
        TestResponse.assertEquals((long)13000L, (long)response.getMaxStaleFromHeaders());
    }

    @Test
    public void testShouldNotCacheDueToNoCacheDirective() throws Exception {
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManager = commManagerBuilder.setName("TEST").setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI("http://httpbin.org/response-headers?Cache-Control=no-cache"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.HIGH, CacheBehavior.NORMAL);
        TestResponse.assertNotNull((Object)work);
        Response response = work.get();
        TestResponse.assertNotNull((Object)response);
        TestResponse.assertEquals((int)200, (int)response.getResponseCode());
        TestResponse.assertTrue((boolean)response.shouldNotCacheDueToNoCacheDirective());
    }

    @Test
    public void testGetRetryAfterSeconds() throws Exception {
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManager = commManagerBuilder.setName("TEST").setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI("http://httpbin.org/response-headers?Retry-After=120"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        TestResponse.assertNotNull((Object)work);
        Response response = work.get();
        TestResponse.assertNotNull((Object)response);
        TestResponse.assertEquals((int)200, (int)response.getResponseCode());
        TestResponse.assertNotNull((Object)response.getRetryAfter());
        TestResponse.assertEquals((long)120L, (long)response.getRetryAfter());
    }

    @Test
    public void testGetRetryAfterHTTPDateInTheFuture() throws Exception {
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManager = commManagerBuilder.setName("TEST").setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI("http://httpbin.org/response-headers?Retry-After=Fri%2C%2007%20Nov%202088%2023%3A59%3A59%20GMT"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        TestResponse.assertNotNull((Object)work);
        Response response = work.get();
        TestResponse.assertNotNull((Object)response);
        TestResponse.assertEquals((int)200, (int)response.getResponseCode());
        TestResponse.assertNotNull((Object)response.getRetryAfter());
        TestResponse.assertTrue((response.getRetryAfter() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testGetRetryAfterHTTPDateInThePast() throws Exception {
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManager = commManagerBuilder.setName("TEST").setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI("http://httpbin.org/response-headers?Retry-After=Fri%2C%2007%20Nov%202014%2023%3A59%3A59%20GMT"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        TestResponse.assertNotNull((Object)work);
        Response response = work.get();
        TestResponse.assertNotNull((Object)response);
        TestResponse.assertEquals((int)200, (int)response.getResponseCode());
        TestResponse.assertNotNull((Object)response.getRetryAfter());
        TestResponse.assertTrue((response.getRetryAfter() < 0L ? 1 : 0) != 0);
    }

    @Test
    public void test304Responses() throws Exception {
        MemoryCacheProvider cache = new MemoryCacheProvider("testCache", 20, (LoggingProvider)new DefaultLogger());
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManager = commManagerBuilder.setName("TEST").setCacheProvider((CacheProvider)cache).setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI("http://httpbin.org/cache"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.NORMAL);
        TestResponse.assertNotNull((Object)work);
        Response response = work.get();
        TestResponse.assertNotNull((Object)response);
        TestResponse.assertEquals((int)200, (int)response.getResponseCode());
        CacheEntry cacheEntry = cache.get(Integer.toString(work.getId()), true);
        cache.add(cacheEntry.getKey(), cacheEntry.getBytesValue(), 100L, 0L, cacheEntry.getEtag(), cacheEntry.getUri(), cacheEntry.getPriority());
        Thread.sleep(101L);
        work = commManager.enqueueWork(new URI("http://httpbin.org/cache"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.NORMAL);
        TestResponse.assertNotNull((Object)work);
        response = work.get();
        TestResponse.assertNotNull((Object)response);
        TestResponse.assertEquals((int)200, (int)response.getResponseCode());
    }
}

