/*
 * Decompiled with CFR 0.152.
 */
package net.toddm.comm.tests;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import junit.framework.TestCase;
import net.toddm.cache.CachePriority;
import net.toddm.cache.CacheProvider;
import net.toddm.cache.DefaultLogger;
import net.toddm.cache.LoggingProvider;
import net.toddm.cache.MemoryCacheProvider;
import net.toddm.comm.CacheBehavior;
import net.toddm.comm.CommManager;
import net.toddm.comm.Priority;
import net.toddm.comm.Request;
import net.toddm.comm.Response;
import net.toddm.comm.Work;
import org.junit.Test;

public class TestRequest
extends TestCase {
    @Test
    public void testRequest() throws Exception {
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManager = commManagerBuilder.setName("TEST").setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI("https://toddm.net/"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        TestRequest.assertNotNull((Object)work);
        Response response = work.get();
        TestRequest.assertNotNull((Object)response);
        TestRequest.assertEquals((int)200, (int)response.getResponseCode());
        String results = response.getResponseBody();
        System.out.println(results);
        TestRequest.assertNotNull((Object)results);
        TestRequest.assertTrue((results.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRequestCanceling() throws Exception {
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManager = commManagerBuilder.setName("TEST").setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI("https://toddm.net/"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        TestRequest.assertNotNull((Object)work);
        commManager.cancel(work.getId(), true);
        TestRequest.assertTrue((boolean)work.isCancelled());
        String urlPattern = new String("http://httpbin.org/response-headers?sleepTime=%1$d");
        long sleepTime = 20L;
        while (work.isCancelled()) {
            work = commManager.enqueueWork(new URI(String.format(urlPattern, sleepTime)), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
            TestRequest.assertNotNull((Object)work);
            Thread.sleep(sleepTime);
            commManager.cancel(work.getId(), true);
            TestRequest.assertTrue((String)String.format("Expected Cancelled or Done but got '%1$s'", new Object[]{work.getState()}), (work.isCancelled() || work.isDone() ? 1 : 0) != 0);
            sleepTime += 20L;
        }
        TestRequest.assertTrue((boolean)work.isDone());
    }

    @Test
    public void testRequestRedirectAbsolute() throws Exception {
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManager = commManagerBuilder.setName("TEST").setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI("http://httpbin.org/redirect-to?url=https%3A%2F%2Ftoddm.net%2F"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        TestRequest.assertNotNull((Object)work);
        Response response = work.get();
        TestRequest.assertNotNull((Object)response);
        TestRequest.assertEquals((int)200, (int)response.getResponseCode());
        TestRequest.assertEquals((int)1, (int)work.getRequest().getRedirectCount());
    }

    @Test
    public void testRequestRedirectRelative() throws Exception {
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManager = commManagerBuilder.setName("TEST").setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI("http://httpbin.org/relative-redirect/3"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        TestRequest.assertNotNull((Object)work);
        Response response = work.get();
        TestRequest.assertNotNull((Object)response);
        TestRequest.assertEquals((int)200, (int)response.getResponseCode());
        TestRequest.assertEquals((int)3, (int)work.getRequest().getRedirectCount());
    }

    @Test
    public void testRequestWithHeaders() throws Exception {
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManager = commManagerBuilder.setName("TEST").setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Language", "en-US");
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        Work work = commManager.enqueueWork(new URI("https://toddm.net/"), Request.RequestMethod.GET, null, headers, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        TestRequest.assertNotNull((Object)work);
        Response response = work.get();
        TestRequest.assertNotNull((Object)response);
        TestRequest.assertEquals((int)200, (int)response.getResponseCode());
        String results = response.getResponseBody();
        System.out.println(results);
        TestRequest.assertNotNull((Object)results);
        TestRequest.assertTrue((results.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRequestCachingHeaders() throws Exception {
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManager = commManagerBuilder.setName("TEST").setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI("https://httpbin.org/response-headers?Cache-Control=max-age%3D3600000&ETag=todd"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        TestRequest.assertNotNull((Object)work);
        Response response = work.get();
        TestRequest.assertNotNull((Object)response);
        TestRequest.assertEquals((int)200, (int)response.getResponseCode());
        Long ttl = response.getTtlFromHeaders();
        TestRequest.assertNotNull((Object)ttl);
        TestRequest.assertEquals((long)3600000000L, (long)ttl);
        System.out.println("TTL from response headers: " + ttl);
        String eTag = response.getETagFromHeaders();
        TestRequest.assertNotNull((Object)eTag);
        System.out.println("ETag from response headers: " + eTag);
    }

    @Test
    public void testRequestWithCaching() throws Exception {
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManager = commManagerBuilder.setName("TEST").setCacheProvider((CacheProvider)new MemoryCacheProvider("testCache", 20, (LoggingProvider)new DefaultLogger())).setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI("https://toddm.net/"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.NORMAL);
        TestRequest.assertNotNull((Object)work);
        Response response = work.get();
        TestRequest.assertNotNull((Object)response);
        TestRequest.assertEquals((int)200, (int)response.getResponseCode());
        String results = response.getResponseBody();
        System.out.println(results);
        TestRequest.assertNotNull((Object)results);
        TestRequest.assertTrue((results.length() > 0 ? 1 : 0) != 0);
        Work work2 = commManager.enqueueWork(new URI("https://toddm.net/"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.NORMAL);
        TestRequest.assertNotNull((Object)work2);
        Response response2 = work2.get();
        TestRequest.assertNotNull((Object)response2);
        TestRequest.assertEquals((int)200, (int)response2.getResponseCode());
        String results2 = response2.getResponseBody();
        System.out.println(results2);
        TestRequest.assertNotNull((Object)results2);
        TestRequest.assertTrue((results2.length() > 0 ? 1 : 0) != 0);
        TestRequest.assertEquals((int)work.getId(), (int)work2.getId());
    }

    @Test
    public void testNoCachePreventsCaching() throws Exception {
        MemoryCacheProvider cacheProvider = new MemoryCacheProvider("testCache", 20, (LoggingProvider)new DefaultLogger());
        CommManager commManager = new CommManager.Builder().setName("TEST").setCacheProvider((CacheProvider)cacheProvider).setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI("http://httpbin.org/cache/100"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.HIGH, CacheBehavior.NORMAL);
        Response response = work.get();
        TestRequest.assertNotNull((Object)response);
        TestRequest.assertEquals((int)200, (int)response.getResponseCode());
        TestRequest.assertTrue((boolean)cacheProvider.containsKey(Integer.toString(work.getId()), true));
        work = commManager.enqueueWork(new URI("http://httpbin.org/response-headers?Cache-Control=no-cache"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.HIGH, CacheBehavior.NORMAL);
        response = work.get();
        TestRequest.assertNotNull((Object)response);
        TestRequest.assertEquals((int)200, (int)response.getResponseCode());
        TestRequest.assertFalse((boolean)cacheProvider.containsKey(Integer.toString(work.getId()), true));
    }

    @Test
    public void testDoNotCachePreventsCaching() throws Exception {
        MemoryCacheProvider cacheProvider = new MemoryCacheProvider("testCache20w", 20, (LoggingProvider)new DefaultLogger());
        CommManager commManager = new CommManager.Builder().setName("TEST").setCacheProvider((CacheProvider)cacheProvider).setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI("http://httpbin.org/cache/100"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.HIGH, CacheBehavior.NORMAL);
        Response response = work.get();
        TestRequest.assertNotNull((Object)response);
        TestRequest.assertEquals((int)200, (int)response.getResponseCode());
        TestRequest.assertTrue((boolean)cacheProvider.containsKey(Integer.toString(work.getId()), true));
        work = commManager.enqueueWork(new URI("http://httpbin.org/cache/200"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.HIGH, CacheBehavior.DO_NOT_CACHE);
        response = work.get();
        TestRequest.assertNotNull((Object)response);
        TestRequest.assertEquals((int)200, (int)response.getResponseCode());
        TestRequest.assertFalse((boolean)cacheProvider.containsKey(Integer.toString(work.getId()), true));
    }

    @Test
    public void testGetOnlyFromCache() throws Exception {
        MemoryCacheProvider cacheProvider = new MemoryCacheProvider("testCacheThr33", 20, (LoggingProvider)new DefaultLogger());
        CommManager commManager = new CommManager.Builder().setName("TEST").setCacheProvider((CacheProvider)cacheProvider).setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI("http://httpbin.org/cache/500"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.HIGH, CacheBehavior.GET_ONLY_FROM_CACHE);
        Response response = work.get();
        TestRequest.assertNull((Object)response);
        TestRequest.assertFalse((boolean)cacheProvider.containsKey(Integer.toString(work.getId()), true));
        work = commManager.enqueueWork(new URI("http://httpbin.org/cache/500"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.HIGH, CacheBehavior.NORMAL);
        response = work.get();
        TestRequest.assertNotNull((Object)response);
        TestRequest.assertEquals((int)200, (int)response.getResponseCode());
        TestRequest.assertTrue((boolean)cacheProvider.containsKey(Integer.toString(work.getId()), true));
        TestRequest.assertFalse((boolean)response.isFromCache());
        int responseTime = response.getResponseTimeMilliseconds();
        work = commManager.enqueueWork(new URI("http://httpbin.org/cache/500"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.HIGH, CacheBehavior.GET_ONLY_FROM_CACHE);
        response = work.get();
        TestRequest.assertNotNull((Object)response);
        TestRequest.assertEquals((int)200, (int)response.getResponseCode());
        TestRequest.assertTrue((boolean)cacheProvider.containsKey(Integer.toString(work.getId()), true));
        TestRequest.assertTrue((boolean)response.isFromCache());
        TestRequest.assertEquals((int)responseTime, (int)response.getResponseTimeMilliseconds());
    }

    @Test
    public void testServerDirectedCache() throws Exception {
        MemoryCacheProvider cacheProvider = new MemoryCacheProvider("testCache4our", 20, (LoggingProvider)new DefaultLogger());
        CommManager commManager = new CommManager.Builder().setName("TEST").setCacheProvider((CacheProvider)cacheProvider).setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI("http://httpbin.org/response-headers?Cache-Control=blah"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.HIGH, CacheBehavior.SERVER_DIRECTED_CACHE);
        Response response = work.get();
        TestRequest.assertNotNull((Object)response);
        TestRequest.assertEquals((int)200, (int)response.getResponseCode());
        TestRequest.assertFalse((boolean)cacheProvider.containsKey(Integer.toString(work.getId()), true));
        work = commManager.enqueueWork(new URI("http://httpbin.org/cache/200"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.HIGH, CacheBehavior.SERVER_DIRECTED_CACHE);
        response = work.get();
        TestRequest.assertNotNull((Object)response);
        TestRequest.assertEquals((int)200, (int)response.getResponseCode());
        TestRequest.assertTrue((boolean)cacheProvider.containsKey(Integer.toString(work.getId()), true));
    }

    @Test
    public void testMaxStaleBehavior() throws Exception {
        MemoryCacheProvider cacheProvider = new MemoryCacheProvider("testCacheMaxStale", 20, (LoggingProvider)new DefaultLogger());
        CommManager commManager = new CommManager.Builder().setName("TEST_MAX_STALE").setCacheProvider((CacheProvider)cacheProvider).setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI("http://httpbin.org/response-headers?Cache-Control=public,+max-age=1,+max-stale=1"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.NORMAL);
        TestRequest.assertNotNull((Object)work);
        TestRequest.assertEquals((String)"net.toddm.comm.CommWork", (String)work.getClass().getName());
        Response response = work.get();
        TestRequest.assertNotNull((Object)response);
        TestRequest.assertEquals((int)200, (int)response.getResponseCode());
        TestRequest.assertNotNull((Object)response.getTtlFromHeaders());
        TestRequest.assertEquals((long)1000L, (long)response.getTtlFromHeaders());
        TestRequest.assertNotNull((Object)response.getMaxStaleFromHeaders());
        TestRequest.assertEquals((long)1000L, (long)response.getMaxStaleFromHeaders());
        work = commManager.enqueueWork(new URI("http://httpbin.org/response-headers?Cache-Control=public,+max-age=1,+max-stale=1"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.NORMAL);
        TestRequest.assertNotNull((Object)work);
        TestRequest.assertEquals((String)"net.toddm.comm.CachedWork", (String)work.getClass().getName());
        Thread.sleep(1001L);
        work = commManager.enqueueWork(new URI("http://httpbin.org/response-headers?Cache-Control=public,+max-age=1,+max-stale=1"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.NORMAL);
        TestRequest.assertNotNull((Object)work);
        TestRequest.assertEquals((String)"net.toddm.comm.CachedWork", (String)work.getClass().getName());
        work = commManager.enqueueWork(new URI("http://httpbin.org/response-headers?Cache-Control=public,+max-age=1,+max-stale=1"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.NORMAL);
        TestRequest.assertNotNull((Object)work);
        TestRequest.assertEquals((String)"net.toddm.comm.CachedWork", (String)work.getClass().getName());
    }

    @Test
    public void testPutRequest() throws Exception {
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManager = commManagerBuilder.setName("TEST").setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI("http://httpbin.org/put"), Request.RequestMethod.PUT, new String("test POST data for the PUT method").getBytes("UTF-8"), null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        TestRequest.assertNotNull((Object)work);
        Response response = work.get();
        TestRequest.assertNotNull((Object)response);
        TestRequest.assertEquals((int)200, (int)response.getResponseCode());
    }

    @Test
    public void testRequestEquality() throws Exception {
        ArrayList<Work> testRequests = new ArrayList<Work>();
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManager = commManagerBuilder.setName("TEST").setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work1 = commManager.enqueueWork(new URI("https://toddm.net/"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.NORMAL);
        TestRequest.assertNotNull((Object)work1);
        testRequests.add(work1);
        Work work2 = commManager.enqueueWork(new URI("https://toddm.net/?paramA=Apple&paramB=Baby"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        TestRequest.assertNotNull((Object)work2);
        TestRequest.assertTrue((work1.getId() != work2.getId() ? 1 : 0) != 0);
        testRequests.add(work2);
        Work work3 = commManager.enqueueWork(new URI("https://toddm.net/?paramB=Baby&paramA=Apple"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        TestRequest.assertNotNull((Object)work3);
        TestRequest.assertTrue((work2.getId() == work3.getId() ? 1 : 0) != 0);
        testRequests.add(work3);
        Work work4 = commManager.enqueueWork(new URI("https://toddm.net/"), Request.RequestMethod.POST, new String("test POST data").getBytes("UTF-8"), null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        TestRequest.assertNotNull((Object)work4);
        TestRequest.assertTrue((work1.getId() != work4.getId() ? 1 : 0) != 0);
        testRequests.add(work4);
        Work work5 = commManager.enqueueWork(new URI("https://toddm.net/"), Request.RequestMethod.POST, new String("test POST data").getBytes("UTF-8"), null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        TestRequest.assertNotNull((Object)work5);
        TestRequest.assertTrue((work4.getId() == work5.getId() ? 1 : 0) != 0);
        testRequests.add(work5);
        Work work6 = commManager.enqueueWork(new URI("https://toddm.net/"), Request.RequestMethod.POST, new String("test POST data-").getBytes("UTF-8"), null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        TestRequest.assertNotNull((Object)work6);
        TestRequest.assertTrue((work5.getId() != work6.getId() ? 1 : 0) != 0);
        testRequests.add(work6);
        for (Work work : testRequests) {
            Response response = work.get();
            TestRequest.assertNotNull((Object)response);
            TestRequest.assertEquals((int)200, (int)response.getResponseCode());
            TestRequest.assertNotNull((Object)response.getResponseBytes());
            TestRequest.assertTrue((response.getResponseBytes().length > 0 ? 1 : 0) != 0);
        }
    }
}

