/*
 * Decompiled with CFR 0.152.
 */
package net.toddm.comm.tests;

import java.net.URI;
import java.nio.charset.Charset;
import junit.framework.TestCase;
import net.toddm.cache.CachePriority;
import net.toddm.cache.DefaultLogger;
import net.toddm.cache.LoggingProvider;
import net.toddm.comm.CacheBehavior;
import net.toddm.comm.CommManager;
import net.toddm.comm.Priority;
import net.toddm.comm.Request;
import net.toddm.comm.Response;
import net.toddm.comm.Work;
import org.junit.Test;

public class TestGZIP
extends TestCase {
    @Test
    public void testGZIPResponse() throws Exception {
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManager = commManagerBuilder.setName("TEST").setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI("http://httpbin.org/gzip"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        TestGZIP.assertNotNull((Object)work);
        Response response = work.get();
        TestGZIP.assertNotNull((Object)response);
        TestGZIP.assertEquals((int)200, (int)response.getResponseCode());
        String results = response.getResponseBody();
        System.out.println(results);
        TestGZIP.assertNotNull((Object)results);
        TestGZIP.assertTrue((results.length() > 0 ? 1 : 0) != 0);
        TestGZIP.assertTrue((boolean)Charset.forName("US-ASCII").newEncoder().canEncode(results));
    }
}

