/*
 * Decompiled with CFR 0.152.
 */
package net.toddm.comm.tests;

import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.TestCase;
import net.toddm.cache.CachePriority;
import net.toddm.cache.DefaultLogger;
import net.toddm.cache.LoggingProvider;
import net.toddm.comm.CacheBehavior;
import net.toddm.comm.CommManager;
import net.toddm.comm.DefaultRetryPolicyProvider;
import net.toddm.comm.DependentWorkListener;
import net.toddm.comm.Priority;
import net.toddm.comm.Request;
import net.toddm.comm.Response;
import net.toddm.comm.RetryProfile;
import net.toddm.comm.SubmittableWork;
import net.toddm.comm.Work;
import org.junit.Test;

public class TestDefaultRetryPolicyProvider
extends TestCase {
    @Test
    public void testShouldRetryOnError() throws Exception {
        DefaultRetryPolicyProvider retryPolicyProvider = new DefaultRetryPolicyProvider((LoggingProvider)new DefaultLogger());
        RetryProfile retryProfile = retryPolicyProvider.shouldRetry((Work)new WorkStub(), new SocketTimeoutException());
        TestDefaultRetryPolicyProvider.assertTrue((boolean)retryProfile.shouldRetry());
        TestDefaultRetryPolicyProvider.assertEquals((long)3000L, (long)retryProfile.getRetryAfterMilliseconds());
        retryProfile = retryPolicyProvider.shouldRetry((Work)new WorkStub(), new NullPointerException());
        TestDefaultRetryPolicyProvider.assertFalse((boolean)retryProfile.shouldRetry());
        retryProfile = retryPolicyProvider.shouldRetry((Work)new WorkStub(false), new SocketTimeoutException());
        TestDefaultRetryPolicyProvider.assertFalse((boolean)retryProfile.shouldRetry());
    }

    @Test
    public void testShouldRetryOnResponse() throws Exception {
        DefaultRetryPolicyProvider retryPolicyProvider = new DefaultRetryPolicyProvider((LoggingProvider)new DefaultLogger());
        RetryProfile retryProfile = retryPolicyProvider.shouldRetry((Work)new WorkStub(), new ResponseStub(302, null));
        TestDefaultRetryPolicyProvider.assertFalse((boolean)retryProfile.shouldRetry());
        retryProfile = retryPolicyProvider.shouldRetry((Work)new WorkStub(), new ResponseStub(503, 13L));
        TestDefaultRetryPolicyProvider.assertTrue((boolean)retryProfile.shouldRetry());
        TestDefaultRetryPolicyProvider.assertEquals((long)13000L, (long)retryProfile.getRetryAfterMilliseconds());
        retryProfile = retryPolicyProvider.shouldRetry((Work)new WorkStub(), new ResponseStub(202, 14L));
        TestDefaultRetryPolicyProvider.assertTrue((boolean)retryProfile.shouldRetry());
        TestDefaultRetryPolicyProvider.assertEquals((long)14000L, (long)retryProfile.getRetryAfterMilliseconds());
    }

    @Test
    public void test503Handling() throws Exception {
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManager = commManagerBuilder.setName("TEST").setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI("http://httpbin.org/status/503"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        TestDefaultRetryPolicyProvider.assertNotNull((Object)work);
        Response response = work.get();
        TestDefaultRetryPolicyProvider.assertNotNull((Object)response);
        TestDefaultRetryPolicyProvider.assertEquals((int)503, (int)response.getResponseCode());
        TestDefaultRetryPolicyProvider.assertEquals((int)5, (int)work.getRequest().getRetryCountFromResponse());
    }

    @Test
    public void test202Handling() throws Exception {
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManager = commManagerBuilder.setName("TEST").setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI("http://httpbin.org/status/202"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        TestDefaultRetryPolicyProvider.assertNotNull((Object)work);
        Response response = work.get();
        TestDefaultRetryPolicyProvider.assertNotNull((Object)response);
        TestDefaultRetryPolicyProvider.assertEquals((int)202, (int)response.getResponseCode());
        TestDefaultRetryPolicyProvider.assertEquals((int)5, (int)work.getRequest().getRetryCountFromResponse());
    }

    private class WorkStub
    implements Work {
        private final Request request;
        private final Response response;

        WorkStub() throws URISyntaxException {
            this(true);
        }

        WorkStub(boolean isIdempotent) throws URISyntaxException {
            this.response = new ResponseStub(302, null);
            this.request = new RequestStub(isIdempotent);
        }

        @Override
        public Work.Status getState() {
            return Work.Status.COMPLETED;
        }

        @Override
        public int getId() {
            return this.request.getId();
        }

        @Override
        public Response get() throws InterruptedException, ExecutionException {
            return this.response;
        }

        @Override
        public Response get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.response;
        }

        @Override
        public Request getRequest() {
            return this.request;
        }

        @Override
        public Priority getRequestPriority() {
            return new Priority(this, Priority.StartingPriority.MEDIUM);
        }

        @Override
        public CachePriority getCachingPriority() {
            return CachePriority.NORMAL;
        }

        @Override
        public CacheBehavior getCachingBehavior() {
            return CacheBehavior.NORMAL;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public void setDependentWork(SubmittableWork dependentWork, DependentWorkListener dependentWorkListener) {
        }

        @Override
        public Exception getException() {
            return null;
        }
    }

    private class RequestStub
    extends Request {
        public RequestStub() throws URISyntaxException {
            super(new URI("https://toddm.net/"), Request.RequestMethod.GET, null, null, true);
        }

        public RequestStub(boolean isIdempotent) throws URISyntaxException {
            super(new URI("https://toddm.net/"), Request.RequestMethod.GET, null, null, isIdempotent);
        }
    }

    private class ResponseStub
    extends Response {
        private static final long serialVersionUID = 7455101257115334805L;

        public ResponseStub(int responseCode, Long retryAfterSeconds) throws URISyntaxException {
            super(null, null, responseCode, 1, 1, (LoggingProvider)new DefaultLogger());
            if (retryAfterSeconds != null) {
                ArrayList<String> retryAfterHeaderValue = new ArrayList<String>();
                retryAfterHeaderValue.add(Long.toString(retryAfterSeconds));
                this.getHeaders().put("Retry-After", retryAfterHeaderValue);
            }
        }
    }
}

