/*
 * Decompiled with CFR 0.152.
 */
package net.toddm.comm.tests;

import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import junit.framework.TestCase;
import net.toddm.cache.CachePriority;
import net.toddm.cache.DefaultLogger;
import net.toddm.cache.LoggingProvider;
import net.toddm.comm.CacheBehavior;
import net.toddm.comm.CommManager;
import net.toddm.comm.DefaultPriorityManagmentProvider;
import net.toddm.comm.Priority;
import net.toddm.comm.Request;
import net.toddm.comm.Work;
import org.junit.Test;

public class TestDefaultPriorityManagmentProvider
extends TestCase {
    @Test
    public void testPromotePriority() throws Exception {
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManager = commManagerBuilder.setName("TEST").setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI("https://toddm.net/"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.LOW, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        Priority testPriority = work.getRequestPriority();
        DefaultPriorityManagmentProvider priorityManagmentProvider = new DefaultPriorityManagmentProvider((LoggingProvider)new DefaultLogger());
        TestDefaultPriorityManagmentProvider.assertEquals((int)Priority.StartingPriority.LOW.getPriorityValue(), (int)testPriority.getValue());
        priorityManagmentProvider.promotePriority(testPriority);
        TestDefaultPriorityManagmentProvider.assertEquals((int)Priority.StartingPriority.LOW.getPriorityValue(), (int)testPriority.getValue());
        Field field = DefaultPriorityManagmentProvider.class.getDeclaredField("_PromotionIntervalInMilliseconds");
        field.setAccessible(true);
        long promotionIntervalCache = (Long)field.get(null);
        field.set(null, 10);
        Thread.sleep(11L);
        priorityManagmentProvider.promotePriority(testPriority);
        TestDefaultPriorityManagmentProvider.assertTrue((Priority.StartingPriority.LOW.getPriorityValue() > testPriority.getValue() ? 1 : 0) != 0);
        while (testPriority.getValue() > 1) {
            int priorityCache = testPriority.getValue();
            Thread.sleep(11L);
            priorityManagmentProvider.promotePriority(testPriority);
            TestDefaultPriorityManagmentProvider.assertEquals((int)(priorityCache - 1), (int)testPriority.getValue());
        }
        TestDefaultPriorityManagmentProvider.assertEquals((int)1, (int)testPriority.getValue());
        Thread.sleep(11L);
        priorityManagmentProvider.promotePriority(testPriority);
        TestDefaultPriorityManagmentProvider.assertEquals((int)1, (int)testPriority.getValue());
        field.set(null, promotionIntervalCache);
    }

    @Test
    public void testPriorityComparator() throws Exception {
        CommManager.Builder commManagerBuilder = new CommManager.Builder();
        CommManager commManager = commManagerBuilder.setName("TEST").setLoggingProvider((LoggingProvider)new DefaultLogger()).create();
        Work work = commManager.enqueueWork(new URI("https://toddm.net/"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.LOW, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        Priority priorityLow = work.getRequestPriority();
        work = commManager.enqueueWork(new URI("http://httpbin.org/status/200"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.MEDIUM, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        Priority priorityMedium = work.getRequestPriority();
        work = commManager.enqueueWork(new URI("http://httpbin.org/status/201"), Request.RequestMethod.GET, null, null, true, Priority.StartingPriority.HIGH, CachePriority.NORMAL, CacheBehavior.DO_NOT_CACHE);
        Priority priorityHigh = work.getRequestPriority();
        ArrayList<Priority> priorityList = new ArrayList<Priority>();
        priorityList.add(priorityLow);
        priorityList.add(priorityHigh);
        priorityList.add(priorityMedium);
        TestDefaultPriorityManagmentProvider.assertEquals((int)Priority.StartingPriority.LOW.getPriorityValue(), (int)((Priority)priorityList.get(0)).getValue());
        TestDefaultPriorityManagmentProvider.assertEquals((int)Priority.StartingPriority.HIGH.getPriorityValue(), (int)((Priority)priorityList.get(1)).getValue());
        TestDefaultPriorityManagmentProvider.assertEquals((int)Priority.StartingPriority.MEDIUM.getPriorityValue(), (int)((Priority)priorityList.get(2)).getValue());
        DefaultPriorityManagmentProvider priorityManagmentProvider = new DefaultPriorityManagmentProvider((LoggingProvider)new DefaultLogger());
        Collections.sort(priorityList, priorityManagmentProvider.getPriorityComparator());
        TestDefaultPriorityManagmentProvider.assertEquals((int)Priority.StartingPriority.HIGH.getPriorityValue(), (int)((Priority)priorityList.get(0)).getValue());
        TestDefaultPriorityManagmentProvider.assertEquals((int)Priority.StartingPriority.MEDIUM.getPriorityValue(), (int)((Priority)priorityList.get(1)).getValue());
        TestDefaultPriorityManagmentProvider.assertEquals((int)Priority.StartingPriority.LOW.getPriorityValue(), (int)((Priority)priorityList.get(2)).getValue());
    }
}

