/*
 * Decompiled with CFR 0.152.
 */
package net.toddm.comm.tests;

import java.util.HashMap;
import java.util.UUID;
import junit.framework.TestCase;
import net.toddm.comm.ConfigurationException;
import net.toddm.comm.ConfigurationProvider;
import net.toddm.comm.MapConfigurationProvider;
import org.junit.Test;

public class TestConfigurationProvider
extends TestCase {
    @Test
    public void testMapConfigurationProvider() throws Exception {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("key_object", UUID.randomUUID());
        config.put("key_string", "string value");
        config.put("key_int", 13);
        config.put("key_long", 13L);
        config.put("key_boolean", true);
        MapConfigurationProvider configProvider = new MapConfigurationProvider(config);
        this.validateConfigurationProvider(configProvider);
    }

    @Test
    private void validateConfigurationProvider(ConfigurationProvider configProvider) {
        try {
            configProvider.get("missing_key");
            TestConfigurationProvider.fail((String)"Getting a non existent key did not throw a ConfigurationException");
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        try {
            configProvider.getInt("key_string");
            TestConfigurationProvider.fail((String)"Getting a String as an int did not throw a ConfigurationException");
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        try {
            configProvider.getString("key_int");
            TestConfigurationProvider.fail((String)"Getting an int as a String did not throw a ConfigurationException");
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        try {
            configProvider.getString("key_long");
            TestConfigurationProvider.fail((String)"Getting a long as a String did not throw a ConfigurationException");
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        try {
            configProvider.getString("key_boolean");
            TestConfigurationProvider.fail((String)"Getting a boolean as a String did not throw a ConfigurationException");
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        Object result = configProvider.get("key_object");
        TestConfigurationProvider.assertNotNull((Object)result);
        TestConfigurationProvider.assertTrue((boolean)(result instanceof UUID));
        result = configProvider.get("key_string");
        TestConfigurationProvider.assertNotNull((Object)result);
        TestConfigurationProvider.assertTrue((boolean)(result instanceof String));
        result = configProvider.get("key_int");
        TestConfigurationProvider.assertNotNull((Object)result);
        TestConfigurationProvider.assertTrue((boolean)(result instanceof Integer));
        result = configProvider.get("key_long");
        TestConfigurationProvider.assertNotNull((Object)result);
        TestConfigurationProvider.assertTrue((boolean)(result instanceof Long));
        result = configProvider.get("key_boolean");
        TestConfigurationProvider.assertNotNull((Object)result);
        TestConfigurationProvider.assertTrue((boolean)(result instanceof Boolean));
        String resultStr = configProvider.getString("key_string");
        TestConfigurationProvider.assertNotNull((Object)resultStr);
        TestConfigurationProvider.assertEquals((String)"string value", (String)resultStr);
        int resultInt = configProvider.getInt("key_int");
        TestConfigurationProvider.assertEquals((int)13, (int)resultInt);
        long resultLong = configProvider.getLong("key_long");
        TestConfigurationProvider.assertEquals((long)13L, (long)resultLong);
        boolean resultBool = configProvider.getBoolean("key_boolean");
        TestConfigurationProvider.assertTrue((boolean)resultBool);
    }
}

