/*
 * Decompiled with CFR 0.152.
 */
package net.toddm.comm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.toddm.cache.LoggingProvider;
import net.toddm.comm.Request;

public class Response
implements Serializable {
    private static final long serialVersionUID = -6722104702458701972L;
    private byte[] _responseBytes;
    private int _responseCode;
    private int _requestId;
    private int _responseTime = -1;
    private Map<String, List<String>> _headers;
    private boolean _isFromCache;
    private long _instanceCreationTime = System.currentTimeMillis();
    private final LoggingProvider _logger;

    protected Response(byte[] responseBytes, Map<String, List<String>> headers, int responseCode, int requestId, int responseTime, LoggingProvider loggingProvider) {
        this._responseBytes = responseBytes;
        this._headers = headers != null ? new HashMap<String, List<String>>(headers) : new HashMap<String, List<String>>();
        this._responseCode = responseCode;
        this._requestId = requestId;
        this._responseTime = responseTime;
        this._logger = loggingProvider;
        this._isFromCache = false;
    }

    public byte[] getResponseBytes() {
        return this._responseBytes;
    }

    public String getResponseBody() {
        String result;
        block2: {
            result = null;
            try {
                result = new String(this._responseBytes, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                if (this._logger == null) break block2;
                this._logger.debug("Response encoding as string failed", new Object[0]);
            }
        }
        return result;
    }

    public Integer getResponseCode() {
        return this._responseCode;
    }

    public int getResponseTimeMilliseconds() {
        return this._responseTime;
    }

    public boolean isFromCache() {
        return this._isFromCache;
    }

    public boolean isSuccessful() {
        return this._responseCode == 200 || this._responseCode == 201;
    }

    public Integer getRequestId() {
        return this._requestId;
    }

    public Map<String, List<String>> getHeaders() {
        return this._headers;
    }

    protected long getInstanceCreationTime() {
        return this._instanceCreationTime;
    }

    private static List<String> getHeaderValuesIgnoreCase(String headerKey, Map<String, List<String>> headers) {
        if (headers == null) {
            return null;
        }
        if (headerKey == null || headerKey.length() <= 0) {
            return null;
        }
        for (String key : headers.keySet()) {
            if (!headerKey.equalsIgnoreCase(key)) continue;
            List<String> values = headers.get(key);
            if (values == null || values.size() <= 0) {
                return null;
            }
            return values;
        }
        return null;
    }

    private static String getHeaderValueIgnoreCase(String headerKey, Map<String, List<String>> headers) {
        List<String> values = Response.getHeaderValuesIgnoreCase(headerKey, headers);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    public static String getContentEncoding(Map<String, List<String>> headers) {
        return Response.getHeaderValueIgnoreCase("Content-Encoding", headers);
    }

    public URI getLocationFromHeaders(Request request) {
        URI location;
        block5: {
            if (request == null) {
                throw new IllegalArgumentException("'request' can not be NULL");
            }
            location = null;
            try {
                String locationStr = Response.getHeaderValueIgnoreCase("Location", this._headers);
                if (locationStr != null) {
                    location = new URI(locationStr);
                    if (locationStr.trim().startsWith("/")) {
                        location = new URI(request.getUri().getScheme(), location.getUserInfo(), request.getUri().getHost(), location.getPort(), location.getPath(), request.getUri().getQuery(), location.getFragment());
                    }
                }
            }
            catch (Exception e) {
                if (this._logger == null) break block5;
                this._logger.error((Throwable)e, "Failed to parse value from 'Location' header", new Object[0]);
            }
        }
        return location;
    }

    public Long getRetryAfter() {
        Long retryInSeconds;
        block5: {
            retryInSeconds = null;
            String retryAfter = Response.getHeaderValueIgnoreCase("Retry-After", this._headers);
            if (retryAfter != null) {
                try {
                    retryInSeconds = Long.parseLong(retryAfter);
                }
                catch (Exception e) {
                    try {
                        SimpleDateFormat httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
                        Date httpDate = httpDateFormat.parse(retryAfter);
                        retryInSeconds = (httpDate.getTime() - System.currentTimeMillis()) / 1000L;
                    }
                    catch (Exception f) {
                        if (this._logger == null) break block5;
                        this._logger.error((Throwable)f, "Failed to parse value from 'Retry-After' header", new Object[0]);
                    }
                }
            }
        }
        return retryInSeconds;
    }

    public boolean shouldNotCacheDueToNoCacheDirective() {
        Map<String, String> cacheControlDirectives = this.parseCacheControlHeader();
        return cacheControlDirectives.containsKey("no-cache");
    }

    public Long getTtlFromHeaders() {
        Long ttl;
        block4: {
            ttl = null;
            Map<String, String> cacheControlDirectives = this.parseCacheControlHeader();
            if (!cacheControlDirectives.containsKey("no-cache") && cacheControlDirectives.containsKey("max-age")) {
                try {
                    String maxAgeStr = cacheControlDirectives.get("max-age");
                    long ttlInSeconds = Long.parseLong(maxAgeStr);
                    if (ttlInSeconds >= 0L) {
                        ttl = ttlInSeconds * 1000L;
                    }
                }
                catch (NumberFormatException e) {
                    if (this._logger == null) break block4;
                    this._logger.error((Throwable)e, "getTtlFromResponse() failed", new Object[0]);
                }
            }
        }
        return ttl;
    }

    public Long getMaxStaleFromHeaders() {
        Long maxStale;
        block4: {
            maxStale = null;
            Map<String, String> cacheControlDirectives = this.parseCacheControlHeader();
            if (!cacheControlDirectives.containsKey("no-cache") && cacheControlDirectives.containsKey("max-stale")) {
                try {
                    String maxStaleStr = cacheControlDirectives.get("max-stale");
                    long maxStaleInSeconds = Long.parseLong(maxStaleStr);
                    if (maxStaleInSeconds >= 0L) {
                        maxStale = maxStaleInSeconds * 1000L;
                    }
                }
                catch (NumberFormatException e) {
                    if (this._logger == null) break block4;
                    this._logger.error((Throwable)e, "getMaxStaleFromHeaders() failed", new Object[0]);
                }
            }
        }
        return maxStale;
    }

    public String getETagFromHeaders() {
        return Response.getHeaderValueIgnoreCase("ETag", this._headers);
    }

    private Map<String, String> parseCacheControlHeader() {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        List<String> cacheControlValues = Response.getHeaderValuesIgnoreCase("Cache-Control", this._headers);
        if (cacheControlValues != null) {
            for (String cacheControl : cacheControlValues) {
                if (cacheControl == null || cacheControl.length() <= 0) continue;
                for (String cacheDirective : cacheControl.split(",")) {
                    if (cacheDirective == null) continue;
                    if (!(cacheDirective = cacheDirective.trim().toLowerCase()).contains("=")) {
                        resultMap.put(cacheDirective, null);
                        continue;
                    }
                    String[] directivePair = cacheDirective.split("=");
                    if (directivePair.length <= 1 || directivePair[0] == null || directivePair[1] == null) continue;
                    resultMap.put(directivePair[0].trim(), directivePair[1].trim());
                }
            }
        }
        return resultMap;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this._responseCode);
        out.writeInt(this._requestId);
        out.writeInt(this._responseTime);
        out.writeObject(this._headers);
        if (this._responseBytes != null) {
            out.write(this._responseBytes);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this._responseCode = in.readInt();
        this._requestId = in.readInt();
        this._responseTime = in.readInt();
        this._headers = (Map)in.readObject();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        while ((bytesRead = in.read(buffer)) != -1) {
            outStream.write(buffer, 0, bytesRead);
        }
        this._responseBytes = null;
        if (outStream.size() > 0) {
            this._responseBytes = outStream.toByteArray();
        }
        this._instanceCreationTime = System.currentTimeMillis();
        this._isFromCache = true;
    }
}

