/*
 * Decompiled with CFR 0.152.
 */
package net.toddm.comm;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.toddm.comm.Base64;

public class Request {
    private final LinkedList<URI> _normalizedEndPoints = new LinkedList();
    private final RequestMethod _method;
    private final byte[] _postData;
    private final Map<String, String> _headers;
    private final Map<String, List<String>> _queryParameters;
    private final Integer _id;
    private final boolean _isIdempotent;
    private int _redirectCount = 0;
    private int _retryCountFromFailure = 0;
    private int _retryCountFromResponse = 0;

    protected Request(URI uri, RequestMethod method, byte[] postData, Map<String, String> headers, boolean isIdempotent) {
        if (uri == null) {
            throw new IllegalArgumentException("'uri' can not be NULL");
        }
        if (method == null) {
            throw new IllegalArgumentException("'method' can not be NULL");
        }
        if (postData != null && postData.length > 0 && !RequestMethod.POST.equals((Object)method) && !RequestMethod.PUT.equals((Object)method)) {
            throw new IllegalArgumentException("'method' must be 'POST' or 'PUT' when 'postData' is provided");
        }
        URI normalizedUri = uri.normalize();
        this._method = method;
        this._normalizedEndPoints.addFirst(normalizedUri);
        this._queryParameters = Request.parseQueryParameters(normalizedUri, "UTF-8");
        this._postData = postData;
        this._headers = headers;
        this._isIdempotent = isIdempotent;
        this._id = this.calculateId();
    }

    public RequestMethod getMethod() {
        return this._method;
    }

    public byte[] getPostData() {
        return this._postData;
    }

    public Map<String, String> getHeaders() {
        return this._headers;
    }

    public boolean isIdempotent() {
        return this._isIdempotent;
    }

    public URI getUri() {
        return this._normalizedEndPoints.getFirst();
    }

    protected boolean redirect(URI newLocation) {
        if (newLocation == null) {
            throw new IllegalArgumentException("'newLocation' can not be NULL");
        }
        ++this._redirectCount;
        URI normalizedUri = newLocation.normalize();
        if (!this._normalizedEndPoints.contains(normalizedUri)) {
            this._normalizedEndPoints.addFirst(normalizedUri);
            return true;
        }
        return false;
    }

    public int getRedirectCount() {
        return this._redirectCount;
    }

    public int getId() {
        if (this._id == null) {
            throw new IllegalStateException("The ID has not been calculated yet");
        }
        return this._id;
    }

    protected void incrementRetryCountFromFailure() {
        ++this._retryCountFromFailure;
    }

    protected void incrementRetryCountFromResponse() {
        ++this._retryCountFromResponse;
    }

    public int getRetryCountFromFailure() {
        return this._retryCountFromFailure;
    }

    public int getRetryCountFromResponse() {
        return this._retryCountFromResponse;
    }

    public int hashCode() {
        return this.getId();
    }

    public boolean equals(Object request) {
        if (request == null) {
            throw new IllegalArgumentException("'request' can not be NULL");
        }
        if (!(request instanceof Request)) {
            return false;
        }
        return this.hashCode() == request.hashCode();
    }

    private int calculateId() {
        String idSourceText;
        URI originalUri = this._normalizedEndPoints.getLast();
        StringBuilder idSourceBuffer = new StringBuilder();
        idSourceBuffer.append(originalUri.getScheme());
        idSourceBuffer.append(originalUri.getHost());
        idSourceBuffer.append(originalUri.getPath());
        for (String key : this._queryParameters.keySet()) {
            idSourceBuffer.append(key);
            for (String value : this._queryParameters.get(key)) {
                idSourceBuffer.append(value);
            }
        }
        idSourceBuffer.append(originalUri.getFragment());
        if (this._postData != null && this._postData.length > 0) {
            idSourceBuffer.append(Base64.encode(this._postData));
        }
        if ((idSourceText = idSourceBuffer.toString()) == null || idSourceText.length() <= 0) {
            return originalUri.getPort();
        }
        return idSourceText.hashCode() + originalUri.getPort();
    }

    private static TreeMap<String, List<String>> parseQueryParameters(URI uri, String encoding) {
        if (uri == null) {
            throw new IllegalArgumentException("'uri' can not be NULL");
        }
        if (encoding == null || encoding.length() <= 0) {
            throw new IllegalArgumentException("'encoding' can not be NULL or empty");
        }
        try {
            TreeMap<String, List<String>> queryPairs = new TreeMap<String, List<String>>();
            String rawQuery = uri.getRawQuery();
            if (rawQuery != null && rawQuery.length() > 0) {
                String[] pairs;
                for (String pair : pairs = rawQuery.split("&")) {
                    String key;
                    int equalsIndex = pair.indexOf("=");
                    String string = key = equalsIndex > 0 ? URLDecoder.decode(pair.substring(0, equalsIndex), encoding) : pair;
                    if (!queryPairs.containsKey(key)) {
                        queryPairs.put(key, new LinkedList());
                    }
                    String value = equalsIndex > 0 && pair.length() > equalsIndex + 1 ? URLDecoder.decode(pair.substring(equalsIndex + 1), encoding) : null;
                    queryPairs.get(key).add(value);
                }
            }
            return queryPairs;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum RequestMethod {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

