/*
 * Decompiled with CFR 0.152.
 */
package net.toddm.comm;

import net.toddm.comm.Work;

public class Priority {
    private final Work _work;
    private final StartingPriority _startingPriority;
    private final long _createdTimestamp;
    protected int _priority;
    protected long _lastPromotionTimestamp;

    public Priority(Work work, StartingPriority startingPriority) {
        if (work == null) {
            throw new IllegalArgumentException("'work' can not be NULL");
        }
        if (startingPriority == null) {
            throw new IllegalArgumentException("'startingPriority' can not be NULL");
        }
        this._work = work;
        this._startingPriority = startingPriority;
        this._priority = startingPriority.getPriorityValue();
        this._lastPromotionTimestamp = this._createdTimestamp = System.currentTimeMillis();
    }

    public Work getWork() {
        return this._work;
    }

    public StartingPriority getStartingValue() {
        return this._startingPriority;
    }

    public int getValue() {
        return this._priority;
    }

    protected long getCreatedTimestamp() {
        return this._createdTimestamp;
    }

    protected long getLastPromotionTimestamp() {
        return this._lastPromotionTimestamp;
    }

    public static enum StartingPriority {
        LOW(10),
        MEDIUM(7),
        HIGH(3);

        private final int _priority;

        private StartingPriority(int priorityValue) {
            this._priority = priorityValue;
        }

        public int getPriorityValue() {
            return this._priority;
        }
    }
}

