/*
 * Decompiled with CFR 0.152.
 */
package net.toddm.comm;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.toddm.comm.ConfigurationException;
import net.toddm.comm.ConfigurationProvider;

public class MapConfigurationProvider
implements ConfigurationProvider {
    private final Map<String, Object> _configMap;

    public MapConfigurationProvider(Map<String, Object> config) {
        if (config == null) {
            throw new IllegalArgumentException("'config' can not be NULL");
        }
        this._configMap = Collections.unmodifiableMap(new HashMap<String, Object>(config));
    }

    @Override
    public boolean contains(String name) {
        if (name == null) {
            throw new IllegalArgumentException("'name' can not be NULL");
        }
        return this._configMap.containsKey(name);
    }

    @Override
    public Object get(String name) throws ConfigurationException {
        if (!this.contains(name)) {
            throw new ConfigurationException(String.format(Locale.US, "Config does not contain a value for '%1$s'", name));
        }
        return this._configMap.get(name);
    }

    @Override
    public String getString(String name) throws ConfigurationException {
        Object rawValue = this.get(name);
        if (!(rawValue instanceof String)) {
            throw new ConfigurationException(String.format(Locale.US, "Value for '%1$s' can not be cast as a String", name));
        }
        return (String)rawValue;
    }

    @Override
    public int getInt(String name) throws ConfigurationException {
        Object rawValue = this.get(name);
        if (!(rawValue instanceof Integer)) {
            throw new ConfigurationException(String.format(Locale.US, "Value for '%1$s' can not be cast as an Integer", name));
        }
        return (Integer)rawValue;
    }

    @Override
    public long getLong(String name) throws ConfigurationException {
        Object rawValue = this.get(name);
        if (!(rawValue instanceof Long)) {
            throw new ConfigurationException(String.format(Locale.US, "Value for '%1$s' can not be cast as an Long", name));
        }
        return (Long)rawValue;
    }

    @Override
    public boolean getBoolean(String name) throws ConfigurationException {
        Object rawValue = this.get(name);
        if (!(rawValue instanceof Boolean)) {
            throw new ConfigurationException(String.format(Locale.US, "Value for '%1$s' can not be cast as an Boolean", name));
        }
        return (Boolean)rawValue;
    }
}

