/*
 * Decompiled with CFR 0.152.
 */
package net.toddm.comm;

import java.net.BindException;
import java.net.ConnectException;
import java.net.HttpRetryException;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.net.UnknownServiceException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import net.toddm.cache.LoggingProvider;
import net.toddm.comm.Response;
import net.toddm.comm.RetryPolicyProvider;
import net.toddm.comm.RetryProfile;
import net.toddm.comm.Work;

public class DefaultRetryPolicyProvider
implements RetryPolicyProvider {
    private static final int _MaxErrorRetries = 5;
    private static final int _MaxResponseRetries = 5;
    private final LoggingProvider _logger;

    public DefaultRetryPolicyProvider(LoggingProvider loggingProvider) {
        this._logger = loggingProvider;
    }

    @Override
    public RetryProfile shouldRetry(Work work, Exception error) {
        if (work == null) {
            throw new IllegalArgumentException("'work' can not be NULL");
        }
        if (error == null) {
            throw new IllegalArgumentException("'error' can not be NULL");
        }
        boolean shouldRetry = false;
        if (work.getRequest().isIdempotent() && work.getRequest().getRetryCountFromFailure() < 5 && (error instanceof ConnectException || error instanceof SocketException || error instanceof SocketTimeoutException || error instanceof UnknownHostException || error instanceof BindException || error instanceof NoRouteToHostException || error instanceof PortUnreachableException || error instanceof UnknownServiceException || error instanceof HttpRetryException || error instanceof ProtocolException || error instanceof SSLProtocolException || error instanceof SSLKeyException || error instanceof SSLPeerUnverifiedException || error.getClass().equals(SSLException.class) || error instanceof SSLHandshakeException && (error.getCause() == null || !(error.getCause() instanceof CertificateException)))) {
            shouldRetry = true;
            if (this._logger != null) {
                this._logger.debug("Recommending request %1$d be retried in 3 seconds due to %2$s", new Object[]{work.getId(), error.getClass().getSimpleName()});
            }
        }
        return new RetryProfile(shouldRetry, 3000L);
    }

    @Override
    public RetryProfile shouldRetry(Work work, Response response) {
        if (work == null) {
            throw new IllegalArgumentException("'request' can not be NULL");
        }
        if (response == null) {
            throw new IllegalArgumentException("'response' can not be NULL");
        }
        boolean shouldRetry = false;
        long retryInSeconds = 5L;
        if (work.getRequest().getRetryCountFromResponse() < 5 && (response.getResponseCode() == 503 || response.getResponseCode() == 202)) {
            block7: {
                shouldRetry = true;
                if (response.getHeaders().containsKey("Retry-After")) {
                    try {
                        String retryAfter = response.getHeaders().get("Retry-After").get(0);
                        retryInSeconds = Long.parseLong(retryAfter);
                    }
                    catch (Exception e) {
                        if (this._logger == null) break block7;
                        this._logger.error((Throwable)e, "Failed to parse value from 'Retry-After' header", new Object[0]);
                    }
                }
            }
            if (this._logger != null) {
                this._logger.debug("Recommending request %1$d be retried in %2$d seconds due to %3$d", new Object[]{work.getId(), retryInSeconds, response.getResponseCode()});
            }
        }
        return new RetryProfile(shouldRetry, retryInSeconds * 1000L);
    }
}

