/*
 * Decompiled with CFR 0.152.
 */
package net.toddm.comm;

import java.util.Comparator;
import net.toddm.cache.LoggingProvider;
import net.toddm.comm.Priority;
import net.toddm.comm.PriorityManagementProvider;

public class DefaultPriorityManagmentProvider
implements PriorityManagementProvider {
    private static long _PromotionIntervalInMilliseconds = 60000L;
    private final LoggingProvider _logger;
    private static Comparator<Priority> _PriorityComparator = new Comparator<Priority>(){

        @Override
        public int compare(Priority lhs, Priority rhs) {
            if (lhs == null) {
                throw new IllegalArgumentException("'lhs' can not be NULL");
            }
            if (rhs == null) {
                throw new IllegalArgumentException("'rhs' can not be NULL");
            }
            int order = 0;
            if (lhs._priority < rhs._priority) {
                order = -1;
            } else if (lhs._priority > rhs._priority) {
                order = 1;
            }
            if (order == 0) {
                if (lhs.getCreatedTimestamp() > rhs.getCreatedTimestamp()) {
                    order = -1;
                } else if (lhs.getCreatedTimestamp() < rhs.getCreatedTimestamp()) {
                    order = 1;
                }
            }
            return order;
        }
    };

    public DefaultPriorityManagmentProvider(LoggingProvider loggingProvider) {
        this._logger = loggingProvider;
    }

    @Override
    public void promotePriority(Priority priority) {
        boolean promote;
        if (priority.getValue() <= 1) {
            return;
        }
        boolean bl = promote = System.currentTimeMillis() - priority.getLastPromotionTimestamp() >= _PromotionIntervalInMilliseconds;
        if (promote) {
            if (this._logger != null) {
                this._logger.debug("promotePriority() PRE [request:%1$d priority:%2$d]", new Object[]{priority.getWork().getId(), priority.getValue()});
            }
            priority._lastPromotionTimestamp = System.currentTimeMillis();
            --priority._priority;
            if (this._logger != null) {
                this._logger.debug("promotePriority() POST [request:%1$d priority:%2$d]", new Object[]{priority.getWork().getId(), priority.getValue()});
            }
        }
    }

    @Override
    public Comparator<Priority> getPriorityComparator() {
        return _PriorityComparator;
    }
}

