/*
 * Decompiled with CFR 0.152.
 */
package net.toddm.comm;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.toddm.cache.CacheEntry;
import net.toddm.cache.CachePriority;
import net.toddm.cache.LoggingProvider;
import net.toddm.comm.CacheBehavior;
import net.toddm.comm.DependentWorkListener;
import net.toddm.comm.Priority;
import net.toddm.comm.Request;
import net.toddm.comm.Response;
import net.toddm.comm.SubmittableWork;
import net.toddm.comm.Work;

class CommWork
implements Work {
    private final Request _request;
    private final Priority _requestPriority;
    private final CachePriority _cachingPriority;
    private final CacheBehavior _cachingBehavior;
    private final ConcurrentLinkedQueue<FutureTask<Response>> _futureTasks = new ConcurrentLinkedQueue();
    private final LoggingProvider _logger;
    private Work.Status _state = Work.Status.CREATED;
    private Response _response = null;
    private CacheEntry _cachedResponse = null;
    private long _retryAfterTimestamp = 0L;
    private Exception _exception = null;
    private CommWork _dependentWork = null;
    private DependentWorkListener _dependentWorkListener = null;
    private static final Comparator<Response> _ResponseComparator = new Comparator<Response>(){

        @Override
        public int compare(Response lhs, Response rhs) {
            if (lhs == null) {
                throw new IllegalArgumentException("'lhs' can not be NULL");
            }
            if (rhs == null) {
                throw new IllegalArgumentException("'rhs' can not be NULL");
            }
            return (int)(lhs.getInstanceCreationTime() - rhs.getInstanceCreationTime());
        }
    };

    protected CommWork(URI uri, Request.RequestMethod method, byte[] postData, Map<String, String> headers, boolean isIdempotent, Priority.StartingPriority requestPriority, CachePriority cachingPriority, CacheBehavior cachingBehavior, LoggingProvider loggingProvider) {
        if (uri == null) {
            throw new IllegalArgumentException("'uri' can not be NULL");
        }
        if (method == null) {
            throw new IllegalArgumentException("'method' can not be NULL");
        }
        if (requestPriority == null) {
            throw new IllegalArgumentException("'requestPriority' can not be NULL");
        }
        if (cachingPriority == null) {
            throw new IllegalArgumentException("'cachingPriority' can not be NULL");
        }
        if (cachingBehavior == null) {
            throw new IllegalArgumentException("'cachingBehavior' can not be NULL");
        }
        if (postData != null && postData.length > 0 && !Request.RequestMethod.POST.equals((Object)method) && !Request.RequestMethod.PUT.equals((Object)method)) {
            throw new IllegalArgumentException("'method' must be 'POST' or 'PUT' when 'postData' is provided");
        }
        this._state = Work.Status.CREATED;
        this._request = new Request(uri, method, postData, headers, isIdempotent);
        this._requestPriority = new Priority(this, requestPriority);
        this._cachingPriority = cachingPriority;
        this._cachingBehavior = cachingBehavior;
        this._logger = loggingProvider;
    }

    @Override
    public Request getRequest() {
        return this._request;
    }

    @Override
    public Priority getRequestPriority() {
        return this._requestPriority;
    }

    @Override
    public CachePriority getCachingPriority() {
        return this._cachingPriority;
    }

    @Override
    public CacheBehavior getCachingBehavior() {
        return this._cachingBehavior;
    }

    protected boolean shouldCache() {
        if (CacheBehavior.DO_NOT_CACHE.equals((Object)this._cachingBehavior)) {
            return false;
        }
        if (this._response != null) {
            if (this._response.getResponseCode() == 304) {
                return true;
            }
            if (this._response.shouldNotCacheDueToNoCacheDirective()) {
                return false;
            }
            if (CacheBehavior.SERVER_DIRECTED_CACHE.equals((Object)this._cachingBehavior) && this._response.getTtlFromHeaders() == null) {
                return false;
            }
        } else if (CacheBehavior.SERVER_DIRECTED_CACHE.equals((Object)this._cachingBehavior)) {
            return false;
        }
        return true;
    }

    @Override
    public Work.Status getState() {
        return this._state;
    }

    protected void setState(Work.Status state) {
        if (state == null) {
            throw new IllegalArgumentException("'state' can not be NULL");
        }
        this._state = state;
    }

    protected Response getResponse() {
        return this._response;
    }

    protected void setResponse(Response response) {
        this._response = response;
    }

    protected CacheEntry getCachedResponse() {
        return this._cachedResponse;
    }

    protected void setCachedResponse(CacheEntry cachedResponse) {
        this._cachedResponse = cachedResponse;
    }

    protected FutureTask<Response> getFutureTask() {
        FutureTask<Response> lastFuture = null;
        Iterator<FutureTask<Response>> iterator = this._futureTasks.iterator();
        while (iterator.hasNext()) {
            FutureTask<Response> future;
            lastFuture = future = iterator.next();
        }
        return lastFuture;
    }

    protected void addFutureTask(FutureTask<Response> futureTask) {
        if (futureTask == null) {
            throw new IllegalArgumentException("'futureTask' can not be NULL");
        }
        this._futureTasks.add(futureTask);
    }

    protected long getRetryAfterTimestamp() {
        return this._retryAfterTimestamp;
    }

    protected void updateRetryAfterTimestamp(long deltaInMilliseconds) {
        this._retryAfterTimestamp = System.currentTimeMillis() + deltaInMilliseconds;
    }

    protected void setException(Exception exception) {
        this._exception = exception;
    }

    @Override
    public Exception getException() {
        return this._exception;
    }

    @Override
    public int getId() {
        return this._request.getId();
    }

    public int hashCode() {
        return this._request.hashCode();
    }

    public boolean equals(Object work) {
        if (work == null) {
            throw new IllegalArgumentException("'work' can not be NULL");
        }
        if (!(work instanceof CommWork)) {
            return false;
        }
        return this._request.equals(((CommWork)work)._request);
    }

    void cancel(boolean interruptAllowed) {
        if (!this.isDone()) {
            this.setState(Work.Status.CANCELLED);
            for (FutureTask<Response> future : this._futureTasks) {
                future.cancel(interruptAllowed);
            }
            if (this._logger != null) {
                this._logger.debug("[thread:%1$d][request:%2$d] Work has been cancel", new Object[]{Thread.currentThread().getId(), this.getId()});
            }
        }
    }

    @Override
    public Response get() throws InterruptedException, ExecutionException {
        try {
            return this.getInternal(null, null);
        }
        catch (TimeoutException timeoutException) {
            return null;
        }
    }

    @Override
    public Response get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.getInternal(timeout, unit);
    }

    private Response getInternal(Long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (Work.Status.CREATED.equals((Object)this._state)) {
            throw new IllegalStateException("You can not wait on work that has not been submitted for processing");
        }
        int responseCount = 0;
        ArrayList<Response> responses = new ArrayList<Response>();
        while (responseCount < this._futureTasks.size()) {
            responseCount = 0;
            for (FutureTask<Response> future : this._futureTasks) {
                Response response = null;
                response = timeout != null && unit != null ? future.get(timeout, unit) : future.get();
                ++responseCount;
                if (response == null || responses.contains(response)) continue;
                responses.add(response);
            }
        }
        Collections.sort(responses, _ResponseComparator);
        if (this._logger != null) {
            this._logger.debug("Done waiting on Work [responseCount:%1$d futureTaskCount:%2$d]", new Object[]{responseCount, this._futureTasks.size()});
        }
        if (responses.size() <= 0) {
            return null;
        }
        return (Response)responses.get(responses.size() - 1);
    }

    public boolean isPending() {
        return this._state == Work.Status.WAITING || this._state == Work.Status.RETRYING || this._state == Work.Status.REDIRECTING;
    }

    @Override
    public boolean isDone() {
        return this._state == Work.Status.CANCELLED || this._state == Work.Status.COMPLETED;
    }

    @Override
    public boolean isCancelled() {
        return this._state == Work.Status.CANCELLED;
    }

    @Override
    public void setDependentWork(SubmittableWork dependentWork, DependentWorkListener dependentWorkListener) {
        HashSet<Integer> dependentWorkIds = new HashSet<Integer>();
        dependentWorkIds.add(this.getId());
        for (CommWork currWork = (CommWork)dependentWork; currWork != null; currWork = currWork.getDependentWork()) {
            if (dependentWorkIds.add(currWork.getId())) continue;
            throw new IllegalArgumentException("Cyclic dependence detected");
        }
        this._dependentWork = (CommWork)dependentWork;
        this._dependentWorkListener = dependentWorkListener;
    }

    protected CommWork getDependentWork() {
        return this._dependentWork;
    }

    protected DependentWorkListener getDependentWorkListener() {
        return this._dependentWorkListener;
    }
}

