/*
 * Decompiled with CFR 0.152.
 */
package net.toddm.comm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.toddm.cache.CacheEntry;
import net.toddm.cache.CachePriority;
import net.toddm.cache.CacheProvider;
import net.toddm.cache.LoggingProvider;
import net.toddm.comm.CacheBehavior;
import net.toddm.comm.CachedResponseFuture;
import net.toddm.comm.CachedWork;
import net.toddm.comm.CommException;
import net.toddm.comm.CommWork;
import net.toddm.comm.ConfigurationProvider;
import net.toddm.comm.DefaultConfigurationProvider;
import net.toddm.comm.DefaultPriorityManagmentProvider;
import net.toddm.comm.DefaultRetryPolicyProvider;
import net.toddm.comm.NoResponseFuture;
import net.toddm.comm.Priority;
import net.toddm.comm.PriorityManagementProvider;
import net.toddm.comm.Request;
import net.toddm.comm.Response;
import net.toddm.comm.RetryPolicyProvider;
import net.toddm.comm.RetryProfile;
import net.toddm.comm.SubmittableWork;
import net.toddm.comm.Work;

public final class CommManager {
    private static final int _DependentWorkRetryIntervalMilliseconds = 333;
    private final int _redirectLimit;
    private final int _maxSimultaneousRequests;
    private final int _connectTimeoutMilliseconds;
    private final int _readTimeoutMilliseconds;
    private final boolean _disableSSLCertChecking;
    private final boolean _useBuiltInHttpURLConnectionRedirectionSupport;
    private final ExecutorService _requestWorkExecutorService;
    private final LinkedList<CommWork> _queuedWork = new LinkedList();
    private final ArrayList<CommWork> _activeWork = new ArrayList();
    private final ArrayList<CommWork> _retryWork = new ArrayList();
    private Thread _workThread = null;
    private Object _workThreadLock = new Object();
    private volatile boolean _workThreadStopping = false;
    private Object _workManagmentLock = new Object();
    private final CacheProvider _cacheProvider;
    private final PriorityManagementProvider _priorityManagmentProvider;
    private final RetryPolicyProvider _retryPolicyProvider;
    private final ConfigurationProvider _configurationProvider;
    private final LoggingProvider _logger;
    private static final TrustManager[] _TrustAllCertsManagers = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};
    private static final HostnameVerifier _AllowAllHostnamesVerifier = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };
    private Comparator<CommWork> _workComparator = new Comparator<CommWork>(){

        @Override
        public int compare(CommWork lhs, CommWork rhs) {
            if (lhs == null) {
                throw new IllegalArgumentException("'lhs' can not be NULL");
            }
            if (rhs == null) {
                throw new IllegalArgumentException("'rhs' can not be NULL");
            }
            return CommManager.this._priorityManagmentProvider.getPriorityComparator().compare(lhs.getRequestPriority(), rhs.getRequestPriority());
        }
    };

    private CommManager(String name, CacheProvider cacheProvider, PriorityManagementProvider priorityManagmentProvider, RetryPolicyProvider retryPolicyProvider, ConfigurationProvider configurationProvider, LoggingProvider loggingProvider) {
        this._cacheProvider = cacheProvider;
        this._priorityManagmentProvider = priorityManagmentProvider;
        this._retryPolicyProvider = retryPolicyProvider;
        this._configurationProvider = configurationProvider;
        this._logger = loggingProvider;
        this._redirectLimit = this._configurationProvider.contains("redirect_limit") ? this._configurationProvider.getInt("redirect_limit") : 3;
        this._maxSimultaneousRequests = this._configurationProvider.contains("max_simultaneous_requests") ? this._configurationProvider.getInt("max_simultaneous_requests") : 2;
        this._connectTimeoutMilliseconds = this._configurationProvider.contains("connect_timeout_milliseconds") ? this._configurationProvider.getInt("connect_timeout_milliseconds") : 30000;
        this._readTimeoutMilliseconds = this._configurationProvider.contains("read_timeout_milliseconds") ? this._configurationProvider.getInt("read_timeout_milliseconds") : 30000;
        this._disableSSLCertChecking = this._configurationProvider.contains("disable_ssl_cert_checking") ? this._configurationProvider.getBoolean("disable_ssl_cert_checking") : false;
        this._useBuiltInHttpURLConnectionRedirectionSupport = this._configurationProvider.contains("use_built_in_http_url_connection_redirection_support") ? this._configurationProvider.getBoolean("use_built_in_http_url_connection_redirection_support") : false;
        this._requestWorkExecutorService = Executors.newFixedThreadPool(this._maxSimultaneousRequests);
        this.startWorking(name);
    }

    public SubmittableWork getWork(URI uri, Request.RequestMethod method, byte[] postData, Map<String, String> headers, boolean isIdempotent, Priority.StartingPriority requestPriority, CachePriority cachingPriority, CacheBehavior cachingBehavior) {
        return new CommWork(uri, method, postData, headers, isIdempotent, requestPriority, cachingPriority, cachingBehavior, this._logger);
    }

    public Work enqueueWork(URI uri, Request.RequestMethod method, byte[] postData, Map<String, String> headers, boolean isIdempotent, Priority.StartingPriority requestPriority, CachePriority cachingPriority, CacheBehavior cachingBehavior) {
        return this.enqueueWork(this.getWork(uri, method, postData, headers, isIdempotent, requestPriority, cachingPriority, cachingBehavior));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Work enqueueWork(SubmittableWork work) {
        if (work == null) {
            throw new IllegalArgumentException("'work' can not be NULL");
        }
        if (!(work instanceof CommWork)) {
            throw new IllegalArgumentException("Unsupported 'work' implmenetation: " + work.getClass().getSimpleName());
        }
        if (this._logger != null) {
            this._logger.debug("[thread:%1$d] enqueueWork() start", new Object[]{Thread.currentThread().getId()});
        }
        CommWork newWork = (CommWork)work;
        CacheEntry cacheEntry = null;
        Response cachedResponse = null;
        if (!CacheBehavior.DO_NOT_CACHE.equals((Object)newWork.getCachingBehavior()) && this._cacheProvider != null && (cacheEntry = this._cacheProvider.get(Integer.toString(newWork.getRequest().getId()), true)) != null) {
            newWork.setCachedResponse(cacheEntry);
            if (!cacheEntry.hasExpired() || !cacheEntry.hasExceededStaleUse()) {
                cachedResponse = this.getResponseFromCacheEntry(cacheEntry);
            }
        }
        Work resultWork = null;
        Object object = this._workManagmentLock;
        synchronized (object) {
            CommWork existingWork = this.getExistingWork(newWork);
            if (cachedResponse != null) {
                resultWork = new CachedWork(newWork.getRequest(), cachedResponse, newWork.getRequestPriority(), newWork.getCachingPriority(), newWork.getCachingBehavior());
                if (this._logger != null) {
                    this._logger.info("[thread:%1$d] enqueueWork() Returning cached results [id:%2$d][hasExpired:%3$s]", new Object[]{Thread.currentThread().getId(), newWork.getId(), cacheEntry.hasExpired()});
                }
                if (cacheEntry.hasExpired()) {
                    if (existingWork == null) {
                        this.addNewWork(newWork);
                    }
                } else {
                    newWork.setResponse(cachedResponse);
                    newWork.setState(Work.Status.COMPLETED);
                    newWork.addFutureTask(new CachedResponseFuture(cachedResponse));
                }
            } else if (existingWork != null) {
                if (this._logger != null) {
                    this._logger.info("[thread:%1$d] enqueueWork() Returning already enqueued work [id:%2$d]", new Object[]{Thread.currentThread().getId(), existingWork.getId()});
                }
                resultWork = existingWork;
            } else if (CacheBehavior.GET_ONLY_FROM_CACHE.equals((Object)newWork.getCachingBehavior())) {
                newWork.setResponse(null);
                newWork.setState(Work.Status.COMPLETED);
                newWork.addFutureTask(new NoResponseFuture());
                if (this._logger != null) {
                    this._logger.info("[thread:%1$d] enqueueWork() Returning null results [id:%2$d]", new Object[]{Thread.currentThread().getId(), newWork.getId()});
                }
                resultWork = newWork;
            } else {
                resultWork = newWork;
                this.addNewWork(newWork);
            }
        }
        return resultWork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(int workId, boolean interruptAllowed) {
        CommWork workToCancel = null;
        Object object = this._workManagmentLock;
        synchronized (object) {
            workToCancel = this.getWorkFromList(workId, this._queuedWork);
            if (workToCancel == null) {
                workToCancel = this.getWorkFromList(workId, this._retryWork);
            }
            if (workToCancel == null) {
                workToCancel = this.getWorkFromList(workId, this._activeWork);
            }
            if (workToCancel != null && !workToCancel.isDone()) {
                this.removeWork(workToCancel);
                workToCancel.cancel(interruptAllowed);
                if (this._logger != null) {
                    this._logger.debug("[thread:%1$d] Kicking work thread", new Object[]{Thread.currentThread().getId()});
                }
                this._workManagmentLock.notify();
            }
        }
    }

    public void invalidateCache(int workId) {
        CacheEntry cacheEntry = this._cacheProvider.get(Integer.toString(workId), false);
        if (cacheEntry != null) {
            if (cacheEntry.getStringValue() != null) {
                this._cacheProvider.add(cacheEntry.getKey(), cacheEntry.getStringValue(), 0L, cacheEntry.getMaxStale().longValue(), cacheEntry.getEtag(), cacheEntry.getUri(), cacheEntry.getPriority());
            } else {
                this._cacheProvider.add(cacheEntry.getKey(), cacheEntry.getBytesValue(), 0L, cacheEntry.getMaxStale().longValue(), cacheEntry.getEtag(), cacheEntry.getUri(), cacheEntry.getPriority());
            }
        }
    }

    public void purgeCache(int workId) {
        this._cacheProvider.remove(Integer.toString(workId));
    }

    public void purgeCache() {
        this._cacheProvider.removeAll();
    }

    private CommWork getWorkFromList(int workId, List<CommWork> list) {
        for (CommWork work : list) {
            if (work.getId() != workId) continue;
            return work;
        }
        return null;
    }

    private CommWork getExistingWork(CommWork newWork) {
        int index = this._queuedWork.indexOf(newWork);
        if (index >= 0) {
            return this._queuedWork.get(index);
        }
        index = this._activeWork.indexOf(newWork);
        if (index >= 0) {
            return this._activeWork.get(index);
        }
        index = this._retryWork.indexOf(newWork);
        if (index >= 0) {
            return this._retryWork.get(index);
        }
        return null;
    }

    private void addNewWork(CommWork newWork) {
        newWork.addFutureTask(new FutureTask<Response>(new WorkCallable(newWork)));
        this.addWorkToQueue(newWork, ManagedQueue.QUEUED);
        newWork.setState(Work.Status.WAITING);
        if (this._logger != null) {
            this._logger.info("[thread:%1$d] enqueueWork() Added new work [id:%2$d]", new Object[]{Thread.currentThread().getId(), newWork.getId()});
        }
        this._workManagmentLock.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response getResponseFromCacheEntry(CacheEntry cacheEntry) {
        Response cachedResponse = null;
        if (cacheEntry.getBytesValue() != null && cacheEntry.getBytesValue().length > 0) {
            ByteArrayInputStream inStream = null;
            ObjectInput inObj = null;
            try {
                inStream = new ByteArrayInputStream(cacheEntry.getBytesValue());
                inObj = new ObjectInputStream(inStream);
                cachedResponse = (Response)inObj.readObject();
            }
            catch (Exception e) {
                if (this._logger != null) {
                    this._logger.error((Throwable)e, "Response de-serialization from cache failed", new Object[0]);
                }
            }
            finally {
                if (inObj != null) {
                    try {
                        inObj.close();
                    }
                    catch (Exception exception) {}
                }
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return cachedResponse;
    }

    private void addWorkToQueue(CommWork work, ManagedQueue queue) {
        if (work == null) {
            throw new IllegalArgumentException("'work' can not be NULL");
        }
        if (queue == null) {
            throw new IllegalArgumentException("'queue' can not be NULL");
        }
        this._queuedWork.remove(work);
        this._activeWork.remove(work);
        this._retryWork.remove(work);
        switch (queue) {
            case QUEUED: {
                this._queuedWork.add(work);
                break;
            }
            case ACTIVE: {
                this._activeWork.add(work);
                break;
            }
            case RETRY: {
                this._retryWork.add(work);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format(Locale.US, "Unsupported queue type [%1$s]", queue.name()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startWorking(String name) {
        if (this._logger != null) {
            this._logger.debug("[thread:%1$d] startWorking()", new Object[]{Thread.currentThread().getId()});
        }
        Object object = this._workThreadLock;
        synchronized (object) {
            this._workThreadStopping = false;
            if (this._workThread == null) {
                this._workThread = new Thread((Runnable)new WorkManagementRunnable(), String.format(Locale.US, "CommManager Work Thread [%1$s]", name));
            }
            if (!this._workThread.isAlive()) {
                this._workThread.start();
                if (this._logger != null) {
                    this._logger.debug("[thread:%1$d] Thread started", new Object[]{Thread.currentThread().getId()});
                }
            } else if (this._logger != null) {
                this._logger.debug("[thread:%1$d] Thread already running", new Object[]{Thread.currentThread().getId()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void stopWorking() {
        if (this._logger != null) {
            this._logger.debug("[thread:%1$d] stopWorking()", new Object[]{Thread.currentThread().getId()});
        }
        Object object = this._workThreadLock;
        synchronized (object) {
            if (this._workThread == null) {
                if (this._logger == null) return;
                this._logger.debug("[thread:%1$d] Thread already stopped", new Object[]{Thread.currentThread().getId()});
                return;
            }
            this._workThreadStopping = true;
            if (this._logger != null) {
                this._logger.debug("[thread:%1$d] kicking work thread", new Object[]{Thread.currentThread().getId()});
            }
            Object object2 = this._workManagmentLock;
            synchronized (object2) {
                this._workManagmentLock.notify();
            }
            try {
                this._workThread.join(2000L);
                this._workThread.interrupt();
                this._workThread.join();
                this._workThread = null;
                if (this._logger == null) return;
            }
            catch (InterruptedException e) {
                if (this._logger != null) {
                    this._logger.error("[thread:%1$d] Thread received an interrupt", new Object[]{Thread.currentThread().getId()});
                }
                this._workThread = null;
                if (this._logger == null) return;
                this._logger.debug("[thread:%1$d] Thread stopped", new Object[]{Thread.currentThread().getId()});
                {
                }
            }
            catch (Exception e2) {
                if (this._logger != null) {
                    this._logger.error((Throwable)e2, "[thread:%1$d] failed", new Object[]{Thread.currentThread().getId()});
                }
                this._workThread = null;
                if (this._logger == null) return;
                {
                    catch (Throwable throwable) {
                        this._workThread = null;
                        if (this._logger == null) throw throwable;
                        this._logger.debug("[thread:%1$d] Thread stopped", new Object[]{Thread.currentThread().getId()});
                        throw throwable;
                    }
                }
                this._logger.debug("[thread:%1$d] Thread stopped", new Object[]{Thread.currentThread().getId()});
                {
                }
            }
            this._logger.debug("[thread:%1$d] Thread stopped", new Object[]{Thread.currentThread().getId()});
            {
            }
            return;
        }
    }

    private long getNextRetryInterval() {
        long retryInterval = Long.MAX_VALUE;
        long now = System.currentTimeMillis();
        for (CommWork work : this._retryWork) {
            long delta = work.getRetryAfterTimestamp() - now;
            if (delta >= retryInterval) continue;
            retryInterval = delta;
        }
        if (retryInterval < 20L) {
            retryInterval = 20L;
        }
        if (retryInterval == Long.MAX_VALUE) {
            if (this._logger != null) {
                this._logger.debug("[thread:%1$d] getNextRetryInterval() returning MAX_VALUE", new Object[]{Thread.currentThread().getId()});
            }
        } else if (this._logger != null) {
            this._logger.debug("[thread:%1$d] getNextRetryInterval() returning {} milliseconds", new Object[]{Thread.currentThread().getId(), retryInterval});
        }
        return retryInterval;
    }

    private void removeWork(Work work) {
        if (this._queuedWork.remove(work) && this._logger != null) {
            this._logger.debug("[thread:%1$d][request:%2$d] Work has been removed from _queuedWork", new Object[]{Thread.currentThread().getId(), work.getId()});
        }
        if (this._activeWork.remove(work) && this._logger != null) {
            this._logger.debug("[thread:%1$d][request:%2$d] Work has been removed from _activeWork", new Object[]{Thread.currentThread().getId(), work.getId()});
        }
        if (this._retryWork.remove(work) && this._logger != null) {
            this._logger.debug("[thread:%1$d][request:%2$d] Work has been removed from _retryWork", new Object[]{Thread.currentThread().getId(), work.getId()});
        }
    }

    static /* synthetic */ boolean access$1400(CommManager x0) {
        return x0._disableSSLCertChecking;
    }

    static /* synthetic */ TrustManager[] access$1500() {
        return _TrustAllCertsManagers;
    }

    static /* synthetic */ HostnameVerifier access$1600() {
        return _AllowAllHostnamesVerifier;
    }

    static /* synthetic */ boolean access$1700(CommManager x0) {
        return x0._useBuiltInHttpURLConnectionRedirectionSupport;
    }

    static /* synthetic */ int access$1800(CommManager x0) {
        return x0._connectTimeoutMilliseconds;
    }

    static /* synthetic */ int access$1900(CommManager x0) {
        return x0._readTimeoutMilliseconds;
    }

    public static final class Builder {
        private String _name = "default";
        private CacheProvider _cacheProvider = null;
        private PriorityManagementProvider _priorityManagementProvider = null;
        private RetryPolicyProvider _retryPolicyProvider = null;
        private ConfigurationProvider _configurationProvider = new DefaultConfigurationProvider();
        private LoggingProvider _loggingProvider = null;

        public Builder setName(String name) {
            this._name = name;
            return this;
        }

        public Builder setCacheProvider(CacheProvider cacheProvider) {
            this._cacheProvider = cacheProvider;
            return this;
        }

        public Builder setPriorityManagmentProvider(PriorityManagementProvider priorityManagmentProvider) {
            if (priorityManagmentProvider == null) {
                throw new IllegalArgumentException("'priorityManagmentProvider' can not be NULL");
            }
            this._priorityManagementProvider = priorityManagmentProvider;
            return this;
        }

        public Builder setRetryPolicyProvider(RetryPolicyProvider retryPolicyProvider) {
            if (retryPolicyProvider == null) {
                throw new IllegalArgumentException("'retryPolicyProvider' can not be NULL");
            }
            this._retryPolicyProvider = retryPolicyProvider;
            return this;
        }

        public Builder setConfigurationProvider(ConfigurationProvider configurationProvider) {
            this._configurationProvider = configurationProvider == null ? new DefaultConfigurationProvider() : configurationProvider;
            return this;
        }

        public Builder setLoggingProvider(LoggingProvider loggingProvider) {
            this._loggingProvider = loggingProvider;
            return this;
        }

        public CommManager create() {
            if (this._priorityManagementProvider == null) {
                this._priorityManagementProvider = new DefaultPriorityManagmentProvider(this._loggingProvider);
            }
            if (this._retryPolicyProvider == null) {
                this._retryPolicyProvider = new DefaultRetryPolicyProvider(this._loggingProvider);
            }
            return new CommManager(this._name, this._cacheProvider, this._priorityManagementProvider, this._retryPolicyProvider, this._configurationProvider, this._loggingProvider);
        }
    }

    private class WorkCallable
    implements Callable<Response> {
        private final CommWork _work;
        private String _logPrefix = null;

        private WorkCallable(CommWork work) {
            if (work == null) {
                throw new IllegalArgumentException("'work' can not be NULL");
            }
            this._work = work;
        }

        @Override
        public Response call() throws Exception {
            Response response = null;
            try {
                this._logPrefix = String.format(Locale.US, "[thread:%1$d][request:%2$d]", Thread.currentThread().getId(), this._work.getId());
                response = this.processesRequest();
                if (response == null) {
                    if (CommManager.this._logger != null) {
                        CommManager.this._logger.debug("%1$s Received a NULL result", new Object[]{this._logPrefix});
                    }
                } else if (CommManager.this._logger != null) {
                    CommManager.this._logger.debug("%1$s Response code: %2$d", new Object[]{this._logPrefix, response.getResponseCode()});
                    if (response.getResponseBody() != null && response.getResponseBody().length() > 0) {
                        CommManager.this._logger.debug("%1$s Response body: %2$s", new Object[]{this._logPrefix, response.getResponseBody()});
                    }
                    if (response.getHeaders() != null && response.getHeaders().size() > 0) {
                        for (String name : response.getHeaders().keySet()) {
                            StringBuilder logMsg = new StringBuilder(String.format(Locale.US, "%1$s    Response header '%2$s':", this._logPrefix, name));
                            for (String value : response.getHeaders().get(name)) {
                                logMsg.append(String.format(Locale.US, " '%1$s'", value));
                            }
                            CommManager.this._logger.debug(logMsg.toString(), new Object[0]);
                        }
                    }
                }
                this.cleanup();
            }
            catch (InterruptedException e) {
                CommManager.this._logger.error((Throwable)e, "WorkCallable.call() failed", new Object[0]);
            }
            catch (ExecutionException e) {
                CommManager.this._logger.error((Throwable)e, "WorkCallable.call() failed", new Object[0]);
            }
            return response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Response processesRequest() throws InterruptedException, ExecutionException {
            block88: {
                block83: {
                    block82: {
                        block81: {
                            start = System.currentTimeMillis();
                            response = null;
                            in = null;
                            urlConnection = null;
                            try {
                                dependentWork = this._work.getDependentWork();
                                if (dependentWork == null) ** GOTO lbl106
                                CommManager.access$400(CommManager.this).debug("%1$s Dependent Work found [dependentWork:%2$d]", new Object[]{this._logPrefix, dependentWork.getId()});
                                if (Work.Status.CREATED.equals((Object)dependentWork.getState())) {
                                    CommManager.access$400(CommManager.this).debug("%1$s Starting Dependent Work, re-enqueuing current work [dependentWork:%2$d]", new Object[]{this._logPrefix, dependentWork.getId()});
                                    CommManager.this.enqueueWork(dependentWork);
                                    this.reEnqueueWorkForDependentWork();
                                    var7_11 = null;
                                    if (in == null) break block81;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (MalformedURLException e) {
                                try {
                                    this._work.setException(e);
                                    throw new CommException(e);
                                    catch (IOException e) {
                                        this._work.setException(e);
                                        throw new CommException(e);
                                    }
                                    catch (Exception e) {
                                        this._work.setException(e);
                                        throw e;
                                    }
                                }
                                catch (Throwable var17_39) {
                                    if (in != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (Exception var18_40) {
                                            // empty catch block
                                        }
                                    }
                                    if (urlConnection != null) {
                                        try {
                                            urlConnection.disconnect();
                                        }
                                        catch (Exception var18_41) {
                                            // empty catch block
                                        }
                                    }
                                    if (CommManager.access$400(CommManager.this) == null) throw var17_39;
                                    CommManager.access$400(CommManager.this).debug("%1$s Processing took %2$d milliseconds", new Object[]{this._logPrefix, System.currentTimeMillis() - start});
                                    throw var17_39;
                                }
                            }
                            try {
                                in.close();
                            }
                            catch (Exception var8_15) {
                                // empty catch block
                            }
                        }
                        if (urlConnection != null) {
                            try {
                                urlConnection.disconnect();
                            }
                            catch (Exception var8_16) {
                                // empty catch block
                            }
                        }
                        if (CommManager.access$400(CommManager.this) == null) return var7_11;
                        CommManager.access$400(CommManager.this).debug("%1$s Processing took %2$d milliseconds", new Object[]{this._logPrefix, System.currentTimeMillis() - start});
                        return var7_11;
lbl-1000:
                        // 1 sources

                        {
                            if (!dependentWork.isPending()) ** GOTO lbl-1000
                            CommManager.access$400(CommManager.this).debug("%1$s Re-enqueuing current work [dependentWork:%2$d]", new Object[]{this._logPrefix, dependentWork.getId()});
                            this.reEnqueueWorkForDependentWork();
                            var7_12 = null;
                            if (in == null) break block82;
                        }
                        try {
                            in.close();
                        }
                        catch (Exception var8_17) {
                            // empty catch block
                        }
                    }
                    if (urlConnection != null) {
                        try {
                            urlConnection.disconnect();
                        }
                        catch (Exception var8_18) {
                            // empty catch block
                        }
                    }
                    if (CommManager.access$400(CommManager.this) == null) return var7_12;
                    CommManager.access$400(CommManager.this).debug("%1$s Processing took %2$d milliseconds", new Object[]{this._logPrefix, System.currentTimeMillis() - start});
                    return var7_12;
lbl-1000:
                    // 1 sources

                    {
                        if (Work.Status.RUNNING.equals((Object)dependentWork.getState())) {
                            CommManager.access$400(CommManager.this).debug("%1$s Blocking on Dependent Work [dependentWork:%2$d]", new Object[]{this._logPrefix, dependentWork.getId()});
                            dependentWork.get();
                        }
                        if (!dependentWork.isDone()) {
                            throw new IllegalStateException("Work should have been re-enqueued or blocked on until finished");
                        }
                        if (this._work.getDependentWorkListener() == null || this._work.getDependentWorkListener().onDependentWorkCompleted(dependentWork, this._work)) ** GOTO lbl-1000
                        CommManager.access$400(CommManager.this).debug("%1$s Cancelling current work due to Dependent Work results [dependentWork:%2$d]", new Object[]{this._logPrefix, dependentWork.getId()});
                        this._work.setState(Work.Status.CANCELLED);
                        var7_13 = null;
                        if (in == null) break block83;
                    }
                    try {
                        in.close();
                    }
                    catch (Exception var8_19) {
                        // empty catch block
                    }
                }
                if (urlConnection != null) {
                    try {
                        urlConnection.disconnect();
                    }
                    catch (Exception var8_20) {
                        // empty catch block
                    }
                }
                if (CommManager.access$400(CommManager.this) == null) return var7_13;
                CommManager.access$400(CommManager.this).debug("%1$s Processing took %2$d milliseconds", new Object[]{this._logPrefix, System.currentTimeMillis() - start});
                return var7_13;
lbl-1000:
                // 1 sources

                {
                    block84: {
                        CommManager.access$400(CommManager.this).debug("%1$s Dependent Work completed [dependentWork:%2$d]", new Object[]{this._logPrefix, dependentWork.getId()});
lbl106:
                        // 2 sources

                        if ((urlConnection = (HttpURLConnection)(url = this._work.getRequest().getUri().toURL()).openConnection()) instanceof HttpsURLConnection && CommManager.access$1400(CommManager.this)) {
                            try {
                                sslContext = SSLContext.getInstance("SSL");
                                sslContext.init(null, CommManager.access$1500(), new SecureRandom());
                                ((HttpsURLConnection)urlConnection).setSSLSocketFactory(sslContext.getSocketFactory());
                                ((HttpsURLConnection)urlConnection).setHostnameVerifier(CommManager.access$1600());
                            }
                            catch (Exception e) {
                                if (CommManager.access$400(CommManager.this) == null) break block84;
                                CommManager.access$400(CommManager.this).error((Throwable)e, "%1$s Disabling SSL cert checking failed", new Object[]{this._logPrefix});
                            }
                        }
                    }
                    urlConnection.setInstanceFollowRedirects(CommManager.access$1700(CommManager.this));
                    urlConnection.setConnectTimeout(CommManager.access$1800(CommManager.this));
                    urlConnection.setReadTimeout(CommManager.access$1900(CommManager.this));
                    urlConnection.setDoInput(true);
                    urlConnection.setRequestMethod(this._work.getRequest().getMethod().name());
                    urlConnection.setRequestProperty("Accept-Encoding", "gzip");
                    urlConnection.setRequestProperty("Cache-Control", "no-transform");
                    if (this._work.getRequest().getHeaders() != null) {
                        for (String name : this._work.getRequest().getHeaders().keySet()) {
                            urlConnection.setRequestProperty(name, this._work.getRequest().getHeaders().get(name));
                        }
                    }
                    if ((cacheEntry = this._work.getCachedResponse()) != null && cacheEntry.getEtag() != null && cacheEntry.getEtag().length() > 0) {
                        urlConnection.setRequestProperty("If-None-Match", cacheEntry.getEtag());
                    }
                    if (CommManager.access$400(CommManager.this) != null) {
                        CommManager.access$400(CommManager.this).debug("%1$s Making an HTTP %2$s request to %3$s", new Object[]{this._logPrefix, this._work.getRequest().getMethod().name(), url.toString()});
                        requestHeaders = urlConnection.getRequestProperties();
                        if (requestHeaders != null) {
                            for (String key : requestHeaders.keySet()) {
                                logMsg = new StringBuilder(String.format(Locale.US, "%1$s    Request header '%2$s':", new Object[]{this._logPrefix, key}));
                                for (String value : requestHeaders.get(key)) {
                                    logMsg.append(String.format(Locale.US, " '%1$s'", new Object[]{value}));
                                }
                                CommManager.access$400(CommManager.this).debug(logMsg.toString(), new Object[0]);
                            }
                        }
                    }
                    if ((Request.RequestMethod.POST.equals((Object)this._work.getRequest().getMethod()) || Request.RequestMethod.PUT.equals((Object)this._work.getRequest().getMethod())) && this._work.getRequest().getPostData() != null && this._work.getRequest().getPostData().length > 0) {
                        urlConnection.setDoOutput(true);
                        outStream = null;
                        try {
                            outStream = urlConnection.getOutputStream();
                            outStream.write(this._work.getRequest().getPostData());
                            outStream.flush();
                            if (CommManager.access$400(CommManager.this) != null) {
                                CommManager.access$400(CommManager.this).debug("%1$s Sending %2$d bytes of POST body data", new Object[]{this._logPrefix, this._work.getRequest().getPostData().length});
                            }
                        }
                        finally {
                            if (outStream != null) {
                                try {
                                    outStream.close();
                                }
                                catch (Exception var10_25) {}
                            }
                        }
                    }
                    buffer = new ByteArrayOutputStream();
                    try {
                        urlConnection.connect();
                    }
                    catch (Exception e) {
                        if (CommManager.access$400(CommManager.this) != null) {
                            CommManager.access$400(CommManager.this).error((Throwable)e, this._logPrefix, new Object[0]);
                        }
                        this.handleWorkUpdatesOnException(e);
                        key = null;
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception logMsg) {
                                // empty catch block
                            }
                        }
                        if (urlConnection != null) {
                            try {
                                urlConnection.disconnect();
                            }
                            catch (Exception logMsg) {
                                // empty catch block
                            }
                        }
                        if (CommManager.access$400(CommManager.this) == null) return key;
                        CommManager.access$400(CommManager.this).debug("%1$s Processing took %2$d milliseconds", new Object[]{this._logPrefix, System.currentTimeMillis() - start});
                        return key;
                    }
                }
                {
                    block87: {
                        try {
                            block86: {
                                data = new byte[512];
                                try {
                                    in = urlConnection.getInputStream();
                                }
                                catch (IOException ioe) {
                                    if (CommManager.access$400(CommManager.this) != null) {
                                        CommManager.access$400(CommManager.this).debug("%1$s getInputStream() failed, trying getErrorStream()", new Object[]{this._logPrefix});
                                    }
                                    in = urlConnection.getErrorStream();
                                }
                                contentEncoding = null;
                                try {
                                    contentEncoding = Response.getContentEncoding(urlConnection.getHeaderFields());
                                }
                                catch (Exception e) {
                                    if (CommManager.access$400(CommManager.this) == null) break block86;
                                    CommManager.access$400(CommManager.this).error((Throwable)e, "%1$s Failed to parse value from 'Content-Encoding' header", new Object[]{this._logPrefix});
                                }
                            }
                            if (contentEncoding != null && contentEncoding.length() > 0 && contentEncoding.equalsIgnoreCase("gzip")) {
                                in = new GZIPInputStream(in);
                                if (CommManager.access$400(CommManager.this) != null) {
                                    CommManager.access$400(CommManager.this).debug("%1$s Received gzipped data", new Object[]{this._logPrefix});
                                }
                            } else if (CommManager.access$400(CommManager.this) != null) {
                                CommManager.access$400(CommManager.this).debug("%1$s Received non-gzipped data", new Object[]{this._logPrefix});
                            }
                            while ((readCount = in.read(data, 0, data.length)) != -1) {
                                buffer.write(data, 0, readCount);
                            }
                            buffer.flush();
                        }
                        catch (Exception e) {
                            if (CommManager.access$400(CommManager.this) == null) break block87;
                            CommManager.access$400(CommManager.this).error((Throwable)e, this._logPrefix, new Object[0]);
                        }
                    }
                    response = new Response(buffer.toByteArray(), urlConnection.getHeaderFields(), urlConnection.getResponseCode(), this._work.getRequest().getId(), (int)(System.currentTimeMillis() - start), CommManager.access$400(CommManager.this));
                    this._work.setResponse(response);
                    if (CommManager.access$400(CommManager.this) != null) {
                        CommManager.access$400(CommManager.this).debug("%1$s Request finished with a %2$d response code", new Object[]{this._logPrefix, this._work.getResponse().getResponseCode()});
                    }
                    this.handleWorkUpdatesOnResponse(response, urlConnection);
                    if (in == null) break block88;
                }
                try {
                    in.close();
                }
                catch (Exception dependentWork) {
                    // empty catch block
                }
            }
            if (urlConnection != null) {
                try {
                    urlConnection.disconnect();
                }
                catch (Exception dependentWork) {
                    // empty catch block
                }
            }
            if (CommManager.access$400(CommManager.this) == null) return response;
            CommManager.access$400(CommManager.this).debug("%1$s Processing took %2$d milliseconds", new Object[]{this._logPrefix, System.currentTimeMillis() - start});
            return response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reEnqueueWorkForDependentWork() {
            Object object = CommManager.this._workManagmentLock;
            synchronized (object) {
                if (!this._work.isDone()) {
                    this._work.updateRetryAfterTimestamp(333L);
                    this._work.setState(Work.Status.RETRYING);
                    this._work.addFutureTask(new FutureTask<Response>(new WorkCallable(this._work)));
                    CommManager.this.addWorkToQueue(this._work, ManagedQueue.RETRY);
                    CommManager.this._workManagmentLock.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleWorkUpdatesOnException(Exception e) {
            this._work.setException(e);
            RetryProfile retryProfile = CommManager.this._retryPolicyProvider.shouldRetry((Work)this._work, e);
            Object object = CommManager.this._workManagmentLock;
            synchronized (object) {
                if (!this._work.isDone()) {
                    if (retryProfile.shouldRetry()) {
                        this._work.updateRetryAfterTimestamp(retryProfile.getRetryAfterMilliseconds());
                        this._work.getRequest().incrementRetryCountFromFailure();
                        this._work.setState(Work.Status.RETRYING);
                        CommManager.this.addWorkToQueue(this._work, ManagedQueue.RETRY);
                        this._work.addFutureTask(new FutureTask<Response>(new WorkCallable(this._work)));
                        CommManager.this._workManagmentLock.notify();
                    } else {
                        this._work.setState(Work.Status.COMPLETED);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleWorkUpdatesOnResponse(Response response, HttpURLConnection urlConnection) {
            RetryProfile retryProfile = CommManager.this._retryPolicyProvider.shouldRetry((Work)this._work, response);
            if (retryProfile.shouldRetry()) {
                Object object = CommManager.this._workManagmentLock;
                synchronized (object) {
                    if (!this._work.isDone()) {
                        this._work.updateRetryAfterTimestamp(retryProfile.getRetryAfterMilliseconds());
                        this._work.getRequest().incrementRetryCountFromResponse();
                        this._work.setState(Work.Status.RETRYING);
                        this._work.addFutureTask(new FutureTask<Response>(new WorkCallable(this._work)));
                        CommManager.this.addWorkToQueue(this._work, ManagedQueue.RETRY);
                        CommManager.this._workManagmentLock.notify();
                    }
                }
            }
            if (!(response.getResponseCode() != 301 && response.getResponseCode() != 302 && response.getResponseCode() != 303 || this._work.getRequest().getRedirectCount() >= CommManager.this._redirectLimit || urlConnection.getInstanceFollowRedirects())) {
                Object object = CommManager.this._workManagmentLock;
                synchronized (object) {
                    if (!this._work.isCancelled()) {
                        URI targetUri = response.getLocationFromHeaders(this._work.getRequest());
                        if (CommManager.this._logger != null) {
                            CommManager.this._logger.debug("%1$s Redirecting from %2$s to %3$s", new Object[]{this._logPrefix, this._work.getRequest().getUri().toString(), targetUri.toString()});
                        }
                        this._work.getRequest().redirect(targetUri);
                        this._work.updateRetryAfterTimestamp(0L);
                        this._work.setState(Work.Status.REDIRECTING);
                        this._work.addFutureTask(new FutureTask<Response>(new WorkCallable(this._work)));
                        CommManager.this.addWorkToQueue(this._work, ManagedQueue.RETRY);
                        CommManager.this._workManagmentLock.notify();
                    }
                }
            }
            if (this._work.shouldCache() && this._work.getCachedResponse() != null && CommManager.this._cacheProvider != null && response.getResponseCode() == 304) {
                Long maxStale;
                String eTag;
                CacheEntry cacheEntry = this._work.getCachedResponse();
                Long ttl = response.getTtlFromHeaders();
                if (ttl == null) {
                    ttl = cacheEntry.getTtl();
                }
                if ((eTag = response.getETagFromHeaders()) == null || eTag.length() <= 0) {
                    eTag = cacheEntry.getEtag();
                }
                if ((maxStale = response.getMaxStaleFromHeaders()) == null) {
                    maxStale = cacheEntry.getMaxStale();
                }
                CommManager.this._cacheProvider.remove(cacheEntry.getKey());
                CommManager.this._cacheProvider.add(cacheEntry.getKey(), cacheEntry.getBytesValue(), ttl.longValue(), maxStale.longValue(), eTag, cacheEntry.getUri(), cacheEntry.getPriority());
                Response cachedResponse = CommManager.this.getResponseFromCacheEntry(cacheEntry);
                this._work.setResponse(cachedResponse);
                this._work.addFutureTask(new CachedResponseFuture(cachedResponse));
                this._work.setState(Work.Status.COMPLETED);
                if (CommManager.this._logger != null) {
                    CommManager.this._logger.info("[thread:%1$d] handleWorkUpdatesOnResponse() Returning cached results post 304 [id:%2$d]", new Object[]{Thread.currentThread().getId(), this._work.getId()});
                }
            } else if (this._work.shouldCache() && CommManager.this._cacheProvider != null && response.isSuccessful()) {
                byte[] responseObjBytes = null;
                ByteArrayOutputStream outStream = null;
                ObjectOutput out = null;
                try {
                    outStream = new ByteArrayOutputStream();
                    out = new ObjectOutputStream(outStream);
                    out.writeObject(response);
                    responseObjBytes = outStream.toByteArray();
                    if (responseObjBytes != null && responseObjBytes.length > 0) {
                        Long ttl = response.getTtlFromHeaders();
                        if (ttl == null) {
                            ttl = Long.MAX_VALUE;
                        }
                        String eTag = response.getETagFromHeaders();
                        Long maxStale = response.getMaxStaleFromHeaders();
                        if (maxStale == null) {
                            maxStale = 0L;
                        }
                        CommManager.this._cacheProvider.add(Integer.toString(this._work.getRequest().getId()), responseObjBytes, ttl.longValue(), maxStale.longValue(), eTag, this._work.getRequest().getUri(), this._work.getCachingPriority());
                        if (CommManager.this._logger != null) {
                            CommManager.this._logger.debug("%1$s Response for request %2$d added to cache", new Object[]{this._logPrefix, this._work.getRequest().getId()});
                        }
                        CommManager.this._cacheProvider.trimLru();
                    }
                }
                catch (Exception e) {
                    if (CommManager.this._logger != null) {
                        CommManager.this._logger.error((Throwable)e, "Response serialization to cache failed", new Object[0]);
                    }
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (outStream != null) {
                        try {
                            outStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                this._work.setState(Work.Status.COMPLETED);
            } else {
                this._work.setState(Work.Status.COMPLETED);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cleanup() {
            Object object = CommManager.this._workManagmentLock;
            synchronized (object) {
                if (CommManager.this._logger != null) {
                    CommManager.this._logger.debug("%1$s Work completed, doing cleanup [state:%2$s]", new Object[]{this._logPrefix, this._work.getState()});
                }
                switch (this._work.getState()) {
                    case CREATED: {
                        break;
                    }
                    case WAITING: {
                        break;
                    }
                    case RUNNING: {
                        break;
                    }
                    case RETRYING: {
                        break;
                    }
                    case REDIRECTING: {
                        break;
                    }
                    case CANCELLED: 
                    case COMPLETED: {
                        CommManager.this.removeWork(this._work);
                        if (CommManager.this._logger != null) {
                            CommManager.this._logger.debug("[thread:%1$d] Kicking work thread", new Object[]{Thread.currentThread().getId()});
                        }
                        CommManager.this._workManagmentLock.notify();
                    }
                }
            }
        }
    }

    private class WorkManagementRunnable
    implements Runnable {
        private WorkManagementRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long sleepTime = Long.MAX_VALUE;
            while (!CommManager.this._workThreadStopping) {
                try {
                    if (CommManager.this._workThreadStopping) break;
                    Object object = CommManager.this._workManagmentLock;
                    synchronized (object) {
                        if (CommManager.this._logger != null) {
                            CommManager.this._logger.debug("[thread:%1$d] queued:{%2$d} active:{%3$d} retry:{%4$d}", new Object[]{Thread.currentThread().getId(), CommManager.this._queuedWork.size(), CommManager.this._activeWork.size(), CommManager.this._retryWork.size()});
                        }
                        long now = System.currentTimeMillis();
                        ArrayList<CommWork> retryNowList = new ArrayList<CommWork>();
                        for (CommWork retryWork : CommManager.this._retryWork) {
                            if (retryWork.getRetryAfterTimestamp() > now) continue;
                            retryNowList.add(retryWork);
                        }
                        for (CommWork retryWork : retryNowList) {
                            if (retryWork.isDone()) continue;
                            CommManager.this.addWorkToQueue(retryWork, ManagedQueue.QUEUED);
                            retryWork.setState(Work.Status.WAITING);
                            if (CommManager.this._logger == null) continue;
                            CommManager.this._logger.debug("[thread:%1$d] Request %2$d moved from retry to queue", new Object[]{Thread.currentThread().getId(), retryWork.getId()});
                        }
                        while (CommManager.this._activeWork.size() < CommManager.this._maxSimultaneousRequests && CommManager.this._queuedWork.size() > 0) {
                            for (CommWork work : CommManager.this._queuedWork) {
                                CommManager.this._priorityManagmentProvider.promotePriority(work.getRequestPriority());
                            }
                            Collections.sort(CommManager.this._queuedWork, CommManager.this._workComparator);
                            CommWork workToStart = (CommWork)CommManager.this._queuedWork.removeFirst();
                            if (workToStart.isDone()) continue;
                            CommManager.this.addWorkToQueue(workToStart, ManagedQueue.ACTIVE);
                            workToStart.setState(Work.Status.RUNNING);
                            CommManager.this._requestWorkExecutorService.execute(workToStart.getFutureTask());
                        }
                        sleepTime = CommManager.this.getNextRetryInterval();
                        if (CommManager.this._logger != null) {
                            CommManager.this._logger.debug("[thread:%1$d] Work thread is waiting to be notified [sleepTime:%2$d]", new Object[]{Thread.currentThread().getId(), sleepTime});
                        }
                        CommManager.this._workManagmentLock.wait(sleepTime);
                        if (CommManager.this._logger != null) {
                            CommManager.this._logger.debug("[thread:%1$d] Work thread is awake", new Object[]{Thread.currentThread().getId()});
                        }
                    }
                    if (!CommManager.this._workThreadStopping) continue;
                    break;
                }
                catch (Exception e) {
                    if (CommManager.this._logger != null) {
                        CommManager.this._logger.error((Throwable)e, "[thread:%1$d] failure", new Object[]{Thread.currentThread().getId()});
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {}
                }
            }
            if (CommManager.this._logger != null) {
                CommManager.this._logger.debug("[thread:%1$d] Work Thread exited", new Object[]{Thread.currentThread().getId()});
            }
        }
    }

    private static enum ManagedQueue {
        QUEUED,
        ACTIVE,
        RETRY;

    }
}

