/*
 * Decompiled with CFR 0.152.
 */
package net.toddm.comm;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.toddm.cache.CachePriority;
import net.toddm.comm.CacheBehavior;
import net.toddm.comm.DependentWorkListener;
import net.toddm.comm.Priority;
import net.toddm.comm.Request;
import net.toddm.comm.Response;
import net.toddm.comm.SubmittableWork;
import net.toddm.comm.Work;

class CachedWork
implements Work {
    private final Request request;
    private final Response cachedResponse;
    private final Priority requestPriority;
    private final CachePriority cachingPriority;
    private final CacheBehavior cachingBehavior;

    protected CachedWork(Request request, Response cachedResponse, Priority requestPriority, CachePriority cachingPriority, CacheBehavior cachingBehavior) {
        if (request == null) {
            throw new IllegalArgumentException("'request' cannot be null");
        }
        if (cachedResponse == null) {
            throw new IllegalArgumentException("'cachedResponse' cannot be null");
        }
        if (requestPriority == null) {
            throw new IllegalArgumentException("'requestPriority' cannot be null");
        }
        if (cachingPriority == null) {
            throw new IllegalArgumentException("'cachingPriority' cannot be null");
        }
        if (cachingBehavior == null) {
            throw new IllegalArgumentException("'cachingBehavior' cannot be null");
        }
        this.request = request;
        this.cachedResponse = cachedResponse;
        this.requestPriority = requestPriority;
        this.cachingPriority = cachingPriority;
        this.cachingBehavior = cachingBehavior;
    }

    @Override
    public Work.Status getState() {
        return Work.Status.COMPLETED;
    }

    @Override
    public int getId() {
        return this.request.getId();
    }

    @Override
    public Response get() throws InterruptedException, ExecutionException {
        return this.cachedResponse;
    }

    @Override
    public Response get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.cachedResponse;
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    @Override
    public Priority getRequestPriority() {
        return this.requestPriority;
    }

    @Override
    public CachePriority getCachingPriority() {
        return this.cachingPriority;
    }

    @Override
    public CacheBehavior getCachingBehavior() {
        return this.cachingBehavior;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public void setDependentWork(SubmittableWork dependentWork, DependentWorkListener dependentWorkListener) {
    }

    @Override
    public Exception getException() {
        return null;
    }
}

