/*
 * Decompiled with CFR 0.152.
 */
package net.toddm.comm;

public class Base64 {
    private static final char[] encodingMap;

    private static char encodeByteAsChar(int i) {
        return encodingMap[i & 0x3F];
    }

    public static String encode(byte[] input) {
        if (input == null || input.length <= 0) {
            throw new IllegalArgumentException("'input' can not be NULL or empty");
        }
        char[] buffer = new char[(input.length + 2) / 3 * 4];
        int bufferIndex = 0;
        block4: for (int i = 0; i < input.length; i += 3) {
            switch (input.length - i) {
                case 1: {
                    buffer[bufferIndex++] = Base64.encodeByteAsChar(input[i] >> 2);
                    buffer[bufferIndex++] = Base64.encodeByteAsChar((input[i] & 3) << 4);
                    buffer[bufferIndex++] = 61;
                    buffer[bufferIndex++] = 61;
                    continue block4;
                }
                case 2: {
                    buffer[bufferIndex++] = Base64.encodeByteAsChar(input[i] >> 2);
                    buffer[bufferIndex++] = Base64.encodeByteAsChar((input[i] & 3) << 4 | input[i + 1] >> 4 & 0xF);
                    buffer[bufferIndex++] = Base64.encodeByteAsChar((input[i + 1] & 0xF) << 2);
                    buffer[bufferIndex++] = 61;
                    continue block4;
                }
                default: {
                    buffer[bufferIndex++] = Base64.encodeByteAsChar(input[i] >> 2);
                    buffer[bufferIndex++] = Base64.encodeByteAsChar((input[i] & 3) << 4 | input[i + 1] >> 4 & 0xF);
                    buffer[bufferIndex++] = Base64.encodeByteAsChar((input[i + 1] & 0xF) << 2 | input[i + 2] >> 6 & 3);
                    buffer[bufferIndex++] = Base64.encodeByteAsChar(input[i + 2] & 0x3F);
                }
            }
        }
        if (bufferIndex != buffer.length) {
            throw new IllegalStateException("Base64 encoding failed");
        }
        return new String(buffer);
    }

    static {
        int i;
        encodingMap = new char[64];
        for (i = 0; i < 26; ++i) {
            Base64.encodingMap[i] = (char)(65 + i);
        }
        for (i = 26; i < 52; ++i) {
            Base64.encodingMap[i] = (char)(97 + (i - 26));
        }
        for (i = 52; i < 62; ++i) {
            Base64.encodingMap[i] = (char)(48 + (i - 52));
        }
        Base64.encodingMap[62] = 43;
        Base64.encodingMap[63] = 47;
    }
}

