/*
 * Decompiled with CFR 0.152.
 */
package net.tlabs.tablesaw.parquet;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.tlabs.tablesaw.parquet.TablesawParquetReadOptions;
import net.tlabs.tablesaw.parquet.TablesawRecordMaterializer;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.InstantColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.Row;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.TextColumn;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.io.ReadOptions;

public class TablesawReadSupport
extends ReadSupport<Row> {
    private final TablesawParquetReadOptions options;
    private Table table = null;

    public TablesawReadSupport(TablesawParquetReadOptions options) {
        this.options = options;
    }

    public ReadSupport.ReadContext init(InitContext context) {
        List initialFields = context.getFileSchema().getFields();
        List filteredFieldsIndices = IntStream.range(0, initialFields.size()).filter(i -> this.acceptFieldName((Type)initialFields.get(i))).filter(i -> this.acceptFieldType((Type)initialFields.get(i))).boxed().sorted(Comparator.comparingInt(i -> this.options.getColumns().indexOf(((Type)initialFields.get((int)i)).getName()))).collect(Collectors.toList());
        List projectedFieldsIndices = IntStream.range(0, filteredFieldsIndices.size()).filter(i -> this.acceptMappedFieldType(i, (Type)initialFields.get((Integer)filteredFieldsIndices.get(i)))).map(filteredFieldsIndices::get).boxed().collect(Collectors.toList());
        this.table = Table.create((String)this.options.tableName(), (Collection)IntStream.range(0, projectedFieldsIndices.size()).mapToObj(i -> this.getColumnForType(i, (Type)initialFields.get((Integer)projectedFieldsIndices.get(i)))).collect(Collectors.toList()));
        return new ReadSupport.ReadContext(new MessageType("parquet.read.schema", projectedFieldsIndices.stream().map(initialFields::get).collect(Collectors.toList())));
    }

    public RecordMaterializer<Row> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        return new TablesawRecordMaterializer(this.table, readContext.getRequestedSchema(), this.options);
    }

    private boolean acceptFieldName(Type type) {
        return this.options.hasColumn(type.getName());
    }

    private boolean acceptFieldType(Type type) {
        if (type.isPrimitive() && !type.isRepetition(Type.Repetition.REPEATED)) {
            return this.acceptSimplePrimitives(type);
        }
        return this.acceptGroupsAndRepeatedFields();
    }

    private boolean acceptGroupsAndRepeatedFields() {
        return this.options.getManageGroupsAs() != TablesawParquetReadOptions.ManageGroupsAs.SKIP;
    }

    private boolean acceptSimplePrimitives(Type type) {
        switch (type.asPrimitiveType().getPrimitiveTypeName()) {
            case FIXED_LEN_BYTE_ARRAY: {
                if (type.getLogicalTypeAnnotation() == null) {
                    return this.options.getUnnanotatedBinaryAs() != TablesawParquetReadOptions.UnnanotatedBinaryAs.SKIP;
                }
                return true;
            }
            case BINARY: {
                if (type.getLogicalTypeAnnotation() == null) {
                    return this.options.getUnnanotatedBinaryAs() != TablesawParquetReadOptions.UnnanotatedBinaryAs.SKIP;
                }
                return Optional.ofNullable(type.getLogicalTypeAnnotation()).flatMap(a -> a.accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<Boolean>(){

                    public Optional<Boolean> visit(LogicalTypeAnnotation.BsonLogicalTypeAnnotation bsonLogicalType) {
                        return Optional.of(Boolean.FALSE);
                    }
                })).orElse(Boolean.TRUE);
            }
        }
        return true;
    }

    private boolean acceptMappedFieldType(int fieldIndex, Type type) {
        ReadOptions.ColumnTypeReadOptions columnTypeReadOptions = this.options.columnTypeReadOptions();
        return columnTypeReadOptions.columnType(fieldIndex, type.getName()).map(t -> !ColumnType.SKIP.equals(t)).orElse(!columnTypeReadOptions.hasColumnTypeForAllColumnsIfHavingColumnNames());
    }

    private Column<?> getColumnForType(int fieldIndex, Type field) {
        String name = field.getName();
        ReadOptions.ColumnTypeReadOptions columnTypeReadOptions = this.options.columnTypeReadOptions();
        Optional columnType = columnTypeReadOptions.columnType(fieldIndex, name);
        if (columnType.isPresent()) {
            return ((ColumnType)columnType.get()).create(name);
        }
        return this.getDefaultColumnForType(name, field);
    }

    private Column<?> getDefaultColumnForType(String name, Type field) {
        if (field.isPrimitive() && !field.isRepetition(Type.Repetition.REPEATED)) {
            return this.createSimplePrimitiveColumn(name, field);
        }
        switch (this.options.getManageGroupsAs()) {
            case ERROR: {
                throw new UnsupportedOperationException("Column " + name + " is a group");
            }
            case SKIP: {
                throw new IllegalStateException("Skipped group " + name + " still in schema");
            }
        }
        return TextColumn.create((String)name);
    }

    private Column<?> createSimplePrimitiveColumn(String fieldName, Type fieldType) {
        switch (fieldType.asPrimitiveType().getPrimitiveTypeName()) {
            case BOOLEAN: {
                return BooleanColumn.create((String)fieldName);
            }
            case INT32: {
                return Optional.ofNullable(fieldType.getLogicalTypeAnnotation()).flatMap(a -> TablesawReadSupport.annotatedIntColumn(a, fieldName, this.options)).orElseGet(() -> IntColumn.create((String)fieldName));
            }
            case INT64: {
                return Optional.ofNullable(fieldType.getLogicalTypeAnnotation()).flatMap(a -> TablesawReadSupport.annotatedLongColumn(a, fieldName)).orElseGet(() -> LongColumn.create((String)fieldName));
            }
            case FLOAT: {
                return this.options.isFloatColumnTypeUsed() ? FloatColumn.create((String)fieldName) : DoubleColumn.create((String)fieldName);
            }
            case DOUBLE: {
                return DoubleColumn.create((String)fieldName);
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return Optional.ofNullable(fieldType.getLogicalTypeAnnotation()).flatMap(a -> TablesawReadSupport.annotatedFixedLenBinaryColumn(a, fieldName)).orElseGet(() -> StringColumn.create((String)fieldName));
            }
            case INT96: {
                return this.options.isConvertInt96ToTimestamp() ? InstantColumn.create((String)fieldName) : StringColumn.create((String)fieldName);
            }
            case BINARY: {
                return Optional.ofNullable(fieldType.getLogicalTypeAnnotation()).flatMap(a -> TablesawReadSupport.annotatedBinaryColumn(a, fieldName)).orElseGet(() -> StringColumn.create((String)fieldName));
            }
        }
        throw new IllegalStateException("Unknown field type " + fieldType.getName() + " for column " + fieldName);
    }

    private static Optional<Column<?>> annotatedBinaryColumn(LogicalTypeAnnotation annotation, final String fieldName) {
        return annotation.accept(new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<Column<?>>(){

            public Optional<Column<?>> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation stringLogicalType) {
                return Optional.of(StringColumn.create((String)fieldName));
            }

            public Optional<Column<?>> visit(LogicalTypeAnnotation.EnumLogicalTypeAnnotation enumLogicalType) {
                return Optional.of(StringColumn.create((String)fieldName));
            }

            public Optional<Column<?>> visit(LogicalTypeAnnotation.JsonLogicalTypeAnnotation jsonLogicalType) {
                return Optional.of(TextColumn.create((String)fieldName));
            }

            public Optional<Column<?>> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType) {
                return Optional.of(DoubleColumn.create((String)fieldName));
            }
        });
    }

    private static Optional<Column<?>> annotatedFixedLenBinaryColumn(LogicalTypeAnnotation annotation, final String fieldName) {
        return annotation.accept(new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<Column<?>>(){

            public Optional<Column<?>> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType) {
                return Optional.of(DoubleColumn.create((String)fieldName));
            }
        });
    }

    private static Optional<Column<?>> annotatedLongColumn(LogicalTypeAnnotation annotation, final String fieldName) {
        return annotation.accept(new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<Column<?>>(){

            public Optional<Column<?>> visit(LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeLogicalType) {
                return Optional.of(TimeColumn.create((String)fieldName));
            }

            public Optional<Column<?>> visit(LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalType) {
                return Optional.of(timestampLogicalType.isAdjustedToUTC() ? InstantColumn.create((String)fieldName) : DateTimeColumn.create((String)fieldName));
            }
        });
    }

    private static Optional<Column<?>> annotatedIntColumn(LogicalTypeAnnotation annotation, final String fieldName, final TablesawParquetReadOptions options) {
        return annotation.accept(new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<Column<?>>(){

            public Optional<Column<?>> visit(LogicalTypeAnnotation.DateLogicalTypeAnnotation dateLogicalType) {
                return Optional.of(DateColumn.create((String)fieldName));
            }

            public Optional<Column<?>> visit(LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeLogicalType) {
                return Optional.of(TimeColumn.create((String)fieldName));
            }

            public Optional<Column<?>> visit(LogicalTypeAnnotation.IntLogicalTypeAnnotation intLogicalType) {
                return Optional.of(TablesawReadSupport.mustUseShortColumn(intLogicalType, options) ? ShortColumn.create((String)fieldName) : IntColumn.create((String)fieldName));
            }
        });
    }

    private static boolean mustUseShortColumn(LogicalTypeAnnotation.IntLogicalTypeAnnotation intLogicalType, TablesawParquetReadOptions options) {
        return options.isShortColumnTypeUsed() && intLogicalType.getBitWidth() < 32;
    }

    public Table getTable() {
        return this.table;
    }
}

