/*
 * Decompiled with CFR 0.152.
 */
package net.tlabs.tablesaw.parquet;

import java.io.IOException;
import net.tlabs.tablesaw.parquet.TablesawParquetWriteOptions;
import net.tlabs.tablesaw.parquet.TablesawWriteSupport;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.tablesaw.api.Row;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.DataWriter;
import tech.tablesaw.io.Destination;
import tech.tablesaw.io.RuntimeIOException;

public class TablesawParquetWriter
implements DataWriter<TablesawParquetWriteOptions> {
    private static final Logger LOG = LoggerFactory.getLogger(TablesawParquetWriter.class);

    public void write(Table table, Destination dest) {
        throw new UnsupportedOperationException("The use of Destination is not supported, please use the write(Table, TablesawParquetWriteOptions) method");
    }

    public void write(Table table, TablesawParquetWriteOptions options) {
        try {
            LocalFileSystem fs = FileSystem.getLocal((Configuration)new Configuration());
            fs.setWriteChecksum(options.isWriteChecksum());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        try (ParquetWriter writer = ((Builder)((Builder)((Builder)new Builder(new Path(options.getOutputFile()), table).withCompressionCodec(CompressionCodecName.fromConf((String)options.getCompressionCodec().name()))).withWriteMode(options.isOverwrite() ? ParquetFileWriter.Mode.OVERWRITE : ParquetFileWriter.Mode.CREATE)).withValidation(false)).build();){
            long start = System.currentTimeMillis();
            for (Row row : table) {
                writer.write((Object)row);
            }
            long end = System.currentTimeMillis();
            LOG.debug("Finished writing {} rows to {} in {} ms", new Object[]{table.rowCount(), options.getOutputFile(), end - start});
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    protected static class Builder
    extends ParquetWriter.Builder<Row, Builder> {
        private final Table table;

        protected Builder(Path path, Table table) {
            super(path);
            this.table = table;
        }

        protected Builder self() {
            return this;
        }

        protected WriteSupport<Row> getWriteSupport(Configuration conf) {
            return new TablesawWriteSupport(this.table);
        }
    }
}

