/*
 * Decompiled with CFR 0.152.
 */
package net.tlabs.tablesaw.parquet;

import java.io.File;
import java.io.Writer;
import tech.tablesaw.io.WriteOptions;

public class TablesawParquetWriteOptions
extends WriteOptions {
    private final String outputFile;
    private final CompressionCodec compressionCodec;
    private final boolean overwrite;
    private final boolean writeChecksum;

    public static Builder builder(File file) {
        return new Builder(file.getAbsolutePath());
    }

    public static Builder builder(String outputFile) {
        return new Builder(outputFile);
    }

    protected TablesawParquetWriteOptions(Builder builder) {
        super((WriteOptions.Builder)builder);
        this.outputFile = builder.outputFile;
        this.compressionCodec = builder.compressionCodec;
        this.overwrite = builder.overwrite;
        this.writeChecksum = builder.writeChecksum;
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public CompressionCodec getCompressionCodec() {
        return this.compressionCodec;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public boolean isWriteChecksum() {
        return this.writeChecksum;
    }

    public static class Builder
    extends WriteOptions.Builder {
        private final String outputFile;
        private CompressionCodec compressionCodec = CompressionCodec.SNAPPY;
        private boolean overwrite = true;
        private boolean writeChecksum = false;

        public Builder(String outputFile) {
            super((Writer)null);
            this.outputFile = outputFile;
        }

        public Builder withCompressionCode(CompressionCodec compressionCodec) {
            this.compressionCodec = compressionCodec;
            return this;
        }

        public Builder withOverwrite(boolean overwrite) {
            this.overwrite = overwrite;
            return this;
        }

        public Builder withWriteChecksum(boolean writeChecksum) {
            this.writeChecksum = writeChecksum;
            return this;
        }

        public TablesawParquetWriteOptions build() {
            return new TablesawParquetWriteOptions(this);
        }
    }

    public static enum CompressionCodec {
        UNCOMPRESSED,
        SNAPPY,
        GZIP,
        ZSTD,
        LZ4;

    }
}

