/*
 * Decompiled with CFR 0.152.
 */
package net.tlabs.tablesaw.parquet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import net.tlabs.tablesaw.parquet.TablesawParquetReadOptions;
import net.tlabs.tablesaw.parquet.TablesawReadSupport;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.tablesaw.api.Row;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.DataReader;
import tech.tablesaw.io.RuntimeIOException;
import tech.tablesaw.io.Source;

public class TablesawParquetReader
implements DataReader<TablesawParquetReadOptions> {
    private static final Logger LOG = LoggerFactory.getLogger(TablesawParquetReader.class);

    public Table read(Source source) {
        File file = source.file();
        if (file != null) {
            return this.read(TablesawParquetReadOptions.builder(file).build());
        }
        InputStream inStream = source.inputStream();
        if (inStream != null) {
            return this.readFromStream(inStream);
        }
        throw new UnsupportedOperationException("Reading parquet from a character stream is not supported");
    }

    public Table read(TablesawParquetReadOptions options) {
        Table table;
        block8: {
            TablesawReadSupport readSupport = new TablesawReadSupport(options);
            ParquetReader<Row> reader = this.makeReader(options.getInputURI(), readSupport);
            try {
                table = this.readInternal(reader, readSupport, options.getSanitizedinputPath());
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeIOException(e);
                }
            }
            reader.close();
        }
        return table;
    }

    private Table readFromStream(InputStream inStream) {
        TablesawReadSupport readSupport = new TablesawReadSupport(TablesawParquetReadOptions.builderForStream().build());
        try {
            return this.readInternal(this.makeReaderFromStream(inStream, readSupport), readSupport, "stream");
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private Table readInternal(ParquetReader<Row> reader, TablesawReadSupport readSupport, String displayName) throws IOException {
        long start = System.currentTimeMillis();
        int i = 0;
        while (reader.read() != null) {
            ++i;
        }
        long end = System.currentTimeMillis();
        LOG.debug("Finished reading {} rows from {} in {} ms", new Object[]{i, displayName, end - start});
        return readSupport.getTable();
    }

    private ParquetReader<Row> makeReader(URI uri, TablesawReadSupport readSupport) throws IOException {
        String scheme = uri.getScheme();
        if (scheme != null) {
            switch (scheme) {
                case "http": 
                case "https": 
                case "ftp": 
                case "ftps": {
                    try (InputStream inStream = uri.toURL().openStream();){
                        ParquetReader<Row> parquetReader = this.makeReaderFromStream(inStream, readSupport);
                        return parquetReader;
                    }
                }
            }
        }
        return ParquetReader.builder((ReadSupport)readSupport, (Path)new Path(uri)).build();
    }

    private ParquetReader<Row> makeReaderFromStream(InputStream inStream, TablesawReadSupport readSupport) throws IOException {
        File tmpFile = this.createSecureTempFile("tablesaw-parquet", "parquet");
        tmpFile.deleteOnExit();
        try (FileOutputStream outStream = new FileOutputStream(tmpFile);){
            IOUtils.copyLarge((InputStream)inStream, (OutputStream)outStream);
            ParquetReader parquetReader = ParquetReader.builder((ReadSupport)readSupport, (Path)new Path(tmpFile.toURI())).build();
            return parquetReader;
        }
    }

    private File createSecureTempFile(String prefix, String suffix) throws IOException {
        if (SystemUtils.IS_OS_UNIX) {
            FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rw-------"));
            return Files.createTempFile(prefix, suffix, attr).toFile();
        }
        File tmpFile = Files.createTempFile(prefix, suffix, new FileAttribute[0]).toFile();
        if (!tmpFile.setReadable(true, true) || !tmpFile.setWritable(true, true)) {
            throw new IOException("Unable to set required permission on temporary file " + tmpFile.getAbsolutePath());
        }
        return tmpFile;
    }
}

