/*
 * Decompiled with CFR 0.152.
 */
package net.tlabs.tablesaw.parquet;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.io.ReadOptions;

public class TablesawParquetReadOptions
extends ReadOptions {
    private static final Logger LOG = LoggerFactory.getLogger(TablesawParquetReadOptions.class);
    private final boolean convertInt96ToTimestamp;
    private final UnnanotatedBinaryAs unnanotatedBinaryAs;
    private final boolean shortColumnTypeUsed;
    private final boolean floatColumnTypeUsed;
    private final ManageGroupsAs manageGroupsAs;
    private final List<String> columns;
    private final URI inputURI;

    protected TablesawParquetReadOptions(Builder builder) {
        super((ReadOptions.Builder)builder);
        this.convertInt96ToTimestamp = builder.convertInt96ToTimestamp;
        this.unnanotatedBinaryAs = builder.unnanotatedBinaryAs;
        this.manageGroupsAs = builder.manageGroupsAs;
        this.columns = Collections.unmodifiableList(Arrays.asList(builder.columns));
        this.inputURI = builder.inputURI;
        this.shortColumnTypeUsed = this.columnTypesToDetect.contains(ColumnType.SHORT);
        this.floatColumnTypeUsed = this.columnTypesToDetect.contains(ColumnType.FLOAT);
    }

    public boolean isShortColumnTypeUsed() {
        return this.shortColumnTypeUsed;
    }

    public boolean isFloatColumnTypeUsed() {
        return this.floatColumnTypeUsed;
    }

    public boolean isConvertInt96ToTimestamp() {
        return this.convertInt96ToTimestamp;
    }

    public UnnanotatedBinaryAs getUnnanotatedBinaryAs() {
        return this.unnanotatedBinaryAs;
    }

    public ManageGroupsAs getManageGroupsAs() {
        return this.manageGroupsAs;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public boolean hasColumn(String columnName) {
        if (this.columns.isEmpty()) {
            return true;
        }
        return this.columns.contains(columnName);
    }

    public URI getInputURI() {
        return this.inputURI;
    }

    public String getSanitizedinputPath() {
        return TablesawParquetReadOptions.sanitize(this.inputURI);
    }

    private static String sanitize(URI uri) {
        StringBuilder stringBuilder = new StringBuilder();
        if (uri.getScheme() != null) {
            stringBuilder.append(uri.getScheme()).append(":");
        }
        if (uri.getHost() != null) {
            stringBuilder.append("//").append(uri.getHost());
            if (uri.getPort() >= 0) {
                stringBuilder.append(":").append(Integer.toString(uri.getPort()));
            }
        }
        stringBuilder.append(uri.getPath());
        return stringBuilder.toString();
    }

    public static Builder builder(File file) {
        return new Builder(file.toURI()).tableName(file.getName());
    }

    public static Builder builder(String inputPath) {
        return TablesawParquetReadOptions.builder(URI.create(inputPath));
    }

    public static Builder builder(URL url) {
        try {
            return TablesawParquetReadOptions.builder(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Builder builder(URI uri) {
        return new Builder(uri).tableName(TablesawParquetReadOptions.sanitize(uri));
    }

    static Builder builderForStream() {
        return new Builder(null);
    }

    public static class Builder
    extends ReadOptions.Builder {
        private boolean convertInt96ToTimestamp = false;
        private UnnanotatedBinaryAs unnanotatedBinaryAs = UnnanotatedBinaryAs.STRING;
        private ManageGroupsAs manageGroupsAs = ManageGroupsAs.TEXT;
        private String[] columns = new String[0];
        private final URI inputURI;

        protected Builder(URI inputURI) {
            this.inputURI = inputURI;
        }

        public TablesawParquetReadOptions build() {
            return new TablesawParquetReadOptions(this);
        }

        public Builder header(boolean header) {
            super.header(header);
            return this;
        }

        public Builder tableName(String tableName) {
            super.tableName(tableName);
            return this;
        }

        public Builder sample(boolean sample) {
            LOG.warn("Sampling is not used in TablesawParquetReadOptions");
            super.sample(sample);
            return this;
        }

        @Deprecated
        public Builder dateFormat(String dateFormat) {
            super.dateFormat(dateFormat);
            return this;
        }

        @Deprecated
        public Builder timeFormat(String timeFormat) {
            super.timeFormat(timeFormat);
            return this;
        }

        @Deprecated
        public Builder dateTimeFormat(String dateTimeFormat) {
            super.dateTimeFormat(dateTimeFormat);
            return this;
        }

        public Builder dateFormat(DateTimeFormatter dateFormat) {
            super.dateFormat(dateFormat);
            return this;
        }

        public Builder timeFormat(DateTimeFormatter timeFormat) {
            super.timeFormat(timeFormat);
            return this;
        }

        public Builder dateTimeFormat(DateTimeFormatter dateTimeFormat) {
            super.dateTimeFormat(dateTimeFormat);
            return this;
        }

        public Builder maxCharsPerColumn(int maxCharsPerColumn) {
            super.maxCharsPerColumn(maxCharsPerColumn);
            return this;
        }

        public Builder locale(Locale locale) {
            super.locale(locale);
            return this;
        }

        public Builder missingValueIndicator(String ... missingValueIndicator) {
            LOG.warn("Missing value indicator is not used in TablesawParquetReadOptions");
            super.missingValueIndicator(missingValueIndicator);
            return this;
        }

        public Builder columnTypesToDetect(List<ColumnType> columnTypesToDetect) {
            super.columnTypesToDetect(columnTypesToDetect);
            return this;
        }

        public Builder minimizeColumnSizes() {
            super.minimizeColumnSizes();
            return this;
        }

        public Builder ignoreZeroDecimal(boolean ignoreZeroDecimal) {
            LOG.warn("ignoreZeroDecimal has no effect in TablesawParquetReadOptions");
            super.ignoreZeroDecimal(ignoreZeroDecimal);
            return this;
        }

        public Builder allowDuplicateColumnNames(Boolean allow) {
            super.allowDuplicateColumnNames(allow);
            return this;
        }

        public Builder skipRowsWithInvalidColumnCount(boolean skipRowsWithInvalidColumnCount) {
            super.skipRowsWithInvalidColumnCount(skipRowsWithInvalidColumnCount);
            return this;
        }

        public Builder columnTypes(ColumnType[] columnTypes) {
            super.columnTypes(columnTypes);
            return this;
        }

        public Builder columnTypes(Function<String, ColumnType> columnTypeFunction) {
            super.columnTypes(columnTypeFunction);
            return this;
        }

        public Builder columnTypesPartial(Function<String, Optional<ColumnType>> columnTypeFunction) {
            super.columnTypesPartial(columnTypeFunction);
            return this;
        }

        public Builder columnTypesPartial(Map<String, ColumnType> columnTypeByName) {
            super.columnTypesPartial(columnTypeByName);
            return this;
        }

        public Builder withConvertInt96ToTimestamp(boolean convertInt96ToTimestamp) {
            this.convertInt96ToTimestamp = convertInt96ToTimestamp;
            return this;
        }

        public Builder withUnnanotatedBinaryAs(UnnanotatedBinaryAs unnanotatedBinaryAs) {
            this.unnanotatedBinaryAs = unnanotatedBinaryAs;
            return this;
        }

        public Builder withManageGroupAs(ManageGroupsAs manageGroupsAs) {
            this.manageGroupsAs = manageGroupsAs;
            return this;
        }

        public Builder withOnlyTheseColumns(String ... columns) {
            this.columns = columns;
            return this;
        }
    }

    public static enum UnnanotatedBinaryAs {
        STRING,
        HEXSTRING,
        SKIP;

    }

    public static enum ManageGroupsAs {
        TEXT,
        SKIP,
        ERROR;

    }
}

