/*
 * Decompiled with CFR 0.152.
 */
package net.tlabs.tablesaw.parquet;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.tlabs.tablesaw.parquet.TableProxy;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Row;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;

public class TablesawWriteSupport
extends WriteSupport<Row> {
    private static final String WRITE_SUPPORT_NAME = "net.tlabs.tablesaw.parquet";
    private static final Map<ColumnType, PrimitiveType.PrimitiveTypeName> PRIMITIVE_MAPPING = new HashMap<ColumnType, PrimitiveType.PrimitiveTypeName>();
    private static final Map<ColumnType, LogicalTypeAnnotation> ANNOTATION_MAPPING;
    private final TableProxy proxy;
    private final MessageType schema;
    private final int nbfields;
    private RecordConsumer recordConsumer;

    public TablesawWriteSupport(Table table) {
        this.proxy = new TableProxy(table);
        this.schema = TablesawWriteSupport.internalCreateSchema(table);
        this.nbfields = this.schema.getFieldCount();
    }

    public static MessageType createSchema(Table table) {
        return TablesawWriteSupport.internalCreateSchema(table);
    }

    private static MessageType internalCreateSchema(Table table) {
        String tableName = table.name();
        return new MessageType(tableName == null ? "message" : tableName, table.columns().stream().map(TablesawWriteSupport::createType).collect(Collectors.toList()));
    }

    private static Type createType(Column<?> column) {
        ColumnType type = column.type();
        return (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PRIMITIVE_MAPPING.get(type)).as(ANNOTATION_MAPPING.get(type))).named(column.name());
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        return new WriteSupport.WriteContext(this.schema, new HashMap());
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.recordConsumer = recordConsumer;
    }

    public void write(Row row) {
        this.recordConsumer.startMessage();
        this.recordRow(row);
        this.recordConsumer.endMessage();
    }

    private void recordRow(Row row) {
        int rowNumber = row.getRowNumber();
        for (int colIndex = 0; colIndex < this.nbfields; ++colIndex) {
            Column<?> column = this.proxy.column(colIndex);
            if (column.isMissing(rowNumber)) continue;
            String fieldName = column.name();
            this.recordConsumer.startField(fieldName, colIndex);
            this.recordField(rowNumber, colIndex, column.type());
            this.recordConsumer.endField(fieldName, colIndex);
        }
    }

    private void recordField(int rowNumber, int colIndex, ColumnType type) {
        if (type == ColumnType.BOOLEAN) {
            this.recordConsumer.addBoolean(this.proxy.getBoolean(colIndex, rowNumber));
        } else if (type == ColumnType.SHORT) {
            this.recordConsumer.addInteger(this.proxy.getShort(colIndex, rowNumber));
        } else if (type == ColumnType.INTEGER) {
            this.recordConsumer.addInteger(this.proxy.getInt(colIndex, rowNumber));
        } else if (type == ColumnType.LONG) {
            this.recordConsumer.addLong(this.proxy.getLong(colIndex, rowNumber));
        } else if (type == ColumnType.FLOAT) {
            this.recordConsumer.addFloat(this.proxy.getFloat(colIndex, rowNumber));
        } else if (type == ColumnType.DOUBLE) {
            this.recordConsumer.addDouble(this.proxy.getDouble(colIndex, rowNumber));
        } else if (type == ColumnType.STRING) {
            this.recordConsumer.addBinary(Binary.fromString((String)this.proxy.getString(colIndex, rowNumber)));
        } else if (type == ColumnType.TEXT) {
            this.recordConsumer.addBinary(Binary.fromString((String)this.proxy.getText(colIndex, rowNumber)));
        } else if (type == ColumnType.LOCAL_DATE) {
            this.recordConsumer.addInteger(this.proxy.getDateToEpochDay(colIndex, rowNumber));
        } else if (type == ColumnType.LOCAL_TIME) {
            this.recordConsumer.addLong(this.proxy.getTimeToNanoOfDay(colIndex, rowNumber));
        } else if (type == ColumnType.LOCAL_DATE_TIME) {
            this.recordConsumer.addLong(this.proxy.getDateTimeToEpochMilli(colIndex, rowNumber));
        } else if (type == ColumnType.INSTANT) {
            this.recordConsumer.addLong(this.proxy.getInstantToEpochMilli(colIndex, rowNumber));
        } else {
            throw new UnsupportedOperationException("Unsupported ColumnType: " + type);
        }
    }

    public String getName() {
        return WRITE_SUPPORT_NAME;
    }

    static {
        PRIMITIVE_MAPPING.put((ColumnType)ColumnType.BOOLEAN, PrimitiveType.PrimitiveTypeName.BOOLEAN);
        PRIMITIVE_MAPPING.put((ColumnType)ColumnType.DOUBLE, PrimitiveType.PrimitiveTypeName.DOUBLE);
        PRIMITIVE_MAPPING.put((ColumnType)ColumnType.FLOAT, PrimitiveType.PrimitiveTypeName.FLOAT);
        PRIMITIVE_MAPPING.put((ColumnType)ColumnType.SHORT, PrimitiveType.PrimitiveTypeName.INT32);
        PRIMITIVE_MAPPING.put((ColumnType)ColumnType.INTEGER, PrimitiveType.PrimitiveTypeName.INT32);
        PRIMITIVE_MAPPING.put((ColumnType)ColumnType.LONG, PrimitiveType.PrimitiveTypeName.INT64);
        PRIMITIVE_MAPPING.put((ColumnType)ColumnType.INSTANT, PrimitiveType.PrimitiveTypeName.INT64);
        PRIMITIVE_MAPPING.put((ColumnType)ColumnType.LOCAL_DATE, PrimitiveType.PrimitiveTypeName.INT32);
        PRIMITIVE_MAPPING.put((ColumnType)ColumnType.LOCAL_TIME, PrimitiveType.PrimitiveTypeName.INT64);
        PRIMITIVE_MAPPING.put((ColumnType)ColumnType.LOCAL_DATE_TIME, PrimitiveType.PrimitiveTypeName.INT64);
        PRIMITIVE_MAPPING.put((ColumnType)ColumnType.STRING, PrimitiveType.PrimitiveTypeName.BINARY);
        PRIMITIVE_MAPPING.put((ColumnType)ColumnType.TEXT, PrimitiveType.PrimitiveTypeName.BINARY);
        ANNOTATION_MAPPING = new HashMap<ColumnType, LogicalTypeAnnotation>();
        ANNOTATION_MAPPING.put((ColumnType)ColumnType.SHORT, (LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)true));
        ANNOTATION_MAPPING.put((ColumnType)ColumnType.LOCAL_DATE, (LogicalTypeAnnotation)LogicalTypeAnnotation.dateType());
        ANNOTATION_MAPPING.put((ColumnType)ColumnType.LOCAL_TIME, (LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS));
        ANNOTATION_MAPPING.put((ColumnType)ColumnType.INSTANT, (LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS));
        ANNOTATION_MAPPING.put((ColumnType)ColumnType.LOCAL_DATE_TIME, (LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS));
        ANNOTATION_MAPPING.put((ColumnType)ColumnType.STRING, (LogicalTypeAnnotation)LogicalTypeAnnotation.stringType());
        ANNOTATION_MAPPING.put((ColumnType)ColumnType.TEXT, (LogicalTypeAnnotation)LogicalTypeAnnotation.stringType());
    }
}

