/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.tools.read;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.Type;
import org.apache.parquet.tools.read.SimpleListRecordConverter;
import org.apache.parquet.tools.read.SimpleMapRecordConverter;
import org.apache.parquet.tools.read.SimpleRecord;

public class SimpleRecordConverter
extends GroupConverter {
    private final Converter[] converters;
    private final String name;
    private final SimpleRecordConverter parent;
    protected SimpleRecord record;

    public SimpleRecordConverter(GroupType schema) {
        this(schema, null, null);
    }

    public SimpleRecordConverter(GroupType schema, String name, SimpleRecordConverter parent) {
        this.converters = new Converter[schema.getFieldCount()];
        this.parent = parent;
        this.name = name;
        int i = 0;
        for (Type field : schema.getFields()) {
            this.converters[i++] = this.createConverter(field);
        }
    }

    private Converter createConverter(final Type field) {
        LogicalTypeAnnotation ltype = field.getLogicalTypeAnnotation();
        if (field.isPrimitive()) {
            if (ltype != null) {
                return (Converter)ltype.accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<Converter>(){

                    public Optional<Converter> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation stringLogicalType) {
                        return Optional.of(new StringConverter(field.getName()));
                    }

                    public Optional<Converter> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType) {
                        int scale = decimalLogicalType.getScale();
                        return Optional.of(new DecimalConverter(field.getName(), scale));
                    }
                }).orElse(new SimplePrimitiveConverter(field.getName()));
            }
            return new SimplePrimitiveConverter(field.getName());
        }
        final GroupType groupType = field.asGroupType();
        if (ltype != null) {
            return (Converter)ltype.accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<Converter>(){

                public Optional<Converter> visit(LogicalTypeAnnotation.MapLogicalTypeAnnotation mapLogicalType) {
                    return Optional.of(new SimpleMapRecordConverter(groupType, field.getName(), SimpleRecordConverter.this));
                }

                public Optional<Converter> visit(LogicalTypeAnnotation.ListLogicalTypeAnnotation listLogicalType) {
                    return Optional.of(new SimpleListRecordConverter(groupType, field.getName(), SimpleRecordConverter.this));
                }
            }).orElse(new SimpleRecordConverter(groupType, field.getName(), this));
        }
        return new SimpleRecordConverter(groupType, field.getName(), this);
    }

    public Converter getConverter(int fieldIndex) {
        return this.converters[fieldIndex];
    }

    SimpleRecord getCurrentRecord() {
        return this.record;
    }

    public void start() {
        this.record = new SimpleRecord();
    }

    public void end() {
        if (this.parent != null) {
            this.parent.getCurrentRecord().add(this.name, this.record);
        }
    }

    private class DecimalConverter
    extends SimplePrimitiveConverter {
        private final int scale;

        public DecimalConverter(String name, int scale) {
            super(name);
            this.scale = scale;
        }

        @Override
        public void addBinary(Binary value) {
            SimpleRecordConverter.this.record.add(this.name, new BigDecimal(new BigInteger(value.getBytes()), this.scale));
        }

        @Override
        public void addInt(int value) {
            SimpleRecordConverter.this.record.add(this.name, BigDecimal.valueOf(value).movePointLeft(this.scale));
        }

        @Override
        public void addLong(long value) {
            SimpleRecordConverter.this.record.add(this.name, BigDecimal.valueOf(value).movePointLeft(this.scale));
        }
    }

    private class StringConverter
    extends SimplePrimitiveConverter {
        public StringConverter(String name) {
            super(name);
        }

        @Override
        public void addBinary(Binary value) {
            SimpleRecordConverter.this.record.add(this.name, value.toStringUsingUTF8());
        }
    }

    private class SimplePrimitiveConverter
    extends PrimitiveConverter {
        protected final String name;

        public SimplePrimitiveConverter(String name) {
            this.name = name;
        }

        public void addBinary(Binary value) {
            SimpleRecordConverter.this.record.add(this.name, value.getBytes());
        }

        public void addBoolean(boolean value) {
            SimpleRecordConverter.this.record.add(this.name, value);
        }

        public void addDouble(double value) {
            SimpleRecordConverter.this.record.add(this.name, value);
        }

        public void addFloat(float value) {
            SimpleRecordConverter.this.record.add(this.name, Float.valueOf(value));
        }

        public void addInt(int value) {
            SimpleRecordConverter.this.record.add(this.name, value);
        }

        public void addLong(long value) {
            SimpleRecordConverter.this.record.add(this.name, value);
        }
    }
}

