/*
 * Decompiled with CFR 0.152.
 */
package net.tlabs.tablesaw.parquet;

import java.io.File;
import java.io.IOException;
import net.tlabs.tablesaw.parquet.TablesawParquetReadOptions;
import net.tlabs.tablesaw.parquet.TablesawReadSupport;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.DataReader;
import tech.tablesaw.io.Source;

public class TablesawParquetReader
implements DataReader<TablesawParquetReadOptions> {
    private static final Logger LOG = LoggerFactory.getLogger(TablesawParquetReader.class);

    public Table read(Source source) throws IOException {
        File file = source.file();
        if (file != null) {
            return this.read(TablesawParquetReadOptions.builder(file).build());
        }
        throw new UnsupportedOperationException("Can only work with file based source, please use the read(TablesawParquetReadOptions) method for additional possibilities");
    }

    public Table read(TablesawParquetReadOptions options) throws IOException {
        long start = System.currentTimeMillis();
        String inputPath = options.getInputPath();
        Path path = new Path(inputPath);
        TablesawReadSupport readSupport = new TablesawReadSupport(options);
        try (ParquetReader reader = ParquetReader.builder((ReadSupport)readSupport, (Path)path).build();){
            int i = 0;
            while (reader.read() != null) {
                ++i;
            }
            long end = System.currentTimeMillis();
            LOG.debug("Finished reading {} rows from {} in {} ms", new Object[]{i, inputPath, end - start});
        }
        return readSupport.getTable();
    }
}

