/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.traces;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Map;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.plotly.Utils;
import tech.tablesaw.plotly.components.HoverLabel;
import tech.tablesaw.plotly.components.Marker;
import tech.tablesaw.plotly.traces.AbstractTrace;
import tech.tablesaw.plotly.traces.TraceBuilder;

public class Scatter3DTrace
extends AbstractTrace {
    private final double[] y;
    private final double[] x;
    private final double[] z;
    private final String[] text;
    private final Mode mode;
    private final HoverLabel hoverLabel;
    private final Marker marker;

    public static Scatter3DBuilder builder(double[] x, double[] y, double[] z) {
        return new Scatter3DBuilder(x, y, z);
    }

    public static Scatter3DBuilder builder(NumericColumn<? extends Number> x, NumericColumn<? extends Number> y, NumericColumn<? extends Number> z) {
        return new Scatter3DBuilder(x, y, z);
    }

    private Scatter3DTrace(Scatter3DBuilder builder) {
        super(builder);
        this.mode = builder.mode;
        this.y = builder.y;
        this.x = builder.x;
        this.z = builder.z;
        this.text = builder.text;
        this.hoverLabel = builder.hoverLabel;
        this.marker = builder.marker;
    }

    private Map<String, Object> getContext(int i) {
        Map<String, Object> context = super.getContext();
        context.put("variableName", "trace" + i);
        context.put("mode", (Object)this.mode);
        context.put("y", Utils.dataAsString(this.y));
        context.put("x", Utils.dataAsString(this.x));
        context.put("z", Utils.dataAsString(this.z));
        if (this.marker != null) {
            context.put("marker", this.marker);
        }
        if (this.hoverLabel != null) {
            context.put("hoverlabel", this.hoverLabel.asJSON());
        }
        if (this.text != null) {
            context.put("text", Utils.dataAsString(this.text));
        }
        return context;
    }

    @Override
    public String asJavascript(int i) {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("trace_template.html");
            Map<String, Object> context = this.getContext(i);
            compiledTemplate.evaluate((Writer)writer, context);
        }
        catch (PebbleException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return ((Object)writer).toString();
    }

    public static class Scatter3DBuilder
    extends TraceBuilder {
        private String type = "scatter3d";
        private Mode mode = Mode.MARKERS;
        private final double[] x;
        private final double[] y;
        private final double[] z;
        private String[] text;
        private Marker marker;

        private Scatter3DBuilder(double[] x, double[] y, double[] z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        private Scatter3DBuilder(NumericColumn<? extends Number> x, NumericColumn<? extends Number> y, NumericColumn<? extends Number> z) {
            this.x = x.asDoubleArray();
            this.y = y.asDoubleArray();
            this.z = z.asDoubleArray();
        }

        public Scatter3DBuilder mode(Mode mode) {
            this.mode = mode;
            return this;
        }

        public Scatter3DBuilder type(String kind) {
            this.type = kind;
            return this;
        }

        public Scatter3DBuilder text(String[] text) {
            this.text = text;
            return this;
        }

        public Scatter3DTrace build() {
            return new Scatter3DTrace(this);
        }

        @Override
        protected String getType() {
            return this.type;
        }

        @Override
        public Scatter3DBuilder name(String name) {
            return (Scatter3DBuilder)super.name(name);
        }

        @Override
        public Scatter3DBuilder opacity(double n) {
            Preconditions.checkArgument((n >= 0.0 && n <= 1.0 ? 1 : 0) != 0);
            return (Scatter3DBuilder)super.opacity(n);
        }

        @Override
        public Scatter3DBuilder legendGroup(String group) {
            return (Scatter3DBuilder)super.legendGroup(group);
        }

        public Scatter3DBuilder marker(Marker marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Scatter3DBuilder showLegend(boolean showLegend) {
            return (Scatter3DBuilder)super.showLegend(showLegend);
        }

        @Override
        public Scatter3DBuilder visible(AbstractTrace.Visibility visibility) {
            return (Scatter3DBuilder)super.visible(visibility);
        }

        @Override
        public Scatter3DBuilder hoverLabel(HoverLabel hoverLabel) {
            return (Scatter3DBuilder)super.hoverLabel(hoverLabel);
        }
    }

    public static enum Mode {
        LINE("line"),
        MARKERS("markers"),
        LINE_AND_MARKERS("line + markers"),
        LINE_AND_TEXT("line + text"),
        TEXT_AND_MARKERS("text + text"),
        LINE_TEXT_AND_MARKERS("line + text + markers"),
        TEXT("text"),
        NONE("none");

        final String value;

        private Mode(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }
}

