/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.traces;

import com.fasterxml.jackson.annotation.JsonValue;
import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Map;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.plotly.Utils;
import tech.tablesaw.plotly.components.Marker;
import tech.tablesaw.plotly.traces.AbstractTrace;
import tech.tablesaw.plotly.traces.TraceBuilder;

public class HistogramTrace
extends AbstractTrace {
    private final Object[] x;
    private final Object[] y;
    private final double opacity;
    private final int nBinsX;
    private final int nBinsY;
    private final boolean autoBinX;
    private final boolean autoBinY;
    private final Marker marker;
    private final HistNorm histNorm;
    private final HistFunc histFunc;

    public static HistogramBuilder builder(double[] values) {
        return new HistogramBuilder(values);
    }

    public static HistogramBuilder builder(NumericColumn<? extends Number> values) {
        return new HistogramBuilder(values.asDoubleArray());
    }

    public static HistogramBuilder builder(Column<?> xValues, NumericColumn<? extends Number> values) {
        return new HistogramBuilder(xValues.asObjectArray(), values.asDoubleArray());
    }

    private HistogramTrace(HistogramBuilder builder) {
        super(builder);
        if (builder.horizontal) {
            this.x = builder.y;
            this.y = builder.x;
        } else {
            this.x = builder.x;
            this.y = builder.y;
        }
        this.histNorm = builder.histNorm;
        this.histFunc = builder.histFunc;
        this.nBinsX = builder.nBinsX;
        this.nBinsY = builder.nBinsY;
        this.autoBinX = builder.autoBinX;
        this.autoBinY = builder.autoBinY;
        this.opacity = builder.opacity;
        this.marker = builder.marker;
    }

    @Override
    public String asJavascript(int i) {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("trace_template.html");
            compiledTemplate.evaluate((Writer)writer, this.getContext(i));
        }
        catch (PebbleException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return ((Object)writer).toString();
    }

    private Map<String, Object> getContext(int i) {
        Map<String, Object> context = super.getContext();
        context.put("variableName", "trace" + i);
        if (this.x != null) {
            context.put("x", Utils.dataAsString(this.x));
        }
        if (this.y != null) {
            context.put("y", Utils.dataAsString(this.y));
        }
        context.put("opacity", this.opacity);
        context.put("nBinsX", this.nBinsX);
        context.put("nBinsY", this.nBinsY);
        context.put("autoBinX", this.autoBinX);
        context.put("autoBinY", this.autoBinY);
        context.put("histnorm", (Object)this.histNorm);
        context.put("histfunc", (Object)this.histFunc);
        if (this.marker != null) {
            context.put("marker", this.marker);
        }
        return context;
    }

    private static Object[] doublesToObjects(double[] doubles) {
        Object[] objects = new Object[doubles.length];
        for (int i = 0; i < doubles.length; ++i) {
            objects[i] = doubles[i];
        }
        return objects;
    }

    public static class HistogramBuilder
    extends TraceBuilder {
        private final String type = "histogram";
        private int nBinsX;
        private int nBinsY;
        private boolean autoBinX;
        private boolean autoBinY;
        private boolean horizontal = false;
        private Object[] x;
        private Object[] y;
        private Marker marker;
        private HistNorm histNorm = HistNorm.NONE;
        private HistFunc histFunc = HistFunc.COUNT;

        private HistogramBuilder(double[] values) {
            this.x = HistogramTrace.doublesToObjects(values);
        }

        private HistogramBuilder(Object[] xValues, double[] yValues) {
            this.x = xValues;
            this.y = HistogramTrace.doublesToObjects(yValues);
        }

        public HistogramBuilder nBinsX(int bins) {
            this.nBinsX = bins;
            return this;
        }

        public HistogramBuilder nBinsY(int bins) {
            this.nBinsY = bins;
            return this;
        }

        public HistogramBuilder autoBinX(boolean autoBinX) {
            this.autoBinX = autoBinX;
            return this;
        }

        public HistogramBuilder autoBinY(boolean autoBinY) {
            this.autoBinY = autoBinY;
            return this;
        }

        public HistogramBuilder marker(Marker marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public HistogramBuilder opacity(double opacity) {
            super.opacity(opacity);
            return this;
        }

        public HistogramBuilder horizontal(boolean horizontal) {
            this.horizontal = horizontal;
            return this;
        }

        @Override
        public HistogramBuilder showLegend(boolean b) {
            super.showLegend(b);
            return this;
        }

        public HistogramBuilder histNorm(HistNorm histNorm) {
            this.histNorm = histNorm;
            return this;
        }

        public HistogramBuilder histFunc(HistFunc histFunc) {
            this.histFunc = histFunc;
            return this;
        }

        @Override
        public HistogramBuilder name(String name) {
            super.name(name);
            return this;
        }

        @Override
        public HistogramBuilder xAxis(String xAxis) {
            super.xAxis(xAxis);
            return this;
        }

        @Override
        public HistogramBuilder yAxis(String yAxis) {
            super.yAxis(yAxis);
            return this;
        }

        public HistogramBuilder y(double[] y) {
            this.y = HistogramTrace.doublesToObjects(y);
            return this;
        }

        public HistogramBuilder y(NumericColumn<? extends Number> values) {
            this.y = values.asObjectArray();
            return this;
        }

        public HistogramTrace build() {
            return new HistogramTrace(this);
        }

        @Override
        protected String getType() {
            return "histogram";
        }
    }

    public static enum HistNorm {
        NONE(""),
        PERCENT("percent"),
        PROBABILITY("probability"),
        DENSITY("density"),
        PROBABILITY_DENSITY("probability density");

        private final String value;

        private HistNorm(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }

    public static enum HistFunc {
        COUNT("count"),
        SUM("sum"),
        AVG("avg"),
        MIN("min"),
        MAX("max");

        private final String value;

        private HistFunc(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }
}

