/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.traces;

import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Map;
import tech.tablesaw.plotly.Utils;
import tech.tablesaw.plotly.traces.AbstractTrace;
import tech.tablesaw.plotly.traces.TraceBuilder;

public class ContourTrace
extends AbstractTrace {
    private final Object[] x;
    private final Object[] y;
    private final double[][] z;

    public ContourTrace(ContourBuilder builder) {
        super(builder);
        this.x = builder.x;
        this.y = builder.y;
        this.z = builder.z;
    }

    @Override
    public String asJavascript(int i) {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("trace_template.html");
            compiledTemplate.evaluate((Writer)writer, this.getContext());
        }
        catch (PebbleException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return ((Object)writer).toString();
    }

    @Override
    protected Map<String, Object> getContext() {
        Map<String, Object> context = super.getContext();
        context.put("variableName", "trace0");
        context.put("x", Utils.dataAsString(this.x));
        context.put("y", Utils.dataAsString(this.y));
        context.put("z", Utils.dataAsString(this.z));
        return context;
    }

    public static ContourBuilder builder(Object[] x, Object[] y, double[][] z) {
        return new ContourBuilder(x, y, z);
    }

    public static class ContourBuilder
    extends TraceBuilder {
        private static final String type = "contour";
        private final Object[] x;
        private final Object[] y;
        private final double[][] z;

        ContourBuilder(Object[] x, Object[] y, double[][] z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public ContourBuilder xAxis(String xAxis) {
            super.xAxis(xAxis);
            return this;
        }

        @Override
        public ContourBuilder yAxis(String yAxis) {
            super.yAxis(yAxis);
            return this;
        }

        public ContourTrace build() {
            return new ContourTrace(this);
        }

        @Override
        protected String getType() {
            return type;
        }
    }
}

