/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.traces;

import com.fasterxml.jackson.annotation.JsonValue;
import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.Map;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.plotly.Utils;
import tech.tablesaw.plotly.components.Marker;
import tech.tablesaw.plotly.traces.AbstractTrace;
import tech.tablesaw.plotly.traces.TraceBuilder;

public class BarTrace
extends AbstractTrace {
    private final Object[] x;
    private final double[] y;
    private final Orientation orientation;
    private final Marker marker;

    private BarTrace(BarBuilder builder) {
        super(builder);
        this.orientation = builder.orientation;
        this.x = builder.x;
        this.y = builder.y;
        this.marker = builder.marker;
    }

    public static BarBuilder builder(Object[] x, double[] y) {
        return new BarBuilder(x, y);
    }

    public static BarBuilder builder(CategoricalColumn<?> x, NumericColumn<? extends Number> y) {
        return new BarBuilder(x, y);
    }

    @Override
    public String asJavascript(int i) {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.engine.getTemplate("trace_template.html");
            compiledTemplate.evaluate((Writer)writer, this.getContext(i));
        }
        catch (PebbleException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return ((Object)writer).toString();
    }

    private Map<String, Object> getContext(int i) {
        Map<String, Object> context = super.getContext();
        context.put("variableName", "trace" + i);
        if (this.orientation == Orientation.HORIZONTAL) {
            context.put("x", Utils.dataAsString(this.y));
            context.put("y", Utils.dataAsString(this.x));
        } else {
            context.put("y", Utils.dataAsString(this.y));
            context.put("x", Utils.dataAsString(this.x));
        }
        context.put("orientation", this.orientation.value);
        if (this.marker != null) {
            context.put("marker", this.marker);
        }
        return context;
    }

    public static class BarBuilder
    extends TraceBuilder {
        private final String type = "bar";
        private final Object[] x;
        private final double[] y;
        private Orientation orientation = Orientation.VERTICAL;
        private Marker marker;

        BarBuilder(Object[] x, double[] y) {
            this.x = x;
            this.y = y;
        }

        BarBuilder(CategoricalColumn<?> x, NumericColumn<? extends Number> y) {
            this.x = TraceBuilder.columnToStringArray(x);
            this.y = y.asDoubleArray();
        }

        public BarTrace build() {
            return new BarTrace(this);
        }

        public BarBuilder orientation(Orientation orientation) {
            this.orientation = orientation;
            return this;
        }

        @Override
        public BarBuilder opacity(double opacity) {
            super.opacity(opacity);
            return this;
        }

        @Override
        public BarBuilder name(String name) {
            super.name(name);
            return this;
        }

        @Override
        public BarBuilder showLegend(boolean b) {
            super.showLegend(b);
            return this;
        }

        public BarBuilder marker(Marker marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public BarBuilder xAxis(String xAxis) {
            super.xAxis(xAxis);
            return this;
        }

        @Override
        public BarBuilder yAxis(String yAxis) {
            super.yAxis(yAxis);
            return this;
        }

        @Override
        protected String getType() {
            return "bar";
        }
    }

    public static enum Orientation {
        VERTICAL("v"),
        HORIZONTAL("h");

        private final String value;

        private Orientation(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }
}

