/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components;

import io.pebbletemplates.pebble.PebbleEngine;
import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.loader.ClasspathLoader;
import io.pebbletemplates.pebble.loader.DelegatingLoader;
import io.pebbletemplates.pebble.loader.FileLoader;
import io.pebbletemplates.pebble.loader.Loader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class TemplateUtils {
    private static Collection<String> templateLocations = new ArrayList<String>();

    private TemplateUtils() {
    }

    public static void setTemplateLocations(String ... locations) {
        templateLocations = Arrays.asList(locations);
    }

    public static PebbleEngine getNewEngine() {
        PebbleEngine engine;
        try {
            ClasspathLoader loader = new ClasspathLoader();
            if (templateLocations != null && !templateLocations.isEmpty()) {
                ArrayList<Object> loaders = new ArrayList<Object>();
                for (String templateLocation : templateLocations) {
                    FileLoader fileLoader = new FileLoader();
                    fileLoader.setPrefix(templateLocation);
                    loaders.add(fileLoader);
                }
                loaders.add(loader);
                loader = new DelegatingLoader(loaders);
            }
            engine = new PebbleEngine.Builder().loader((Loader)loader).strictVariables(false).build();
        }
        catch (PebbleException e) {
            throw new IllegalStateException(e);
        }
        return engine;
    }
}

