/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.pebbletemplates.pebble.PebbleEngine;
import io.pebbletemplates.pebble.error.PebbleException;
import io.pebbletemplates.pebble.template.PebbleTemplate;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import tech.tablesaw.plotly.components.Component;
import tech.tablesaw.plotly.components.TemplateUtils;

public abstract class TemplateComponent
extends Component {
    @JsonIgnore
    private final PebbleEngine engine = TemplateUtils.getNewEngine();

    protected PebbleEngine getEngine() {
        return this.engine;
    }

    public abstract String asJavascript();

    protected String asJavascript(String filename) {
        StringWriter writer = new StringWriter();
        try {
            PebbleTemplate compiledTemplate = this.getEngine().getTemplate(filename);
            compiledTemplate.evaluate((Writer)writer, this.getJSONContext());
        }
        catch (PebbleException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return ((Object)writer).toString();
    }
}

