/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.plotly.components.JSONComponent;

public class Line
extends JSONComponent {
    private final String color;
    private final double width;
    private final double smoothing;
    private final Shape shape;
    private final Dash dash;
    private final boolean simplify;

    private Line(LineBuilder builder) {
        this.color = builder.color;
        this.shape = builder.shape;
        this.smoothing = builder.smoothing;
        this.dash = builder.dash;
        this.simplify = builder.simplify;
        this.width = builder.width;
    }

    @Override
    protected Map<String, Object> getJSONContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("color", this.color);
        context.put("width", this.width);
        context.put("shape", (Object)this.shape);
        context.put("smoothing", this.smoothing);
        context.put("dash", (Object)this.dash);
        context.put("simplify", this.simplify);
        return context;
    }

    public static LineBuilder builder() {
        return new LineBuilder();
    }

    public static class LineBuilder {
        private String color;
        private double width = 2.0;
        private double smoothing = 1.0;
        private Shape shape = Shape.LINEAR;
        private Dash dash = Dash.SOLID;
        private boolean simplify = true;

        public LineBuilder color(String color) {
            this.color = color;
            return this;
        }

        public LineBuilder width(double width) {
            Preconditions.checkArgument((width >= 0.0 ? 1 : 0) != 0, (Object)"Line width must be >= 0.");
            this.width = width;
            return this;
        }

        public LineBuilder smoothing(double smoothing) {
            Preconditions.checkArgument((smoothing >= 0.0 && smoothing <= 1.3 ? 1 : 0) != 0, (Object)"Smoothing parameter must be between 0 and 1.3, inclusive.");
            this.smoothing = smoothing;
            return this;
        }

        public LineBuilder dash(Dash dash) {
            this.dash = dash;
            return this;
        }

        public LineBuilder simplify(boolean b) {
            this.simplify = b;
            return this;
        }

        public LineBuilder shape(Shape shape) {
            this.shape = shape;
            return this;
        }

        public Line build() {
            return new Line(this);
        }
    }

    public static enum Shape {
        LINEAR("linear"),
        SPLINE("spline"),
        HV("hv"),
        VH("vh"),
        HVH("hvh"),
        VHV("vhv");

        private final String value;

        private Shape(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }

    public static enum Dash {
        SOLID("solid"),
        DASH("dash"),
        DOT("dot"),
        LONG_DASH("longdash"),
        LONG_DASH_DOT("longdashdot"),
        DASH_DOT("dashdot");

        private final String value;

        private Dash(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }
}

