/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components;

import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.plotly.components.Font;
import tech.tablesaw.plotly.components.JSONComponent;

public class HoverLabel
extends JSONComponent {
    private final String bgColor;
    private final String borderColor;
    private final Font font;
    private final int nameLength;

    HoverLabel(HoverLabelBuilder builder) {
        this.bgColor = builder.bgColor;
        this.borderColor = builder.borderColor;
        this.font = builder.font;
        this.nameLength = builder.nameLength;
    }

    public static HoverLabelBuilder builder() {
        return new HoverLabelBuilder();
    }

    @Override
    protected Map<String, Object> getJSONContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("bgcolor", this.bgColor);
        context.put("bordercolor", this.borderColor);
        context.put("namelength", this.nameLength);
        context.put("font", this.font.getJSONContext());
        return context;
    }

    public static class HoverLabelBuilder {
        private String bgColor = "";
        private String borderColor = "";
        private Font font;
        private int nameLength = 15;

        public HoverLabel build() {
            return new HoverLabel(this);
        }

        public HoverLabelBuilder nameLength(int nameLength) {
            this.nameLength = nameLength;
            return this;
        }

        public HoverLabelBuilder font(Font font) {
            this.font = font;
            return this;
        }

        public HoverLabelBuilder borderColor(String borderColor) {
            this.borderColor = borderColor;
            return this;
        }

        public HoverLabelBuilder bgColor(String bgColor) {
            this.bgColor = bgColor;
            return this;
        }
    }
}

