/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import tech.tablesaw.plotly.components.JSONComponent;

public class Font
extends JSONComponent {
    private final Family family;
    private final int size;
    private final String color;

    private Font(FontBuilder builder) {
        this.color = builder.color;
        this.family = builder.fontFamily;
        this.size = builder.size;
    }

    public static FontBuilder builder() {
        return new FontBuilder();
    }

    @Override
    protected Map<String, Object> getJSONContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("size", this.size);
        context.put("family", (Object)this.family);
        context.put("color", this.color);
        return context;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Font font = (Font)o;
        return this.size == font.size && this.family == font.family && Objects.equals(this.color, font.color);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.family, this.size, this.color});
    }

    public static class FontBuilder {
        private Family fontFamily = Family.OPEN_SANS;
        private int size = 12;
        private String color = "#444";

        private FontBuilder() {
        }

        public FontBuilder size(int size) {
            Preconditions.checkArgument((size >= 1 ? 1 : 0) != 0);
            this.size = size;
            return this;
        }

        public FontBuilder color(String color) {
            this.color = color;
            return this;
        }

        public FontBuilder family(Family family) {
            this.fontFamily = family;
            return this;
        }

        public Font build() {
            return new Font(this);
        }
    }

    public static enum Family {
        OPEN_SANS("Open Sans"),
        VERDANA("verdana"),
        ARIAL("arial"),
        SANS_SERIF("sans-serif");

        private final String value;

        private Family(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }
}

