/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.plotly.components.TemplateComponent;

public class Config
extends TemplateComponent {
    private final ModeBarDisplay displayModeBar;
    private final Boolean responsive;
    private final Boolean displayLogo;

    private Config(Builder builder) {
        this.displayModeBar = builder.displayModeBar;
        this.responsive = builder.responsive;
        this.displayLogo = builder.displayLogo;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String asJavascript() {
        return "var config = " + this.asJSON() + ";" + System.lineSeparator();
    }

    @Override
    protected Map<String, Object> getJSONContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (this.displayModeBar == ModeBarDisplay.NEVER) {
            context.put("displayModeBar", false);
        } else if (this.displayModeBar == ModeBarDisplay.ALWAYS) {
            context.put("displayModeBar", true);
        }
        context.put("responsive", this.responsive);
        context.put("displaylogo", this.displayLogo);
        return context;
    }

    public static class Builder {
        ModeBarDisplay displayModeBar;
        Boolean responsive;
        Boolean displayLogo;

        private Builder() {
        }

        public Builder displayModeBar(ModeBarDisplay displayModeBar) {
            this.displayModeBar = displayModeBar;
            return this;
        }

        public Builder responsive(boolean responsive) {
            this.responsive = responsive;
            return this;
        }

        public Builder displayLogo(boolean displayLogo) {
            this.displayLogo = displayLogo;
            return this;
        }

        public Config build() {
            return new Config(this);
        }
    }

    public static enum ModeBarDisplay {
        ALWAYS("true"),
        NEVER("false"),
        ON_HOVER("on-hover");

        private final String value;

        private ModeBarDisplay(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }
}

