/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.components;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.plotly.components.JSONComponent;
import tech.tablesaw.plotly.components.TickSettings;

public class ColorBar
extends JSONComponent {
    private static final ThicknessMode DEFAULT_THICKNESS_MODE = ThicknessMode.PIXELS;
    private static final double DEFAULT_THICKNESS = 30.0;
    private static final LenMode DEFAULT_LEN_MODE = LenMode.FRACTION;
    private static final double DEFAULT_LEN = 1.0;
    private static final double DEFAULT_X = 1.02;
    private static final double DEFAULT_Y = 0.5;
    private static final int DEFAULT_X_PAD = 10;
    private static final int DEFAULT_Y_PAD = 10;
    private static final Xanchor DEFAULT_X_ANCHOR = Xanchor.LEFT;
    private static final Yanchor DEFAULT_Y_ANCHOR = Yanchor.MIDDLE;
    private static final String DEFAULT_OUTLINE_COLOR = "444";
    private static final String DEFAULT_BORDER_COLOR = "444";
    private static final int DEFAULT_BORDER_WIDTH = 1;
    private static final int DEFAULT_OUTLINE_WIDTH = 0;
    private static final String DEFAULT_BG_COLOR = "rgba(0,0,0,0)";
    private final ThicknessMode thicknessMode;
    private final double thickness;
    private final LenMode lenMode;
    private final double len;
    private final double x;
    private final int xPad;
    private final int yPad;
    private final double y;
    private final Xanchor xAnchor;
    private final Yanchor yAnchor;
    private final String outlineColor;
    private final int outlineWidth;
    private final String borderColor;
    private final int borderWidth;
    private final String bgColor;
    private final TickSettings tickSettings;

    private ColorBar(ColorBarBuilder builder) {
        this.thicknessMode = builder.thicknessMode;
        this.lenMode = builder.lenMode;
        this.thickness = builder.thickness;
        this.len = builder.len;
        this.x = builder.x;
        this.y = builder.y;
        this.xPad = builder.xPad;
        this.yPad = builder.yPad;
        this.xAnchor = builder.xAnchor;
        this.yAnchor = builder.yAnchor;
        this.outlineColor = builder.outlineColor;
        this.borderColor = builder.borderColor;
        this.bgColor = builder.bgColor;
        this.borderWidth = builder.borderWidth;
        this.outlineWidth = builder.outlineWidth;
        this.tickSettings = builder.tickSettings;
    }

    @Override
    protected Map<String, Object> getJSONContext() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (!this.thicknessMode.equals((Object)DEFAULT_THICKNESS_MODE)) {
            context.put("thicknessMode", (Object)this.thicknessMode);
        }
        if (!this.lenMode.equals((Object)DEFAULT_LEN_MODE)) {
            context.put("lenMode", (Object)this.lenMode);
        }
        if (this.len != 1.0) {
            context.put("len", this.len);
        }
        if (this.thickness != 30.0) {
            context.put("thickness", this.thickness);
        }
        if (this.x != 1.02) {
            context.put("x", this.x);
        }
        if (this.y != 0.5) {
            context.put("y", this.y);
        }
        if (this.xPad != 10) {
            context.put("xPad", this.xPad);
        }
        if (this.yPad != 10) {
            context.put("yPad", this.yPad);
        }
        if (this.borderWidth != 1) {
            context.put("borderWidth", this.borderWidth);
        }
        if (this.outlineWidth != 0) {
            context.put("outlineWidth", this.outlineWidth);
        }
        if (!this.xAnchor.equals((Object)DEFAULT_X_ANCHOR)) {
            context.put("xAnchor", (Object)this.xAnchor);
        }
        if (!this.yAnchor.equals((Object)DEFAULT_Y_ANCHOR)) {
            context.put("yAnchor", (Object)this.yAnchor);
        }
        if (!this.outlineColor.equals("444")) {
            context.put("outlineColor", this.outlineColor);
        }
        if (!this.borderColor.equals("444")) {
            context.put("borderColor", this.borderColor);
        }
        if (!this.bgColor.equals(DEFAULT_BG_COLOR)) {
            context.put("bgColor", this.bgColor);
        }
        if (this.tickSettings != null) {
            this.tickSettings.updateContext(context);
        }
        return context;
    }

    public static ColorBarBuilder builder() {
        return new ColorBarBuilder();
    }

    static /* synthetic */ ThicknessMode access$1600() {
        return DEFAULT_THICKNESS_MODE;
    }

    static /* synthetic */ LenMode access$1700() {
        return DEFAULT_LEN_MODE;
    }

    static /* synthetic */ Xanchor access$1800() {
        return DEFAULT_X_ANCHOR;
    }

    static /* synthetic */ Yanchor access$1900() {
        return DEFAULT_Y_ANCHOR;
    }

    public static class ColorBarBuilder {
        private ThicknessMode thicknessMode = ColorBar.access$1600();
        private double thickness = 30.0;
        private LenMode lenMode = ColorBar.access$1700();
        private double len = 1.0;
        private double x = 1.02;
        private int xPad = 10;
        private int yPad = 10;
        private double y = 0.5;
        private Xanchor xAnchor = ColorBar.access$1800();
        private Yanchor yAnchor = ColorBar.access$1900();
        private String outlineColor = "444";
        private int outlineWidth = 0;
        private String borderColor = "444";
        private int borderWidth = 1;
        private String bgColor = "rgba(0,0,0,0)";
        private TickSettings tickSettings;

        public ColorBarBuilder thickness(double thickness) {
            Preconditions.checkArgument((thickness >= 0.0 ? 1 : 0) != 0);
            this.thickness = thickness;
            return this;
        }

        public ColorBarBuilder len(double len) {
            Preconditions.checkArgument((len >= 0.0 ? 1 : 0) != 0);
            this.len = len;
            return this;
        }

        public ColorBarBuilder lenMode(LenMode lenMode) {
            this.lenMode = lenMode;
            return this;
        }

        public ColorBarBuilder thicknessMode(ThicknessMode mode) {
            this.thicknessMode = mode;
            return this;
        }

        public ColorBarBuilder x(double x) {
            Preconditions.checkArgument((x >= -2.0 && x <= 3.0 ? 1 : 0) != 0);
            this.x = x;
            return this;
        }

        public ColorBarBuilder y(double y) {
            Preconditions.checkArgument((y >= -2.0 && y <= 3.0 ? 1 : 0) != 0);
            this.y = y;
            return this;
        }

        public ColorBarBuilder xAnchor(Xanchor xAnchor) {
            this.xAnchor = xAnchor;
            return this;
        }

        public ColorBarBuilder yAnchor(Yanchor yAnchor) {
            this.yAnchor = yAnchor;
            return this;
        }

        public ColorBarBuilder yPad(int yPad) {
            Preconditions.checkArgument((yPad >= 0 ? 1 : 0) != 0);
            this.yPad = yPad;
            return this;
        }

        public ColorBarBuilder xPad(int xPad) {
            Preconditions.checkArgument((this.y >= 0.0 ? 1 : 0) != 0);
            this.xPad = xPad;
            return this;
        }

        public ColorBarBuilder outlineColor(String outlineColor) {
            this.outlineColor = outlineColor;
            return this;
        }

        public ColorBarBuilder borderColor(String color) {
            this.borderColor = color;
            return this;
        }

        public ColorBarBuilder bgColor(String color) {
            this.bgColor = color;
            return this;
        }

        public ColorBarBuilder borderWidth(int width) {
            Preconditions.checkArgument((width >= 0 ? 1 : 0) != 0);
            this.borderWidth = width;
            return this;
        }

        public ColorBarBuilder outlineWidth(int width) {
            Preconditions.checkArgument((width >= 0 ? 1 : 0) != 0);
            this.outlineWidth = width;
            return this;
        }

        public ColorBarBuilder tickSettings(TickSettings tickSettings) {
            this.tickSettings = tickSettings;
            return this;
        }

        public ColorBar build() {
            return new ColorBar(this);
        }
    }

    public static enum Yanchor {
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        private final String value;

        private Yanchor(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }

    public static enum Xanchor {
        LEFT("left"),
        CENTER("center"),
        RIGHT("right");

        private final String value;

        private Xanchor(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }

    public static enum LenMode {
        FRACTION("fraction"),
        PIXELS("pixels");

        private final String value;

        private LenMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }

    public static enum ThicknessMode {
        FRACTION("fraction"),
        PIXELS("pixels");

        private final String value;

        private ThicknessMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }
    }
}

