/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.plotly.api;

import java.util.List;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.InstantColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.plotly.components.Figure;
import tech.tablesaw.plotly.components.Layout;
import tech.tablesaw.plotly.traces.ScatterTrace;
import tech.tablesaw.plotly.traces.Trace;
import tech.tablesaw.table.TableSliceGroup;

public class TimeSeriesPlot {
    public static Figure create(String title, Table table, String dateColX, String yCol, String groupCol) {
        TableSliceGroup tables = table.splitOn(new CategoricalColumn[]{table.categoricalColumn(groupCol)});
        Layout layout = Layout.builder(title, dateColX, yCol).build();
        Trace[] traces = new ScatterTrace[tables.size()];
        for (int i = 0; i < tables.size(); ++i) {
            List tableList = tables.asTableList();
            Table t = ((Table)tableList.get(i)).sortOn(new String[]{dateColX});
            traces[i] = ScatterTrace.builder(t.dateColumn(dateColX), t.numberColumn(yCol)).showLegend(true).name(((Table)tableList.get(i)).name()).mode(ScatterTrace.Mode.LINE).build();
        }
        return new Figure(layout, traces);
    }

    public static Figure create(String title, Table table, String dateColXName, String yColName) {
        Layout layout = Layout.builder(title, dateColXName, yColName).build();
        ScatterTrace trace = ScatterTrace.builder(table.column(dateColXName), table.numberColumn(yColName)).mode(ScatterTrace.Mode.LINE).build();
        return new Figure(layout, trace);
    }

    public static Figure create(String title, String xTitle, DateColumn xCol, String yTitle, NumericColumn<?> yCol) {
        Layout layout = Layout.builder(title, xTitle, yTitle).build();
        ScatterTrace trace = ScatterTrace.builder(xCol, yCol).mode(ScatterTrace.Mode.LINE).build();
        return new Figure(layout, trace);
    }

    public static Figure create(String title, String xTitle, DateTimeColumn xCol, String yTitle, NumericColumn<?> yCol) {
        Layout layout = Layout.builder(title, xTitle, yTitle).build();
        ScatterTrace trace = ScatterTrace.builder(xCol, yCol).mode(ScatterTrace.Mode.LINE).build();
        return new Figure(layout, trace);
    }

    public static Figure create(String title, String xTitle, InstantColumn xCol, String yTitle, NumericColumn<?> yCol) {
        Layout layout = Layout.builder(title, xTitle, yTitle).build();
        ScatterTrace trace = ScatterTrace.builder(xCol, yCol).mode(ScatterTrace.Mode.LINE).build();
        return new Figure(layout, trace);
    }

    public static Figure createDateTimeSeries(String title, Table table, String dateTimeColumnName, String numberColumnName) {
        DateTimeColumn xCol = table.dateTimeColumn(dateTimeColumnName);
        NumericColumn yCol = table.numberColumn(numberColumnName);
        Layout layout = Layout.builder(title, xCol.name(), yCol.name()).build();
        ScatterTrace trace = ScatterTrace.builder(xCol, yCol).mode(ScatterTrace.Mode.LINE).build();
        return new Figure(layout, trace);
    }
}

