package tech.tablesaw.plotly.components.threeD;

import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.plotly.components.Axis;
import tech.tablesaw.plotly.components.JSONComponent;

public class Scene extends JSONComponent {

  private final Axis xAxis;

  private final Axis yAxis;

  private final Axis zAxis;

  private final Camera camera;

  private Scene(SceneBuilder builder) {
    this.xAxis = builder.xAxis;
    this.yAxis = builder.yAxis;
    this.zAxis = builder.zAxis;
    this.camera = builder.camera;
  }

  @Override
  protected Map<String, Object> getJSONContext() {
    Map<String, Object> context = new HashMap<>();
    if (xAxis != null) {
      context.put("xAxis", xAxis);
    }
    if (yAxis != null) {
      context.put("yAxis", yAxis);
    }
    if (zAxis != null) {
      context.put("zAxis", zAxis);
    }
    if (camera != null) {
      context.put("camera", camera);
    }
    return context;
  }

  public static Scene.SceneBuilder sceneBuilder() {
    return new Scene.SceneBuilder();
  }

  public static class SceneBuilder {

    private Axis xAxis;

    private Axis yAxis;

    private Axis zAxis;

    private Camera camera;

    public SceneBuilder xAxis(Axis axis) {
      this.xAxis = axis;
      return this;
    }

    public SceneBuilder yAxis(Axis axis) {
      this.yAxis = axis;
      return this;
    }

    public SceneBuilder zAxis(Axis axis) {
      this.zAxis = axis;
      return this;
    }

    public SceneBuilder camera(Camera camera) {
      this.camera = camera;
      return this;
    }

    public Scene build() {
      return new Scene(this);
    }
  }
}
