package tech.tablesaw.plotly.components.threeD;

import java.util.HashMap;
import java.util.Map;
import tech.tablesaw.plotly.components.JSONComponent;

class CameraComponent extends JSONComponent {

  private final double x;
  private final double y;
  private final double z;

  CameraComponent(double x, double y, double z) {
    this.x = x;
    this.y = y;
    this.z = z;
  }

  @Override
  protected Map<String, Object> getJSONContext() {
    Map<String, Object> context = new HashMap<>();
    context.put("x", x);
    context.put("y", y);
    context.put("z", z);
    return context;
  }

}
